<style>
  /* Ajustes do zoom */

  body.zoom-80.iframe-mode-fullscreen #rodape {
    width: 125vw !important;
  }

  .zoom-80 #rodape {
    width: calc(125vw - 250px);
  }

  body.zoom-90.iframe-mode-fullscreen #rodape {
    width: 111vw !important;
  }

  .zoom-90 #rodape {
    width: calc(111vw - 250px);
  }

  .zoom-100 #rodape {
    width: calc(100vw - 250px);
  }

  body.zoom-110.iframe-mode-fullscreen #rodape {
    /* width: calc(104vw - 250px) !important; */
    width: calc(91vw) !important;
  }

  .zoom-110 #rodape {
    width: calc(91vw - 250px);
  }

  .zoom-80.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    width: calc(125vw - 70px);
  }

  .zoom-90.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    width: 111vw;
  }

  .zoom-100.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    width: calc(100vw - 70px);
  }

  .zoom-110.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    width: calc(99vw - 70px);
  }

  /* Para pantallas pequeñas */
  @media (max-width: 991.98px) {
    .zoom-80 #rodape {
      width: calc(125vw) !important;
    }

    .zoom-90 #rodape {
      width: calc(111vw) !important;
    }

    .zoom-100 #rodape {
      width: calc(100vw) !important;
    }

    .zoom-110 #rodape {
      width: calc(91vw) !important;
    }
  }

  #rodape {
    position: fixed;
    bottom: 0;
    z-index: 1059;
    background-color: var(--color-secondary) !important;
    width: calc(100vw - 250px);
    padding: 0.3rem 1rem !important;
    font-size: 12px !important;
  }

  body.sidebar-mini.layout-fixed.vsc-initialized.sidebar-collapse #rodape {
    z-index: 1;
  }

  body.sidebar-mini.layout-fixed.vsc-initialized.iframe-mode-fullscreen #rodape {
    z-index: 9999;
  }
</style>


<div class="main-footer" id="rodape">
  <strong>Copyright &copy; <span id="anoVigente"></span> <a target="_blank" href="https://sisplansistemas.com.br">Sisplan Sistemas</a>.</strong>
  Todos os direitos reservados.
  <div class="float-right d-none d-sm-inline-block">
    <b>Versão</b> 3.261.20.1
  </div>
  <div class="float-right d-none d-sm-inline-block" style="margin-right: 7px">
    <b>
      <p id="conexaoInternaExterna" style="margin-bottom:0px ">IP Interno   -</p>
    </b>
  </div>
</div>

<script>
  $(function() {
    $('[data-toggle="tooltip"]').tooltip()
  })

  const ano = new Date().getFullYear();
  $("#anoVigente").html(ano);

  $(window).on('load', function() {
    if (window.top === window.self) { // Verifica se a janela atual é a principal
      let totalPings = 0;
      let pings = 0;
      let latenciaTotal = 0;
      const janelaLatencia = [];
      const maxJanelaTamanho = 3; // Quantidade de ping para tirar a média 

      async function pingServidor() {
        const url = '/sisplan/funcoes/v1/ping?';

        let inicioRequisicao = performance.now();
        try {
          const response = await requisicao('GET', url, '', null);

          if (response.ok) {
            let fimRequisicao = performance.now();
            let latencia = fimRequisicao - inicioRequisicao;

            janelaLatencia.push(latencia);
            if (janelaLatencia.length > maxJanelaTamanho) {
              janelaLatencia.shift();
            }

            latenciaTotal = janelaLatencia.reduce((a, b) => a + b, 0);
            pings++;
          } else if (response.status === 401) {
            console.warn('Não autorizado. Tentando revalidar o token...');
            const revalidado = await revalidaToken();
            if (revalidado) {
              await pingServidor();
            } else {
              console.error('Falha ao revalidar o token.');
            }
          }

        } finally {
          totalPings++;
        }
      }

      setInterval(pingServidor, 60000); // Verificar a cada 1 minutos
      pingServidor();
    }
  })
</script>