$(document).ready(async function () {
  componenteFiltro('condicaoPagamento', false, false, 'CondicaoPagamentoManutencao')
  componenteFiltro('moeda', false, false, 'MoedaManutencao')
  componenteFiltro('fornecedor', false, false, 'FornecedorManutencao')

  $('#btnDesistirCapa').on('click', () => {
    resetForm('#formManutencao')
  })

  $('#formManutencao').validate({
    rules: {
      fornecedor: {
        required: true,
      },
    },
    messages: {
      fornecedor: 'Fornecedor é obrigatório.',
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback')
      element.closest('.form-group').append(error)
    },
    highlight(element) {
      $(element).addClass('is-invalid')
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid')
    },
    submitHandler: async (_form, event) => {
      event.preventDefault()
      desabilitarAlteracaoCapa()
    }
  })

  const retornarDados = () => {
    const solicitacao = $('#txtSolicitacaoManutencao').val()
    const dataEntregaPrevista = $('#txtEntregaPrevistaManutencao').val()
    const condicaoPagamento = pegaChave('#txtCondicaoPagamentoManutencao')
    const descricaoCondicaoPagamento = pegaDescricao('#txtCondicaoPagamentoManutencao')
    const moeda = pegaChave('#txtMoedaManutencao')
    const descricaoMoeda = pegaDescricao('#txtMoedaManutencao')
    const codigoFornecedor = pegaChave('#txtFornecedorManutencao')
    const nomeFornecedor = pegaDescricao('#txtFornecedorManutencao')
    const atualizarCondicao = ModalManutencaoAnaliseCotacao.atualizarCondicao
    const atualizarMoeda = ModalManutencaoAnaliseCotacao.atualizarMoeda

    const dadosAtualizados = {
      solicitacao,
      dataEntregaPrevista,
      condicaoPagamento,
      descricaoCondicaoPagamento,
      moeda,
      descricaoMoeda,
      codigoFornecedor,
      nomeFornecedor,
    }

    const opcoesAtualizar = {
      condicao: atualizarCondicao,
      moeda: atualizarMoeda,
    }

    return {
      dadosAtualizados,
      opcoesAtualizar,
    }
  }

  const resetForm = (formSelector) => {
    $(formSelector)[0].reset()
    const validator = $(formSelector).validate()
    validator.resetForm()
    $(formSelector)
      .find('.error')
      .removeClass('error')
  }

  $('#modalManutencao').on('shown.bs.modal', () => {
    ModalManutencaoAnaliseCotacao.atualizarCondicao = 'REGISTRO_SENDO_ALTERADO'
    ModalManutencaoAnaliseCotacao.atualizarMoeda = 'REGISTRO_SENDO_ALTERADO'
  })

  $('#modalManutencao').on('hide.bs.modal', () => {
    limparModal()
    $('#tabMateriais').tab('show')
    $('#tabCapa').tab('show')
    $('#cbCondicao').prop('checked', false)
    $('#cbMoeda').prop('checked', false)
    ModalManutencaoAnaliseCotacao.atualizarCondicao = 'REGISTRO_SENDO_ALTERADO'
    ModalManutencaoAnaliseCotacao.atualizarMoeda = 'REGISTRO_SENDO_ALTERADO'
  })

  const limparModal = () => $('.formManutencao').val('')

  $('#btnConfirmar').on('click', () => confirmar())

  function confirmar() {
    const { dadosAtualizados, opcoesAtualizar } = retornarDados()
    AnaliseCotacao.atualizarCotacaoSelecionada({ dados: dadosAtualizados, opcoesAtualizar })
    $('#modalManutencao').modal('hide')
  }

  $('#cbCondicao').on('change', function () {
    if (!this.checked) {
      ModalManutencaoAnaliseCotacao.atualizarCondicao = 'REGISTRO_SENDO_ALTERADO'
      return
    }
    msgAlerta(
      'Deseja atualizar a condição de todos os registros ou somente dos selecionados?',
      () => { },
      () => ModalManutencaoAnaliseCotacao.atualizarCondicao = 'REGISTROS_SELECIONADOS',
      () => ModalManutencaoAnaliseCotacao.atualizarCondicao = 'TODOS_REGISTROS',
      () => { },
      false,
      false,
      false,
      'Todos',
      'Selecionados',
    )
  })

  $('#cbMoeda').on('change', function () {
    if (!this.checked) {
      ModalManutencaoAnaliseCotacao.atualizarMoeda = 'REGISTRO_SENDO_ALTERADO'
      return
    }
    msgAlerta(
      'Deseja atualizar a moeda de todos os registros ou somente dos selecionados?',
      () => { },
      () => ModalManutencaoAnaliseCotacao.atualizarMoeda = 'REGISTROS_SELECIONADOS',
      () => ModalManutencaoAnaliseCotacao.atualizarMoeda = 'TODOS_REGISTROS',
      () => { },
      false,
      false,
      false,
      'Todos',
      'Selecionados',
    )
  })
})

window.ModalManutencaoAnaliseCotacao = window.ModalManutencaoAnaliseCotacao || {}

ModalManutencaoAnaliseCotacao.carregarModal = ({ dados }) => {
  if (!dados) {
    return
  }
  $('#txtSolicitacaoManutencao').val(dados.solicitacao ?? '')
  dados.condicaoPagamento ? insereValor('#txtCondicaoPagamentoManutencao', dados.condicaoPagamento, dados.descricaoCondicaoPagamento) : $('#txtCondicaoPagamentoManutencao').val('')
  dados.moeda ? insereValor('#txtMoedaManutencao', dados.moeda, dados.descricaoMoeda) : $('#txtMoedaManutencao').val('')
  dados.codigoFornecedor ? insereValor('#txtFornecedorManutencao', dados.codigoFornecedor, dados.nomeFornecedor) : $('#txtFornecedorManutencao').val('')
  dados.dataEntregaPrevista ? insereValor('#txtEntregaPrevistaManutencao', dados.dataEntregaPrevista.split('T')[0]) : $('#txtEntregaPrevistaManutencao').val('')
  $('#modalManutencao').modal('show')
}

ModalManutencaoAnaliseCotacao.atualizarCondicao = 'REGISTRO_SENDO_ALTERADO'
ModalManutencaoAnaliseCotacao.atualizarMoeda = 'REGISTRO_SENDO_ALTERADO'