$(document).ready(async function () {

    const produtoCodigo = await retornaCodigodoProdutoUrl();
    let ordemManutencao = 0;
    // ta aqui pra prestar manutenção? sinto muito kkkkkkkk 

    const incluirCorNaoExistente = (await CopiaParametro('PRODUTO', 5)) === '1'

    function criaPesquisaF4(input, btn) {
        $(`#${input}`).keyup(function (e) {
            if (e.keyCode == 115) {
                $(`#${btn}`).click();
                e.preventDefault();
                e.stopPropagation();
            }
        });
    }

    function ajustaIdCorConsumo(id) {
        return id.replace(/\./g, '');
    }

    $('#btn-CodigoConsumo').pesquisa_serverside(['#txtCodigoConsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
    $('#txtCodigoConsumo').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

    criaPesquisaF4('txtCodigoConsumo', 'btn-CodigoConsumo')

    $('#btnManutencao').on('click', async function () {
        $('#tabelaConsumos').DataTable().$('tr.selected').removeClass('selected');
        await carregaModalManutencao()
        $('#modal-manutencaoconsumos').modal('show')
    })

    $('#btnEdicao').on('click', async function () {
        $('#btnEdicao').addClass('d-none');
        $('#btnGravar').removeClass('d-none');
        $('#btnCancelar').removeClass('d-none');
        $('#btnImportaCons').removeClass('d-none');
        $('#btnExcluir').addClass('d-none');
        $('#btnImprimir').addClass('d-none');
        $('#btnFotoMaterial').addClass('d-none');
    });

    $('#btnCancelar').on('click', async function () {
        $('#btnEdicao').removeClass('d-none');
        $('#btnGravar').addClass('d-none');
        $('#btnCancelar').addClass('d-none');
        $('#btnImportaCons').addClass('d-none');
        $('#btnExcluir').removeClass('d-none');
        $('#btnImprimir').removeClass('d-none');
        $('#btnFotoMaterial').removeClass('d-none');
    });

    $('#cbSomenteCorAtiva').on('change', async function () {
        if ($('#cbSomenteCorAtiva').is(':checked')) {
            const cbSomenteCorAtiva = true;
            await fazConsulta(cbSomenteCorAtiva);
        } else {
            await fazConsulta(false);
        }
    });

    $('#txtCodigoConsumo').on('blur', async function () {
        if ($('#txtCodigoConsumo').val() != '') {
            try {
                $.LoadingOverlay('show');
                const codigoConsultado = pegaChave('#txtCodigoConsumo');
                window.location.href = `${btoa(codigoConsultado)}`;
            } catch (error) {
                msgErro('Não foi possível buscar os consumos.');
            } finally {
                $.LoadingOverlay('hide');
            }
        };
    });

    $('#tabelaConsumos').on('click', '#btnAlterarConsumo', async function () {
        $('#tabelaConsumos').DataTable().$('tr.selected').removeClass('selected')
        $($(this).parents("tr")).addClass('selected')
        await carregaModalManutencao()
        const data = $("#tabelaConsumos").DataTable().row($(this).parents("tr")).data()
        await retornaDadosModalModificacoes(data)
        $('#modal-manutencaoconsumos').modal('show')
    })

    $('#tabelaConsumos').on('click', '#btn-excluirConsumo', async function (event) {
        msgAlerta('Você realmente deseja excluir esse consumo?', async () => {
            try {
                $.LoadingOverlay('show');
                const data = $("#tabelaConsumos").DataTable().row($(this).parents("tr"));
                await data.remove().draw(false);
                const listaFormatada = await criaListaParaGravar();

                if (listaFormatada == '') {
                    const url = '/sisplan/cadconsumo/v1/excluitodosconsumos?';
                    const response = await requisicao("DELETE", url, `CODIGO_PROD=${produtoCodigo}`, null);
                    if (response.status == 200) {
                        criaMensagemSucesso('Consumo excluído com sucesso!', () => { window.location.reload(true) });
                    };
                } else {
                    const url = '/sisplan/cadconsumo/v1/incluiconsumos?';
                    const response = await requisicao('POST', url, '', `LISTADECONSUMOS=${encodeURIComponent(JSON.stringify({ LISTACONSUMOSCRIADOS: listaFormatada }))}`, 360000);
                    if (response.status == 200) {
                        criaMensagemSucesso('Consumo excluído com sucesso!', () => { window.location.reload(true) });
                    };
                }
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível fazer a exclusão do consumo! Verifique.');
            } finally {
                $.LoadingOverlay('hide');
            }

        });
    });

    $('#btnExcluirConsumos').on('click', async function () {
        msgAlerta('Você realmente deseja excluir todos os consumos?', async () => {
            const registroData = $("#tabelaConsumos").DataTable().rows();
            const url = '/sisplan/cadconsumo/v1/excluitodosconsumos?';
            const response = await requisicao("DELETE", url, `CODIGO_PROD=${produtoCodigo}`, null);

            if (response.status === 400) {
                msgAlerta('Não foi possível fazer a exclusão dos consumos! Verifique.');
                return;
            }

            if (response.status === 200) {
                registroData.remove().draw(false);
                criaMensagemSucesso('Todos os consumos do produto foram excluídos com sucesso!', () => { window.location.reload(true); });
                return;
            }

        });
    });

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                const url = `/sisplan/impressao/v1/imprimirconsumos?CODIGO_PRODUTO=${produtoCodigo}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelConsumos');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'RelConsumos');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function retornaCodigodoProdutoUrl() {
        const queryString = window.location.href;
        const parametros = queryString.split('/');
        const produtoUrl = atob(parametros[parametros.length - 1]);
        await preencheInputCodigo(produtoUrl);

        return produtoUrl;
    };

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item" style="width: 100%" id="btnAlterarConsumo">Alterar</button>  ' +
            '    <button type="button" class="dropdown-item" style="width: 100%" id="btn-excluirConsumo">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    function retornaBotaoOpcoesGradeTam(data) {
        let hidden
        const linhaSelecionada = $('#tabelaConsumos').DataTable().row($('tr.selected')).count() > 0
        if (linhaSelecionada) {
            hidden = 'hidden'
        } else {
            hidden = ''
        }

        var retorno = '<div style="text-align:start;"> ' +
            `    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes btnAcoesGradeConsumo" id="btnOrdemGradeTam${data}" value="${data}" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ` +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            `    <button class="dropdown-item" style="width: 100%" type="button" value="${data}" title="Alterar" id="btn-alterarGradeConsumo">Alterar</button>  ` +
            `    <button class="dropdown-item" style="width: 100%" type="button" value="${data}" title="Excluir" id="btn-excluirGradeConsumo" ${hidden}>Excluir</button>  ` +
            '</div>';
        return retorno;
    };

    function retornaCoresProdInsumoTabConsumos(linhaDataTable) {
        const titulosColunas = $('#tabelaConsumos').DataTable().columns().header().toArray().map(function (header) {
            return header.textContent
        });

        titulosColunas.splice(0, 12);
        const coresProdInsumo = [];

        for (p = 0; p < titulosColunas.length; p++) {
            const tituloSemPipe = {
                Cor_P: titulosColunas[p].substring(0, titulosColunas[p].indexOf('|')),
                Cor_I: linhaDataTable[p + 12].substring(0, linhaDataTable[p + 12].indexOf('|')),
            };
            if (tituloSemPipe.Cor_I != '') {
                coresProdInsumo.push(tituloSemPipe);
            }
        };
        return coresProdInsumo;
    };

    async function criaListaParaGravar() {
        const listaDeConsumos = [];

        const dataTabelaConsumosAntigos = $('#tabelaConsumos').DataTable().data().toArray();

        for (let i = 0; i < dataTabelaConsumosAntigos.length; i++) {
            const linha = dataTabelaConsumosAntigos[i];

            const cores = retornaCoresProdInsumoTabConsumos(linha);

            const itemExistente = listaDeConsumos.find(item =>
                item.Insumo_Codigo === linha[3] &&
                item.Insumo_Aplicacao === linha[7] &&
                item.Insumo_Faixa === linha[9] &&
                item.Insumo_Setor === linha[6]
            );

            if (itemExistente) {
                itemExistente.Insumo_ListaCores.push(...cores);
            } else {
                listaDeConsumos.push({
                    Produto_Codigo: produtoCodigo,
                    Insumo_Tipo: linha[0],
                    Insumo_IdCons: linha[1],
                    Insumo_Ordem: linha[2],
                    Insumo_Codigo: linha[3],
                    Insumo_Descricao: linha[4],
                    Insumo_Unidade: linha[5],
                    Insumo_Setor: linha[6],
                    Insumo_Aplicacao: linha[7],
                    Insumo_Parte: linha[8],
                    Insumo_Faixa: linha[9],
                    Insumo_Preco: linha[10],
                    Insumo_Consumo: linha[11],
                    Insumo_ListaCores: [...cores]
                });
            }
        }

        const tamanhosProduto = await retornaGradeTamanhosProduto(produtoCodigo);

        if ($.fn.DataTable.isDataTable('#tabelaGradeTamanho')) {

            const novosItensTabela = $('#tabelaGradeTamanho').DataTable().data().toArray()

            novosItensTabela.forEach((linhaTabela) => {
                return tamanhosProduto.forEach((tamanhoProduto) => {
                    const arrayCoresTabela = JSON.parse(linhaTabela.CORES_PRODUTO)
                    const coresProduto = arrayCoresTabela?.map((e) => {
                        return {
                            cor_p: e?.corProduto,
                            // cor_i: e?.corInsumo === '' ? '*****' : e.corInsumo,
                            cor_i: e?.corInsumo,
                            descCor_i: e?.descricaoCorInsumo,
                        }
                    })
                    const { TAMANHO: tamanho } = tamanhoProduto
                    const qtdeFormatada = parseFloat(linhaTabela[tamanho] === '' ? 0 : linhaTabela[tamanho])
                    if (qtdeFormatada > 0) {
                        listaDeConsumos.push({
                            Produto_Codigo: produtoCodigo,
                            Insumo_Tipo: linhaTabela.TIPO,
                            Insumo_IdCons: '',
                            Insumo_Ordem: listaDeConsumos.length + 1,
                            Insumo_Codigo: linhaTabela.CODIGO,
                            Insumo_Descricao: linhaTabela.DESCRICAO,
                            Insumo_Unidade: linhaTabela.UNIDADE,
                            Insumo_Setor: linhaTabela.SETOR,
                            Insumo_Aplicacao: linhaTabela.APLICACAO,
                            Insumo_Parte: linhaTabela.PARTE,
                            Insumo_Faixa: tamanho,
                            Insumo_Preco: linhaTabela[`preco${tamanho}`],
                            Insumo_Consumo: qtdeFormatada,
                            Insumo_ListaCores: coresProduto,
                        })
                    }
                })
            })
        }
        return listaDeConsumos;
    };

    async function preencheInputCodigo(sCodigoConsumo) {
        const pesquisaDescricao = {
            tabela: 'PRODUTO',
            camposSelect: ['DESCRICAO', 'UNIDADE', 'FAIXA'],
            where: [`CODIGO = '${sCodigoConsumo}'`]
        };

        const jsonProduto = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaDescricao));

        if (jsonProduto.length == 0) {
            return;
        };

        const pesquisaFaixaDesc = {
            tabela: 'FAIXA',
            camposSelect: ['DESCRICAO'],
            where: [`CODIGO = '${jsonProduto[0].FAIXA}'`]
        }

        const jsonFaixa = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaFaixaDesc));

        if (jsonFaixa.length == 0) {
            return;
        };

        $('#txtCodigoConsumo').val(`[${sCodigoConsumo}] - ${jsonProduto[0].DESCRICAO} - ${jsonProduto[0].UNIDADE}`);
        $('#txtFaixaProduto').html(`${jsonFaixa[0].DESCRICAO}`);
        $('#txtCodigoProdTittle').html(`${sCodigoConsumo} - ${jsonProduto[0].DESCRICAO}`);
    };

    async function retornaCoresProduto(cbSomenteCorAtiva) {
        const codigosCores = []
        let whereCorAtiva = '';
        if (cbSomenteCorAtiva) {
            whereCorAtiva = `AND PA_ITEN.ATIVO = 'S'`;
        };
        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR', 'CADCOR.DESCRICAO'],
            where: [`PA_ITEN.CODIGO = '${produtoCodigo}' ${whereCorAtiva}`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
        if (jsonStr.length == 0) {
            return;
        };
        const jsonFormatado = [];
        for (let i = 0; i < jsonStr.length; i++) {
            jsonFormatado.push(jsonStr[i].COR + '|' + jsonStr[i].DESCRICAO);
            codigosCores.push({ cor: jsonStr[i].COR });
        };
        return {
            jsonFormatado,
            codigosCores
        }
    };

    async function carregaDataTable(pesquisaInsumo, pesquisaCoresInsumo, cbSomenteCorAtiva, pesquisaConsumoProd) {

        if ($.fn.DataTable.isDataTable('#tabelaConsumos')) {
            $('#tabelaConsumos').DataTable().destroy();
            $('#tabelaConsumos').empty();
        };

        const dataSetCols = [];
        let dataSetData = [];
        const dataSetDataInfo = [];

        dataSetCols.push({
            title: "Tipo",
        });

        dataSetCols.push({
            title: "ID Cons",
        });

        dataSetCols.push({
            title: "Ordem",
        });

        dataSetCols.push({
            title: "Código",
        });

        dataSetCols.push({
            title: "Descrição",
        });

        dataSetCols.push({
            title: "Unid.",
        });

        dataSetCols.push({
            title: "Setor",
        });

        dataSetCols.push({
            title: "Aplic.",
        });

        dataSetCols.push({
            title: "Parte",
        });

        dataSetCols.push({
            title: "Faixa",
        });

        dataSetCols.push({
            title: "Preço",
        });

        dataSetCols.push({
            title: "Consumo",
        });


        const { jsonFormatado: coresdoProduto } = await retornaCoresProduto(cbSomenteCorAtiva);

        for (j in coresdoProduto) {
            dataSetCols.push({
                title: coresdoProduto[j],
            });
        };

        let contadorConsumo = 0;
        let agrupado

        if (pesquisaConsumoProd) {
            const chaves = ["INSUMO", "TIPO", "UNIDADE", "FAIXA", "PARTE", "APLICACAO", "SETOR"];

            let sequencial = 1;
            const chavesUsadas = [];

            agrupado = pesquisaInsumo.reduce((resultado, item) => {
                const chave = chaves.map(k => item[k]).join("|");

                const index = chavesUsadas.indexOf(chave);

                if (index === -1) {
                    chavesUsadas.push(chave);
                    resultado.push({
                        ID: sequencial,
                        ID_CONS: sequencial,
                        INSUMO: item.INSUMO,
                        TIPO: item.TIPO,
                        UNIDADE: item.UNIDADE,
                        FAIXA: item.FAIXA,
                        PARTE: item.PARTE,
                        APLICACAO: item.APLICACAO,
                        SETOR: item.SETOR,
                        DESCRICAO: item.DESCRICAO,
                        PRECO: item.PRECO,
                        DESC_APL: item.DESC_APL,
                        DESC_PARTE: item.DESC_PARTE,
                        CONSUMO: Number(item.CONSUMO)
                    });
                    sequencial++;
                }

                return resultado;
            }, []);
        } else {
            agrupado = pesquisaInsumo
        }


        for (i in agrupado) {
            contadorConsumo++

            dataSetData.push(agrupado[i].TIPO == 'P' ? 'P' : 'M');

            dataSetData.push(agrupado[i].ID_CONS);

            dataSetData.push(contadorConsumo);

            dataSetData.push(agrupado[i].INSUMO);

            dataSetData.push(agrupado[i].DESCRICAO);

            dataSetData.push(agrupado[i].UNIDADE);

            dataSetData.push(agrupado[i].SETOR);

            dataSetData.push(agrupado[i].APLICACAO);

            dataSetData.push(agrupado[i].PARTE);

            dataSetData.push(agrupado[i].FAIXA);

            dataSetData.push(agrupado[i].PRECO);

            dataSetData.push(agrupado[i].CONSUMO);

            for (y in coresdoProduto) {
                const indiceCodigoCor = coresdoProduto[y].indexOf('|');
                const apenasCodigoCor = coresdoProduto[y].substring(0, indiceCodigoCor);
                let data
                if (pesquisaConsumoProd) {
                    data = pesquisaCoresInsumo.filter(coresInsumo => coresInsumo.COR == apenasCodigoCor &&
                        coresInsumo.MATERIAL == agrupado[i].INSUMO &&
                        coresInsumo.TAM == agrupado[i].FAIXA &&
                        coresInsumo.APLICACAO == agrupado[i].APLICACAO &&
                        coresInsumo.PARTE == agrupado[i].PARTE &&
                        coresInsumo.SETOR == agrupado[i].SETOR)
                } else {
                    data = pesquisaCoresInsumo.filter(coresInsumo => coresInsumo.ID == pesquisaInsumo[i].ID && coresInsumo.COR == apenasCodigoCor);
                }
                if (data.length > 0) {
                    dataSetData.push(data[0].COR_I + '|' + data[0].DESC_COR);
                } else {
                    dataSetData.push('');
                }

            };

            dataSetDataInfo.push(dataSetData);
            dataSetData = [];
        }

        if (pesquisaInsumo == 0 && pesquisaCoresInsumo == 0) {
            $('#tabelaConsumos').DataTable({
                bPaginate: false,
                autoWidth: true,
                searching: false,
                destroy: true,

                columns: dataSetCols,
            });
        } else {
            $('#tabelaConsumos').DataTable({
                bPaginate: false,
                searching: false,
                scrollX: false,
                destroy: true,
                autoWidth: true,
                columns: dataSetCols,
                data: dataSetDataInfo,
                columnDefs: [
                    {
                        targets: [11],
                        render(data) {
                            return parseFloat(data).toFixed(5).replace('.', ',')
                        }
                    },
                    {
                        targets: [1],
                        render(data) {
                            return retornaBotaoOpcoes(data)
                        }
                    },
                    {
                        targets: [2],
                        visible: false,
                    },
                ]
            });
        }
    };

    async function fazConsulta(cbSomenteCorAtiva) {
        const ValidaConsumoProd = {
            tabela: "CONSUMOPROD",
            camposSelect: ["COUNT(*) AS QTDE"],
            where: [`PRODUTO = '${produtoCodigo}'`],
        };

        const jsonStrValidaConsumoProd = await retornaJsonPesquisaPadrao(JSON.stringify(ValidaConsumoProd));

        let jsonStrPesquisaCoresInsumo = [];
        let jsonStrPesquisaInsumo = [];
        let pesquisaConsumoProd = false

        if (jsonStrValidaConsumoProd && parseInt(jsonStrValidaConsumoProd[0].QTDE) > 0) {
            pesquisaConsumoProd = true

            const PesquisaInsumoMock = {
                tabela: "CONSUMOPROD",
                camposSelect: ["CONSUMOPROD.ID ID_CONS",
                    "CONSUMOPROD.ID",
                    "CONSUMOPROD.MATERIAL INSUMO",
                    "CONSUMOPROD.SETOR",
                    "CONSUMOPROD.APLICACAO",
                    "CONSUMOPROD.PARTE",
                    "CONSUMOPROD.TAM FAIXA",
                    "COALESCE(MAX(CASE WHEN CONSUMOPROD.PRECO = 'N' THEN 'N' END), MAX(CONSUMOPROD.PRECO), 'S') AS PRECO",
                    "CONSUMOPROD.CONSUMO ",
                    "CASE WHEN MATERIAL.DESCRICAO IS NULL THEN 'P' ELSE 'M' END TIPO",
                    "CASE WHEN MATERIAL.DESCRICAO IS NULL THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO",
                    "CASE WHEN MATERIAL.DESCRICAO IS NULL THEN PRODUTO.UNIDADE ELSE MATERIAL.UNIDADE END UNIDADE",
                    "PCPAPL.DESCRICAO DESC_APL",
                    "TIPO_APL.DESCRICAO AS DESC_PARTE"
                ],
                leftJoin: [
                    { "tabela": "MATERIAL", "condicao": "CONSUMOPROD.MATERIAL = MATERIAL.CODIGO AND CONSUMOPROD.IDMAT = MATERIAL.ID" },
                    { "tabela": "PRODUTO", "condicao": "CONSUMOPROD.MATERIAL = PRODUTO.CODIGO AND CONSUMOPROD.IDMAT = PRODUTO.ID" },
                    { "tabela": "PCPAPL", "condicao": "PCPAPL.CODIGO = CONSUMOPROD.APLICACAO" },
                    { "tabela": "TIPO_APL", "condicao": "CONSUMOPROD.PARTE = TIPO_APL.CODIGO" }
                ],
                where: [`CONSUMOPROD.PRODUTO = '${produtoCodigo}'`],
                groupBy: ["CONSUMOPROD.ID",
                    "CONSUMOPROD.ID",
                    "CONSUMOPROD.MATERIAL",
                    "CONSUMOPROD.SETOR",
                    "CONSUMOPROD.APLICACAO",
                    "CONSUMOPROD.PARTE",
                    "CONSUMOPROD.TAM",
                    "CONSUMOPROD.CONSUMO ",
                    "PCPAPL.DESCRICAO",
                    "TIPO_APL.DESCRICAO",
                    "MATERIAL.DESCRICAO",
                    "PRODUTO.UNIDADE",
                    "PRODUTO.DESCRICAO",
                    "MATERIAL.UNIDADE"],
                orderBy: ["CONSUMOPROD.ID"]
            };

            jsonStrPesquisaInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaInsumoMock));

            const PesquisaCoresInsumoMock = {
                tabela: "CONSUMOPROD",
                camposSelect: ["CONSUMOPROD.COR_INSUMO COR_I",
                    "'' LOTE_TINTUR",
                    "CADCOR.DESCRICAO DESC_COR",
                    "CONSUMOPROD.ID",
                    "CONSUMOPROD.COR_PROD COR",
                    "CADCOR2.DESCRICAO DESC_COR2",
                    "CONSUMOPROD.PRODUTO CODIGO",
                    "CONSUMOPROD.MATERIAL",
                    "CONSUMOPROD.TAM",
                    "CONSUMOPROD.SETOR",
                    "CONSUMOPROD.APLICACAO",
                    "CONSUMOPROD.PARTE"
                ],
                leftJoin: [
                    { "tabela": "CADCOR", "condicao": "CADCOR.COR = CONSUMOPROD.COR_INSUMO" },
                    { "tabela": "CADCOR", "alias": "CADCOR2", "condicao": "CADCOR2.COR = CONSUMOPROD.COR_PROD" }
                ],
                where: [`CONSUMOPROD.PRODUTO = '${produtoCodigo}'`]
            };

            jsonStrPesquisaCoresInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCoresInsumoMock));


        } else {

            const PesquisaInsumo = {
                tabela: "PCPFT2",
                camposSelect: ["PCPFT2.*",
                    "CASE WHEN PCPFT2.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO",
                    "CASE WHEN PCPFT2.TIPO = 'P' THEN PRODUTO.UNIDADE ELSE MATERIAL.UNIDADE END UNIDADE",
                    "PCPAPL.DESCRICAO DESC_APL",
                    "TIPO_APL.DESCRICAO AS DESC_PARTE"
                ],
                leftJoin: [
                    { "tabela": "MATERIAL", "condicao": "PCPFT2.INSUMO = MATERIAL.CODIGO" },
                    { "tabela": "PRODUTO", "condicao": "PCPFT2.INSUMO = PRODUTO.CODIGO" },
                    { "tabela": "PCPAPL", "condicao": "PCPAPL.CODIGO = PCPFT2.APLICACAO" },
                    { "tabela": "TIPO_APL", "condicao": "PCPFT2.PARTE = TIPO_APL.CODIGO" }
                ],
                where: [`PCPFT2.CODIGO = '${produtoCodigo}'`],
                orderBy: ["PCPFT2.ID"]
            };

            jsonStrPesquisaInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaInsumo));

            const PesquisaCoresInsumo = {
                tabela: "PCPFT3",
                camposSelect: ["PCPFT3.COR_I",
                    "PCPFT3.LOTE_TINTUR",
                    "CADCOR.DESCRICAO DESC_COR",
                    "PCPFT3.ID",
                    "PCPFT3.COR",
                    "CADCOR2.DESCRICAO DESC_COR2",
                    "PCPFT3.CODIGO"
                ],
                leftJoin: [
                    { "tabela": "CADCOR", "condicao": "PCPFT3.COR_I = CADCOR.COR" },
                    { "tabela": "CADCOR", "alias": "CADCOR2", "condicao": "PCPFT3.COR = CADCOR2.COR" }
                ],
                where: [`PCPFT3.CODIGO = '${produtoCodigo}'`]
            };

            jsonStrPesquisaCoresInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCoresInsumo));

        }
        await carregaDataTable(jsonStrPesquisaInsumo, jsonStrPesquisaCoresInsumo, cbSomenteCorAtiva, pesquisaConsumoProd);
        $('.btnFooter').prop('disabled', false)
    };

    await fazConsulta(false);

    await preencheDivConsumosPorTamanho();
    await retornaCoresDoProduto();
    await criaDataTableCoresInsumo(false);

    /// aqui começa as funções do modal de manutenção 

    function bloqueiaCamposModal() {
        $('#txtInsumo').prop('disabled', true);
        $('#txtSetorInsumo').prop('disabled', true);
        $('#txtAplicacaoInsumo').prop('disabled', true);
        $('#txtParteInsumo').prop('disabled', true);
        $('#btn-CodigoInsumo').prop('disabled', true);
        $('#btn-CodigoInsumoProd').prop('disabled', true);
        $('#btn-limpa-CodigoInsumo').prop('disabled', true);
        $('#btn-SetorInsumo').prop('disabled', true);
        $('#btn-limpa-SetorInsumo').prop('disabled', true);
        $('#btn-AplicacaoInsumo').prop('disabled', true);
        $('#btn-limpa-AplicacaoInsumo').prop('disabled', true);
        $('#btn-ParteInsumo').prop('disabled', true);
        $('#btn-limpa-ParteInsumo').prop('disabled', true);
        $('#btn-limpa-CodigoInsumo').prop('disabled', true);
        $('.inputsTamanho').prop('disabled', true);
        $('.inputsCorInsumo').prop('disabled', true);
        $('#checkAtualizaQtdeTamanhos').prop('disabled', true);
        $('#checkAtualizaCores').prop('disabled', true);
    };

    function desbloqueiaCamposModal() {
        $('#txtInsumo').prop('disabled', false);
        $('#txtSetorInsumo').prop('disabled', false);
        $('#txtAplicacaoInsumo').prop('disabled', false);
        $('#txtParteInsumo').prop('disabled', false);
        $('.inputsCorInsumo').prop('disabled', false);
        $('#checkAtualizaCores').prop('disabled', false);
        $('#checkAtualizaQtdeTamanhos').prop('disabled', false);
        $('.inputsTamanho').prop('disabled', false);
        $('#btn-CodigoInsumo').prop('disabled', false);
        $('#btn-CodigoInsumoProd').prop('disabled', false);
        $('#btn-limpa-CodigoInsumo').prop('disabled', false);
        $('#btn-SetorInsumo').prop('disabled', false);
        $('#btn-limpa-SetorInsumo').prop('disabled', false);
        $('#btn-AplicacaoInsumo').prop('disabled', false);
        $('#btn-limpa-AplicacaoInsumo').prop('disabled', false);
        $('#btn-ParteInsumo').prop('disabled', false);
        $('#btn-limpa-ParteInsumo').prop('disabled', false);
        $('#btn-limpa-CodigoInsumo').prop('disabled', false);
    };

    function retornaInputDeCorInsumo({ COR: cor }) {
        return `<div class="input-group">
        <input type="text" autocomplete="off" class="input-default focus form-control inputsCorInsumo" disabled id="txtCorInsumo${ajustaIdCorConsumo(cor)}" name="txtCorInsumo${ajustaIdCorConsumo(cor)}" class="form-control" data-cor="${ajustaIdCorConsumo(cor)}">
        <div class="input-group-append">
            <button class="btn bg-danger btn-consumo" id="btn-CorInsumo${ajustaIdCorConsumo(cor)}" name="btn-CorInsumo${ajustaIdCorConsumo(cor)}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
        </div>
        </div>`
    };

    function retornaInputDeDescricaoInsumo({ COR: cor }) {
        return `<input type="text" class="input-default form-control descInsumo" disabled id="txtDescricaoInsumo${ajustaIdCorConsumo(cor)}" class="form-control"></input>`
    };

    async function retornaCoresDoProduto() {

        const dataSetCols = [];

        dataSetCols.push({
            title: 'Cor',
            data: 'COR'
        });

        dataSetCols.push({
            title: 'Descrição',
            data: 'DESCRICAO'
        });

        dataSetCols.push({
            title: '<div>Cor Insumo(F4)<i class="fas fa-check ml-1 mt-1" id="checkAtualizaCores" disabled class="checkAtualizaCores" title="Aplicar a cor para todos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em; cursor: pointer;"/></div>',
            data: 'CAMPOVAZIO1'
        });

        dataSetCols.push({
            title: 'Descrição Cor Insumo',
            data: 'CAMPOVAZIO2'
        });

        const pesquisaParam = {
            tabela: 'PA_ITEN',
            camposSelect: ['DISTINCT PA_ITEN.COR', 'CADCOR.DESCRICAO', `'CAMPOVAZIO1' AS CAMPOVAZIO1`, `'CAMPOVAZIO2' AS CAMPOVAZIO2 `],
            where: [`PA_ITEN.CODIGO = '${produtoCodigo}'`],
            innerJoin: [{ tabela: "CADCOR", condicao: "PA_ITEN.COR = CADCOR.COR" }]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        if (jsonStr.length == 0) {
            return;
        };

        if ($.fn.DataTable.isDataTable('#tabelaCoresProduto')) {
            $("#tabelaCoresProduto").DataTable().destroy();
            $("#tabelaCoresProduto").empty();
        };

        $('#tabelaCoresProduto').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            autoWidth: true,
            scrollY: '100px',
            searching: false,
            destroy: true,
            columns: dataSetCols,
            columnDefs: [
                {
                    targets: [2, 3], render: function (data, _, row) {
                        if (data == 'CAMPOVAZIO1') {
                            return retornaInputDeCorInsumo(row);
                        } else if (data == 'CAMPOVAZIO2') {
                            return retornaInputDeDescricaoInsumo(row);
                        }
                    }
                }
            ],
            data: jsonStr,
        });
    };

    $('#checkAtualizaCores').on('click', function () {
        const primeiraCor = $('.inputsCorInsumo').first().val();
        const primeiraDesc = $('.descInsumo').first().val();

        if (!primeiraCor && !primeiraDesc) {
            return;
        }

        msgAguardaConfirmacao('Deseja aplicar esta cor e descrição para todos os insumos?', () => {
            $('.inputsCorInsumo').not(':first').val(primeiraCor).trigger('blur');
            $('.descInsumo').not(':first').val(primeiraDesc).trigger('blur');
        });
    });


    // async function retornaTargets(tamanhosProduto) {
    //     const listaTargets = [];
    //     for (u in tamanhosProduto) {
    //         listaTargets.push(u)
    //     };

    //     return listaTargets;
    // };

    async function preencheDivConsumosPorTamanho() {
        const tamanhosProd = await retornaGradeTamanhosProduto(produtoCodigo);

        if ($.fn.DataTable.isDataTable('#tabelaTamanhosDiv')) {
            $("#tabelaTamanhosDiv").DataTable().destroy();
            $("#tabelaTamanhosDiv").empty();
        };

        const listaTams = [];
        const listaTamsData = [];
        let objTamanhoData = {};

        for (h in tamanhosProd) {
            if (h == 0) {
                listaTams.push({
                    'title': `<div style="padding-left: 28px;">${tamanhosProd[h].TAMANHO}<i class="fas fa-check ml-1 mt-1" id="checkAtualizaQtdeTamanhos" disabled class="checkAtualizaQtdeTamanhos" title="Aplicar a qtde digitada para todos os tamanhos(somente o primeiro valor para os demais)" style="color: #32CD32; font-size: 1.0em; cursor: pointer;"/></div>`,
                    'data': tamanhosProd[h].TAMANHO,
                    'width': '75px'
                });

                objTamanhoData[`${tamanhosProd[h].TAMANHO}`] = `
                    <div>
                        <input type="text" autocomplete="off" class="input-default focus form-control inputsTamanho inputPrimeiroTamanho" style="width: 70px; padding: 0px 5px" disabled id="txtTamanho${tamanhosProd[h].TAMANHO}" name="txtTamanho${tamanhosProd[h].TAMANHO}" class="form-control">
                        <div class="flex align-center mt-1" title="Define se irá considerar este tamanho na formação de custo.">
                            <input type="checkbox" class="chPreco" id="chPreco${tamanhosProd[h].TAMANHO}" name="chPreco${tamanhosProd[h].TAMANHO}" style="max-width: 10px !imoprtant; max-heith: 10px !imoprtant;">
                            <label class="form-check-label ml-1" style="font-size:80%" for="chPreco${tamanhosProd[h].TAMANHO}">Preço</label>
                        </div>
                    </div>
                    `;
            } else {
                listaTams.push({
                    'title': `<div style="padding-left: 28px;">${tamanhosProd[h].TAMANHO}</div>`,
                    'data': tamanhosProd[h].TAMANHO,
                    'width': '75px'
                });

                objTamanhoData[`${tamanhosProd[h].TAMANHO}`] = `
                    <div>
                        <input type="text" autocomplete="off" class="input-default focus form-control inputsTamanho" style="width: 70px; padding: 0px 5px" disabled id="txtTamanho${tamanhosProd[h].TAMANHO}" name="txtTamanho${tamanhosProd[h].TAMANHO}" class="form-control">
                        <div class="flex align-center mt-1" title="Define se irá considerar este tamanho na formação de custo.">
                            <input type="checkbox" class="chPreco" id="chPreco${tamanhosProd[h].TAMANHO}" name="chPreco${tamanhosProd[h].TAMANHO}" style="max-width: 10px !imoprtant; max-heith: 10px !imoprtant;">
                            <label class="form-check-label ml-1" style="font-size:80%" for="chPreco${tamanhosProd[h].TAMANHO}">Preço</label>
                        </div>
                    </div>
                    `;
            }
        };

        listaTamsData.push(objTamanhoData);

        $('#tabelaTamanhosDiv').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            autoWidth: true,
            // scrollY: '100px',
            scrollX: true,
            searching: false,
            destroy: true,
            columns: listaTams,
            data: listaTamsData,
        });

        //aplicarEstilosNasCelulas()
    };

    $('#checkAtualizaQtdeTamanhos').on('click', function () {
        const primeiroValor = $('.inputPrimeiroTamanho').val();

        if (!parseFloat(primeiroValor)) {
            return;
        }

        msgAguardaConfirmacao('Deseja aplicar a primeira quantidade para todos os tamanhos?', () => {
            $('.inputsTamanho').not('.inputPrimeiroTamanho').val(primeiroValor).trigger('blur');
        });
    });

    function aplicarEstilosNasCelulas() {
        const cells = document.querySelectorAll('#tabelaTamanhosDiv tbody td');

        cells.forEach(cell => {
            cell.style.width = '70px';
            cell.style.overflow = 'hidden';
        });
    }

    async function retornaGradeTamanhosProduto(codigo) {
        const pesquisaTamanhos = {
            tabela: 'PRODUTO',
            camposSelect: ['FAIXA_ITEN.TAMANHO '],
            innerJoin: [
                { "tabela": "FAIXA_ITEN", "condicao": "PRODUTO.FAIXA = FAIXA_ITEN.FAIXA" }
            ],
            where: [`PRODUTO.CODIGO = '${codigo}'`],
            orderBy: ['FAIXA_ITEN.POSICAO']
        };

        const jsonStrTamanhos = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaTamanhos));

        return jsonStrTamanhos;
    };

    async function criaPesquisas(ehProduto) {

        const insumoCodigo = pegaChave('#txtInsumo')

        if (insumoCodigo == '') {
            return;
        }

        const { codigosCores } = await retornaCoresProduto();

        if (incluirCorNaoExistente) {
            codigosCores.forEach((e) => {
                const tabela = ehProduto ? 'PA_ITEN' : 'MAT_ITEN'
                const pesquisaServerside = {
                    tabela: 'CADCOR',
                    camposSelect: [`COR`, "DESCRICAO"],
                }

                const pesquisaAutocompleta = {
                    tabela: 'CADCOR',
                    camposSelect: [`COR CHAVE`, "DESCRICAO"],
                }

                const idCorConsumo = ajustaIdCorConsumo(e?.cor)
                $(`#btn-CorInsumo${idCorConsumo}`).pesquisa_serverside(
                    [`#txtCorInsumo${idCorConsumo}`, `#txtDescricaoInsumo${idCorConsumo}`],
                    ['COR', 'DESCRICAO'],
                    ['DESCRICAO', 'COR'],
                    JSON.stringify(pesquisaServerside),
                    'Pesquisa de Cor',
                    '',
                    [true, true],
                )
                $(`#txtCorInsumo${idCorConsumo}`).autocompleta(
                    1,
                    `JSON=${JSON.stringify(pesquisaAutocompleta)}`,
                    [`#txtCorInsumo${idCorConsumo}`, `#txtDescricaoInsumo${idCorConsumo}`],
                    ['CHAVE', 'DESCRICAO'],
                    [],
                    () => { },
                    [true, true],
                )
                criaPesquisaF4(`txtCorInsumo${idCorConsumo}`, `btn-CorInsumo${idCorConsumo}`)
            })
            return
        }

        codigosCores.forEach((e) => {
            const tabela = ehProduto ? 'PA_ITEN' : 'MAT_ITEN'
            $(`#btn-CorInsumo${ajustaIdCorConsumo(e?.cor)}`).pesquisa_serverside([`#txtCorInsumo${ajustaIdCorConsumo(e?.cor)}`, `#txtDescricaoInsumo${ajustaIdCorConsumo(e?.cor)}`], ['CADCOR.COR', 'CADCOR.DESCRICAO'], ['CADCOR.DESCRICAO', 'CADCOR.COR'], `{ "tabela": "${tabela}", "camposSelect": ["CADCOR.COR", "CADCOR.DESCRICAO"], "innerJoin": [{ "tabela": "CADCOR", "condicao": "CADCOR.COR = ${tabela}.COR" }], "where": ["${tabela}.CODIGO = '${insumoCodigo}'"], "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"] }`, 'Pesquisa de Cor', '', [true, true])
            $(`#txtCorInsumo${ajustaIdCorConsumo(e?.cor)}`).autocompleta(1, `JSON={ "tabela": "${tabela}", "camposSelect": ["CADCOR.COR CHAVE", "CADCOR.DESCRICAO"], "innerJoin": [{ "tabela": "CADCOR", "condicao": "CADCOR.COR = ${tabela}.COR" }], "where": ["${tabela}.CODIGO = '${insumoCodigo}'"], "groupBy": ["CADCOR.COR", "CADCOR.DESCRICAO"] }`, [`#txtCorInsumo${ajustaIdCorConsumo(e?.cor)}`, `#txtDescricaoInsumo${ajustaIdCorConsumo(e?.cor)}`], ['CHAVE', 'DESCRICAO'], [], () => { }, [true, true])
            criaPesquisaF4(`txtCorInsumo${ajustaIdCorConsumo(e?.cor)}`, `btn-CorInsumo${ajustaIdCorConsumo(e?.cor)}`);
        })
    };

    function limpaCampos() {
        $('.inputsTamanho').val('');
        $('.inputsCorInsumo').val('');
        $('.descInsumo').val('');
        $('#txtInsumo').val('');
        $('#txtSetorInsumo').val('');
        $('#txtAplicacaoInsumo').val('');
        $('#txtParteInsumo').val('');
    };

    async function pesquisaUnidadeInsumo(bProduto) {

        if ($('#txtInsumo').val() == '') {
            return;
        }

        const pesquisaUnidadeInsumo = {
            tabela: !bProduto ? 'MATERIAL' : 'PRODUTO',
            camposSelect: ['UNIDADE'],
            where: [`CODIGO = '${pegaChave('#txtInsumo')}'`],
        };

        const jsonStrTamanhos = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaUnidadeInsumo));

        return jsonStrTamanhos[0].UNIDADE;
    };

    async function pesquisaSetorInsumo(setor) {

        if (setor == '') {
            return;
        }

        const pesquisaSetorInsumo = {
            tabela: 'CADFLUXO',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${setor}'`],
        };

        const jsonStrSetor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSetorInsumo));

        const setorFormatado = `[${jsonStrSetor[0].CODIGO}] - ${jsonStrSetor[0].DESCRICAO}`

        return setorFormatado;
    };

    async function pesquisaAplicacaoInsumo(aplicacao) {

        if (aplicacao == '') {
            return;
        }

        const pesquisaAplicacaoinsumo = {
            tabela: 'PCPAPL',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${aplicacao}'`],
        };

        const jsonStrAplicacao = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaAplicacaoinsumo));

        const aplicacaoFormatada = `[${jsonStrAplicacao[0].CODIGO}] - ${jsonStrAplicacao[0].DESCRICAO}`

        return aplicacaoFormatada;
    };

    async function pesquisaParteInsumo(parte) {

        if (parte == '') {
            return;
        }

        const pesquisaParteInsumo = {
            tabela: 'TIPO_APL',
            camposSelect: ['CODIGO', 'DESCRICAO'],
            where: [`CODIGO = '${parte}'`],
        };

        const jsonStrParte = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParteInsumo));

        const parteFormatada = `[${jsonStrParte[0].CODIGO}] - ${jsonStrParte[0].DESCRICAO}`

        return parteFormatada;
    };

    async function adicionaRegistroGradeTam() {

        ///pelo amor de Deus, se tiver duvida, pergunta, nao mexa nisso sem saber o pq das coisa..... bruno
        const insumoCodigo = pegaChave('#txtInsumo');
        const bProduto = await validaSeEhProduto(insumoCodigo)
        const arrayTamanhos = await retornaGradeTamanhosProduto(produtoCodigo);
        const tabelaGradeTamanho = $("#tabelaGradeTamanho").DataTable()
        const linhaSelecionada = tabelaGradeTamanho.rows(".selected")
        const indexes = linhaSelecionada.indexes().toArray()
        const novaOrdem = tabelaGradeTamanho.rows().count() + 1

        if (indexes && indexes.length > 0) {
            throw new Error()
        }

        const novaLinha = {
            TIPO: bProduto ? 'P' : 'M',
            ORDEM: retornaBotaoOpcoesGradeTam(novaOrdem),
            CODIGO: pegaChave('#txtInsumo'),
            DESCRICAO: pegaDescricao('#txtInsumo'),
            UNIDADE: $('#txtUndInsumo').val(),
            SETOR: pegaChave('#txtSetorInsumo'),
            APLICACAO: pegaChave('#txtAplicacaoInsumo'),
            PARTE: pegaChave('#txtParteInsumo'),
        }

        const coresProdutoData = $('#tabelaCoresProduto').DataTable().data().toArray()
        const arrayCoresProduto = coresProdutoData?.map((e) => {
            return {
                corProduto: e?.COR,
                corInsumo: $(`#txtCorInsumo${ajustaIdCorConsumo(e?.COR)}`).val(),
                descricaoCorInsumo: $(`#txtDescricaoInsumo${ajustaIdCorConsumo(e?.COR)}`).val(),
            }
        })
        novaLinha.CORES_PRODUTO = JSON.stringify(arrayCoresProduto)

        const coresInsumoData = $('#tabelaCoresInsumo').DataTable().data().toArray()
        const arrayCoresInsumo = coresInsumoData?.map((e) => {
            return {
                cor: e?.COR,
                descricao: e?.DESCRICAO,
            }
        })
        novaLinha.CORES_INSUMO = JSON.stringify(arrayCoresInsumo)

        arrayTamanhos?.forEach((e) => {
            const { TAMANHO: tamanho } = e
            novaLinha[tamanho] = $(`#txtTamanho${tamanho}`).val()
            novaLinha[`preco${tamanho}`] = $(`#chPreco${tamanho}`).is(':checked') ? 'S' : 'N'
        })

        tabelaGradeTamanho.row.add(novaLinha).draw(false)

        limpaCampos();
        bloqueiaCamposModal();
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnAbreImportarCons').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
    };

    async function alteraRegistroGradeTam() {

        ///pelo amor de Deus, se tiver duvida, pergunta, nao mexa nisso sem saber o pq das coisa..... bruno

        try {
            const arrayTamanhos = await retornaGradeTamanhosProduto(produtoCodigo);
            const tabelaGradeTamanho = $("#tabelaGradeTamanho").DataTable()
            const linhaSelecionada = tabelaGradeTamanho.rows(".selected")

            const indexes = linhaSelecionada.indexes().toArray()

            if (indexes && indexes.length > 1) {
                throw new Error()
            }

            const [index] = indexes
            const currentRowData = tabelaGradeTamanho.row(index).data()

            const novaLinha = {
                ...currentRowData,
                CODIGO: pegaChave('#txtInsumo'),
                DESCRICAO: pegaDescricao('#txtInsumo'),
                UNIDADE: $('#txtUndInsumo').val(),
                SETOR: pegaChave('#txtSetorInsumo'),
                APLICACAO: pegaChave('#txtAplicacaoInsumo'),
                PARTE: pegaChave('#txtParteInsumo'),
            }

            const coresProdutoData = $('#tabelaCoresProduto').DataTable().data().toArray()
            const arrayCoresProduto = coresProdutoData?.map((e) => {
                return {
                    corProduto: e?.COR,
                    corInsumo: $(`#txtCorInsumo${ajustaIdCorConsumo(e?.COR)}`).val(),
                    descricaoCorInsumo: $(`#txtDescricaoInsumo${ajustaIdCorConsumo(e?.COR)}`).val(),
                }
            })
            novaLinha.CORES_PRODUTO = JSON.stringify(arrayCoresProduto)

            const coresInsumoData = $('#tabelaCoresInsumo').DataTable().data().toArray()
            const arrayCoresInsumo = coresInsumoData?.map((e) => {
                return {
                    cor: e?.COR,
                    descricao: e?.DESCRICAO,
                }
            })
            novaLinha.CORES_INSUMO = JSON.stringify(arrayCoresInsumo)

            arrayTamanhos?.forEach((e) => {
                const { TAMANHO: tamanho } = e
                novaLinha[tamanho] = $(`#txtTamanho${tamanho}`).val()
                novaLinha[`preco${tamanho}`] = $(`#chPreco${tamanho}`).is(':checked') ? 'S' : 'N'
            })

            tabelaGradeTamanho.row(index).data(novaLinha).draw(false)
            tabelaGradeTamanho.$("tr.selected").removeClass("selected")
            $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um erro ao confirmar.')
        }
    };

    async function criaDataTableCoresInsumo(insumoTaInformado) {

        if ($.fn.DataTable.isDataTable('#tabelaCoresInsumo')) {
            $("#tabelaCoresInsumo").DataTable().destroy();
            $("#tabelaCoresInsumo").empty();
        };

        const bProduto = await validaSeEhProduto(pegaChave('#txtInsumo'))

        const tabela = bProduto ? 'PA_ITEN' : 'MAT_ITEN'

        const insumoPesquisado = pegaChave('#txtInsumo');

        const pesquisaCoresInsumo = {
            tabela,
            camposSelect: ['DISTINCT CADCOR.COR', 'CADCOR.DESCRICAO'],
            innerJoin: [
                { "tabela": "CADCOR", "condicao": `CADCOR.COR = ${tabela}.COR` }
            ],
            where: [`${tabela}.CODIGO = '${insumoPesquisado}'`],
        };

        const jsonStrCoresInsumo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCoresInsumo));

        const colunasDataTable = [];

        colunasDataTable.push({
            'title': 'Cor',
            'data': 'COR',
        });

        colunasDataTable.push({
            'title': 'Descrição',
            'data': 'DESCRICAO'
        });

        if (insumoTaInformado && insumoPesquisado != '') {

            $('#tabelaCoresInsumo').DataTable({
                bPaginate: false,
                order: false,
                sort: false,
                autoWidth: true,
                scrollY: '100px',
                searching: false,
                destroy: true,
                columns: colunasDataTable,
                data: jsonStrCoresInsumo,
            });

        } else {

            $('#tabelaCoresInsumo').DataTable({
                bPaginate: false,
                order: false,
                sort: false,
                autoWidth: true,
                scrollY: '100px',
                searching: false,
                destroy: true,
                columns: colunasDataTable,
            });
        }
    };

    async function criaDataTableGradeTam(data = []) {

        if ($.fn.DataTable.isDataTable('#tabelaGradeTamanho')) {
            $("#tabelaGradeTamanho").DataTable().destroy();
            $("#tabelaGradeTamanho").empty();
        };

        const tamanhosProduto = await retornaGradeTamanhosProduto(produtoCodigo);

        const dataSetCols = [
            {
                title: 'Ordem',
                data: 'ORDEM'

            },
            {
                title: 'Código',
                data: 'CODIGO'
            },
            {
                title: 'Descrição',
                data: 'DESCRICAO'
            },
            {
                title: 'Unid.',
                data: 'UNIDADE'
            },
            {
                title: 'Setor',
                data: 'SETOR'
            },
            {
                title: 'Aplic.',
                data: 'APLICACAO'
            },
            {
                title: 'Parte.',
                data: 'PARTE'
            }
        ]

        const colunasInvisiveis = []

        if (tamanhosProduto.length > 0) {
            for (i in tamanhosProduto) {
                dataSetCols.push({
                    title: tamanhosProduto[i]?.TAMANHO,
                    data: tamanhosProduto[i]?.TAMANHO,
                })
                dataSetCols.push({
                    title: `preco${tamanhosProduto[i]?.TAMANHO}`,
                    data: `preco${tamanhosProduto[i]?.TAMANHO}`,
                })
                colunasInvisiveis.push(`preco${tamanhosProduto[i]?.TAMANHO}`)
            };
        }


        dataSetCols.push(
            {
                title: 'Cores Produto',
                data: 'CORES_PRODUTO',
            },
            {
                title: 'Cores Insumo',
                data: 'CORES_INSUMO',
            },
            {
                title: 'Tipo',
                data: 'TIPO',
            }
        )

        colunasInvisiveis.push('CORES_PRODUTO')
        colunasInvisiveis.push('CORES_INSUMO')
        colunasInvisiveis.push('TIPO')

        const colunasOcultas = []

        dataSetCols.forEach((item, index) => {
            if (colunasInvisiveis.includes(item.data)) {
                colunasOcultas.push(index)
            }
        })

        $('#tabelaGradeTamanho').DataTable({
            bPaginate: false,
            order: false,
            sort: false,
            searching: false,
            destroy: true,
            columnDefs: [
                {
                    targets: colunasOcultas,
                    visible: false,
                }
            ],
            columns: dataSetCols,
            data,
        })
    };

    async function removeCoresSemConsumo(listaInsumos) {
        for (i = 0; i < listaInsumos.length; i++) {

            const novaListaCores = [];

            for (k = 0; k < listaInsumos[i].CORES_LISTA.length; k++) {
                const CorP = listaInsumos[i].CORES_LISTA[k].Cor_P;
                const CorI = listaInsumos[i].CORES_LISTA[k].Cor_I;
                const descCorP = listaInsumos[i].CORES_LISTA[k].DescCor_P;
                const descCorI = listaInsumos[i].CORES_LISTA[k].DescCor_I;

                const novaCorLista = {
                    Cor_P: CorP,
                    Cor_I: CorI,
                    DescCor_P: descCorP,
                    DescCor_I: descCorI
                };

                if (novaListaCores.length <= 0) {
                    novaListaCores.push(novaCorLista);
                } else {

                    const index = novaListaCores.findIndex(item => item.Cor_P == CorP);

                    if (index != -1) {
                        if (novaListaCores[index].Cor_I == '') {
                            novaListaCores[index].Cor_I = CorI
                            novaListaCores[index].DescCor_I = descCorI
                        }
                    } else {
                        novaListaCores.push(novaCorLista)
                    }
                };
            };

            listaInsumos[i].CORES_LISTA = novaListaCores;
        };

        return listaInsumos;
    };

    async function importaConsumos(produtoImportado, descricaoProdutoImportado, parteImportada) {
        $.LoadingOverlay('show');

        try {
            const camposFiltro = {
                produto: produtoImportado,
                parte: parteImportada,
            }

            const response = await requisicao("GET", '/sisplan/cadconsumo/v1/retornadadosimportacao?', `FILTROS=${JSON.stringify(camposFiltro)}`, null);

            if (response.status !== 200) {
                throw new Error()
            }

            responseJson = await response.json()

            const { resultado } = responseJson
            const arrayTamanhos = await retornaGradeTamanhosProduto(produtoCodigo);
            const listaCoresProd = $('#tabelaCoresProduto').DataTable().data().toArray()
            const { consumos, coresProdutoImportado: arrayCoresProdutoImportado } = resultado
            const coresValidacao = listaCoresProd.map(cor => cor.COR)
            const coresProdutoImportado = arrayCoresProdutoImportado.map(cor => ({ cor }))
            const validacaoCoresProd = coresProdutoImportado.some(obj =>
                coresValidacao.includes(obj.cor)
            )

            if (!validacaoCoresProd) {
                msgAlertaSemConfirmacao(`Produto importado não possui nenhuma cor em comum com o produto: ${pegaChave('#txtCodigoConsumo')} - ${pegaDescricao('#txtCodigoConsumo')}`)

                limpaCampos();
                bloqueiaCamposModal();
                $('#btnConfirmarGrade').addClass('d-none');
                $('#btnCancelarGrade').addClass('d-none');
                $('#btnAbreImportarCons').addClass('d-none');
                $('#btnIncluirGrade').removeClass('d-none');
                $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
                return
            }

            const datatableData = $('#tabelaGradeTamanho').DataTable().data().toArray()
            let maximaOrdemAtual = datatableData?.reduce((max, obj) => {
                return obj.ORDEM > max ? obj.ORDEM : max
            }, 0)

            consumos?.forEach((itemConsumo) => {
                let existePeloMenosUmTamanhoEmComum = false
                const novoRegistro = {}
                const { camposPrincipais, consumoTamanhos, coresInsumo: arrayCoresInsumo, coresProduto } = itemConsumo

                arrayTamanhos?.forEach((item) => {
                    const { TAMANHO: tamanho } = item
                    const tamanhoConsumoEncontrado = consumoTamanhos?.find(e => e?.tamanho === tamanho)
                    const { consumo } = tamanhoConsumoEncontrado
                    novoRegistro[tamanho] = parseFloat(consumo).toFixed(5) || '0.00000'
                    novoRegistro[`preco${tamanho}`] = $(`#chPreco${tamanho}`).is(':checked') ? 'S' : 'N'
                    if (!existePeloMenosUmTamanhoEmComum && tamanhoConsumoEncontrado) {
                        existePeloMenosUmTamanhoEmComum = true
                    }
                })

                if (!existePeloMenosUmTamanhoEmComum) {
                    return
                }

                const arrayCoresProduto = coresValidacao?.map((cor) => {
                    const corEncontrada = coresProduto?.find(e => e?.corProduto === cor)
                    return {
                        corProduto: cor,
                        corInsumo: corEncontrada?.corInsumo || '',
                        descricaoCorInsumo: corEncontrada?.descricaoCorInsumo || '',
                    }
                })

                maximaOrdemAtual += 1
                novoRegistro.ORDEM = retornaBotaoOpcoesGradeTam(maximaOrdemAtual)
                novoRegistro.CODIGO = camposPrincipais?.insumo
                novoRegistro.DESCRICAO = camposPrincipais?.descricaoInsumo
                novoRegistro.UNIDADE = camposPrincipais?.unidade
                novoRegistro.SETOR = camposPrincipais?.setor
                novoRegistro.APLICACAO = camposPrincipais?.aplicacao
                novoRegistro.PARTE = camposPrincipais?.parte
                novoRegistro.TIPO = camposPrincipais?.tipo
                novoRegistro.CORES_PRODUTO = JSON.stringify(arrayCoresProduto)
                novoRegistro.CORES_INSUMO = JSON.stringify(arrayCoresInsumo)
                $('#tabelaGradeTamanho').DataTable().row.add(novoRegistro)
            })

            $('#tabelaGradeTamanho').DataTable().draw(false)
            $('#btnCancelarGrade').trigger('click')
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível importar os consumos do produto [${produtoImportado}] - ${descricaoProdutoImportado}! Tente novamente.`);
            return;
        } finally {
            $.LoadingOverlay('hide');
            $('#modalImportaConsumos').modal('hide');
        }
    };

    async function criaPesquisaF4Manutencao() {
        criaPesquisaF4('txtInsumo', 'btn-CodigoInsumo')
        criaPesquisaF4('txtSetorInsumo', 'btn-SetorInsumo')
        criaPesquisaF4('txtAplicacaoInsumo', 'btn-AplicacaoInsumo')
        criaPesquisaF4('txtParteInsumo', 'btn-ParteInsumo')
    }

    async function carregaModalManutencao() {
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableGradeTam();
        $('#btn-CodigoInsumo').pesquisa_serverside([`#txtInsumo`], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO", "UNIDADE", "CODCLI", "GRUPO", "SUB_GRUPO", "CODFIS", "CODTRI", "LINHA", "ATIVO", "EMP_ID"], "where": ["1=1"]}`, 'Pesquisa de Material');
        $('#txtInsumo').autocompleta(1, 'JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-CodigoInsumo').on('click', function () {
            $('#txtInsumo').val('');
        });
        //
        $('#btn-CodigoInsumoProd').pesquisa_serverside([`#txtInsumo`], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO", "UNIDADE", "CODCLI", "GRUPO", "CODFIS", "LINHA", "ATIVO", "EMP_ID"], "where": ["1=1"]}`, 'Pesquisa de Produto');
        $('#btn-limpa-CodigoInsumo').on('click', function () {
            $('#txtInsumo').val('');
        });
        $(`#txtInsumo`).keyup(function (e) {
            if (e.keyCode == 113) {
                $(`#btn-CodigoInsumoProd`).click();
                e.preventDefault();
                e.stopPropagation();
            }
        });
        //
        $('#btn-SetorInsumo').pesquisa_serverside(['#txtSetorInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":["CODIGO","DESCRICAO", "ORDEM", "CUSTO", "ATIVO", "TIPO"], "where": null}', 'Pesquisa de Setor');
        $('#txtSetorInsumo').autocompleta(1, 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-SetorInsumo').on('click', function () {
            $('#txtSetorInsumo').val('');
        });
        //
        $('#btn-AplicacaoInsumo').pesquisa_serverside(['#txtAplicacaoInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PCPAPL", "camposSelect":["DESCRICAO", "TIPOAPL", "ATIVO", "CODIGO", "TIPO"], "where": null}', 'Pesquisa de Aplicação');
        $('#txtAplicacaoInsumo').autocompleta(1, 'JSON={ "tabela":"PCPAPL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-AplicacaoInsumo').on('click', function () {
            $('#txtAplicacaoInsumo').val('');
        });
        //
        $('#btn-ParteInsumo').pesquisa_serverside(['#txtParteInsumo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TIPO_APL", "camposSelect":["DESCRICAO", "ATIVO", "CODIGO", "ESTOQUE"], "where": null}', 'Pesquisa de Parte');
        $('#txtParteInsumo').autocompleta(1, 'JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-ParteInsumo').on('click', function () {
            $('#txtParteInsumo').val('');
        })
        await criaPesquisaF4Manutencao()

        const linhaSelecionada = $('#tabelaConsumos').DataTable().row($('tr.selected')).count() > 0;
        if (linhaSelecionada) {
            $('#btnIncluirGrade').prop('disabled', true)
            return
        }

        $('#btnIncluirGrade').prop('disabled', false)
        $('.chPreco').prop('checked', true)
    };

    async function validaSeEhProduto(codigo) {
        const pesquisaProd = {
            tabela: 'PRODUTO',
            camposSelect: ['PRODUTO.CODIGO '],
            where: [`PRODUTO.CODIGO = '${codigo}'`],
        };

        const jsonStrProdutos = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaProd));

        return jsonStrProdutos.length >= 1 ? true : false
    }

    $('#modal-manutencaoconsumos').on('shown.bs.modal', async function () {
        $('#tabelaCoresProduto').DataTable().columns.adjust().draw(false);
        $('#tabelaCoresInsumo').DataTable().columns.adjust().draw(false);
        $('#tabelaGradeTamanho').DataTable().columns.adjust().draw(false);
        $('#tabelaTamanhosDiv').DataTable().columns.adjust().draw(false);


        $('.inputsCorInsumo').on('focusin', async function () {
            $("#tabelaCoresProduto").dataTable().$("tr.selected").removeClass("selected");
            $(this).closest('tr').addClass("selected");
        });

        /// gambiarra, mas funcionou, time que ta ganhando nao mexe - Bruno
        $(`.inputsCorInsumo`).on('change', async function () {
            if ($(this).val() === '') {
                const cor = String($(this).data('cor'))
                $(`#txtDescricaoInsumo${ajustaIdCorConsumo(cor)}`).val('');
            };
        });

        $('#txtInsumo').on('blur', async function () {
            const bProduto = await validaSeEhProduto(pegaChave('#txtInsumo'))

            await criaPesquisas(bProduto);
            if (incluirCorNaoExistente) {
                await criarEventos(bProduto)
            }
            await criaDataTableCoresInsumo(true);
            $('#txtUndInsumo').val(await pesquisaUnidadeInsumo(bProduto));
            $('.inputsCorInsumo').val('')
            $('.descInsumo').val('')
        });

        $('.inputsTamanho').on('blur', async function () {
            const qtdeInputTamanho = Number($(this).val().replace(',', '.'));
            $(this).val(qtdeInputTamanho.toFixed(5));
        });
    });

    $('#modal-manutencaoconsumos').on('hide.bs.modal', async function () {
        ordemManutencao = 0
        $('#tabelaConsumos').DataTable().$('tr.selected').removeClass('selected')
        if ($.fn.DataTable.isDataTable('#tabelaGradeTamanho')) {
            $('#tabelaGradeTamanho').DataTable().destroy()
            $('#tabelaGradeTamanho').empty()
        }
    })

    $('#btnIncluirGrade').on('click', async function () {
        desbloqueiaCamposModal();
        $('#btnConfirmarGrade').removeClass('d-none');
        $('#btnCancelarGrade').removeClass('d-none');
        $('#btnIncluirGrade').addClass('d-none');
        $('#btnAbreImportarCons').removeClass('d-none');
    });

    $('#btnCancelarGrade').on('click', async function () {
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableCoresInsumo(false);
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $('#btnAbreImportarCons').addClass('d-none');
        $('.btnAcoesGradeConsumo').prop('disabled', false)
        $('#tabelaGradeTamanho').DataTable().$('tr.selected').removeClass('selected');
    });

    $('#btnDesistirManutencao').on('click', async function () {
        $('#modal-manutencaoconsumos').modal('hide');
        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableCoresInsumo(false);
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $('#btnAbreImportarCons').addClass('d-none');
    });

    $('#btnGravarManutencao').on('click', async function () {
        const qtdeRegistrosNovos = $('#tabelaGradeTamanho').DataTable().data().toArray();

        if (qtdeRegistrosNovos <= 0) {
            msgErro('Não existe nenhum registro novo para gravar!');
            return;
        };

        const linhaSelecionada = $('#tabelaConsumos').DataTable().row($('tr.selected'));
        if (linhaSelecionada.count() > 0) {
            await gravaAlteracaoConsumos(linhaSelecionada.data())
            return
        }

        try {
            $.LoadingOverlay('show');

            const listaFormatada = await criaListaParaGravar();
            const url = '/sisplan/cadconsumo/v1/incluiconsumos?';
            const response = await requisicao('POST', url, '', `LISTADECONSUMOS=${encodeURIComponent(JSON.stringify({ LISTACONSUMOSCRIADOS: listaFormatada }))}`, 360000);

            if (response.status == 200) {
                criaMensagemSucesso('Consumos cadastrados com sucesso!', () => { window.location.reload(true); });
                return;
            };

            if (response.status != 200) {
                msgErro('Não foi possível cadastrar os consumos! Verifique.');
                return;
            };

        } catch (error) {
            console.error(error);
            msgErro('Não foi possível cadastrar os consumos! Verifique.');
        } finally {
            $.LoadingOverlay('hide');
            // window.location.href = window.location.href;
        };
    });

    $('#btnConfirmarGrade').on('click', async function () {
        $('#btnAbreImportarCons').addClass('d-none');
        const qtdeCoresProd = $('#tabelaCoresProduto').DataTable().data().toArray();

        if ($('#txtInsumo').val() == '') {
            msgErro('Insumo não informado! Por favor, verifique.');
            return;
        };

        if ($('#txtSetorInsumo').val() == '') {
            msgErro('Setor não informado! Por favor, verifique.');
            return;
        };

        if ($('#txtAplicacaoInsumo').val() == '') {
            msgErro('Aplicação não informada! Por favor, verifique.');
            return;
        };

        let NaoExisteCorInsumoInformada = false;

        for (i = 0; i < qtdeCoresProd.length; i++) {
            if ($(`#txtCorInsumo${ajustaIdCorConsumo(qtdeCoresProd[i].COR)}`).val() !== '' && $(`#txtCorInsumo${ajustaIdCorConsumo(qtdeCoresProd[i].COR)}`).val() !== undefined) {
                NaoExisteCorInsumoInformada = true;
                break;
            };
        };

        if (!NaoExisteCorInsumoInformada) {
            msgErro('Não foi informado nenhuma cor de insumo.');
            return;
        };

        const linhasSelecionadas = $("#tabelaGradeTamanho").DataTable().rows(".selected").data().toArray()
        const alteracao = linhasSelecionadas && linhasSelecionadas.length > 0
        if (alteracao) {
            await alteraRegistroGradeTam();
        } else {
            await adicionaRegistroGradeTam();
        }

        bloqueiaCamposModal();
        limpaCampos();
        await criaDataTableCoresInsumo(false);
        $('#btnConfirmarGrade').addClass('d-none');
        $('#btnCancelarGrade').addClass('d-none');
        $('#btnIncluirGrade').removeClass('d-none');
        $('#btnAbreImportarCons').addClass('d-none');
        $('.btnAcoesGradeConsumo').prop('disabled', false)
    });

    $('#tabelaGradeTamanho').on('click', '#btn-excluirGradeConsumo', async function () {
        const data = $("#tabelaGradeTamanho").DataTable().row($(this).parents("tr"));
        const btnOrdem = $($(this).parents("tr"));
        const ordemRemovida = btnOrdem[0].cells[0].children[0].children[0].value;
        data.remove().draw(false);
    });

    $('#tabelaGradeTamanho').on('click', '#btn-alterarGradeConsumo', async function () {
        try {
            $("#tabelaGradeTamanho").dataTable().$("tr.selected").removeClass("selected");
            $($(this).parents("tr")).addClass('selected')
            const datatableData = $("#tabelaGradeTamanho").DataTable().row($(this).parents("tr")).data()

            insereValor('#txtInsumo', datatableData?.CODIGO, datatableData?.DESCRICAO)
            insereValor('#txtUndInsumo', datatableData?.UNIDADE)
            insereValor('#txtSetorInsumo', datatableData?.SETOR, { tabela: 'CADFLUXO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: datatableData?.SETOR })
            insereValor('#txtAplicacaoInsumo', datatableData?.APLICACAO, { tabela: 'PCPAPL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: datatableData?.APLICACAO })
            insereValor('#txtParteInsumo', datatableData?.PARTE, { tabela: 'TIPO_APL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: datatableData?.PARTE })

            for (key in datatableData) {
                if (!['ORDEM', 'CODIGO', 'DESCRICAO', 'UNIDADE', 'SETOR', 'APLICACAO', 'PARTE'].includes(key)) {
                    insereValor(`#txtTamanho${key}`, datatableData[key])
                    $(`#chPreco${key}`).prop('checked', datatableData[`preco${[key]}`] != 'N')
                }
            }

            const { CORES_PRODUTO, CORES_INSUMO } = datatableData

            const coresProduto = JSON.parse(CORES_PRODUTO)
            const coresInsumo = JSON.parse(CORES_INSUMO)

            coresProduto.forEach((e) => {
                const { corProduto, corInsumo, descricaoCorInsumo } = e
                insereValor(`#txtCorInsumo${ajustaIdCorConsumo(corProduto)}`, corInsumo)
                insereValor(`#txtDescricaoInsumo${ajustaIdCorConsumo(corProduto)}`, descricaoCorInsumo)
            })

            $("#tabelaCoresInsumo").DataTable().rows().remove()

            coresInsumo.forEach((e) => {
                $('#tabelaCoresInsumo').DataTable().row.add({
                    COR: e?.cor,
                    DESCRICAO: e?.descricao,
                })
            })
            $('#tabelaCoresInsumo').DataTable().draw(false)

            const bProduto = datatableData?.TIPO === 'P'

            criaPesquisas(bProduto)
            if (incluirCorNaoExistente) {
                await criarEventos(bProduto)
            }
            desbloqueiaCamposModal()
            $('#btnConfirmarGrade').removeClass('d-none')
            $('#btnCancelarGrade').removeClass('d-none')
            $('#btnIncluirGrade').addClass('d-none')
            $('.btnAcoesGradeConsumo').prop('disabled', true)
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um erro ao alterar o registro.')
        }
    })

    $('#btnAbreImportarCons').on('click', function () {
        $('#modalImportaConsumos').modal('show');
        $('#btn-CodigoImportacaoConsumos').pesquisa_serverside([`#txtCodigoImportacao`], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Produto');
        $('#txtCodigoImportacao').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-CodigoImportacaoConsumos').on('click', function () {
            $('#txtCodigoImportacao').val('');
        });

        $('#btn-ParteImportacaoConsumos').pesquisa_serverside(['#txtParteImportacaoConsumos'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TIPO_APL", "camposSelect":["DESCRICAO", "ATIVO", "CODIGO", "ESTOQUE"], "where": null}', 'Pesquisa de Parte');
        $('#txtParteImportacaoConsumos').autocompleta(1, 'JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-ParteImportacaoConsumos').on('click', function () {
            $('#txtParteImportacaoConsumos').val('');
        });
    });

    $('#btnImportaCons').on('click', async function () {
        const prodImportado = pegaChave('#txtCodigoImportacao');
        const descProdImportado = pegaDescricao('#txtCodigoImportacao');
        const parteImportada = pegaChave('#txtParteImportacaoConsumos');
        await importaConsumos(prodImportado, descProdImportado, parteImportada);
    });

    $('#btnModificacoes').on('click', function () {
        $('#modal-modificacoes').modal('show');
    })

    $('#modal-modificacoes').on('show.bs.modal', async function () {
        $('#btn-CodigoProdutoModificacao').pesquisa_serverside([`#txtProdutoModificacao`], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":["CODIGO", "DESCRICAO", "UNIDADE", "CODCLI", "GRUPO", "CODFIS", "LINHA", "ATIVO", "EMP_ID"], "where": ["1=1"]}`, 'Pesquisa de Produto');
        $('#txtProdutoModificacao').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btn-limpa-CodigoProdutoModificacao').on('click', function () {
            $('#txtProdutoModificacao').val('');
        });
        criaPesquisaF4('txtProdutoModificacao', 'btn-CodigoProdutoModificacao');

        insereValor('#txtProdutoModificacao', produtoCodigo, { tabela: 'PRODUTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: produtoCodigo })
    })

    $('#modal-modificacoes').on('shown.bs.modal', async function () {
        $('#btnConsultarModificacoes').trigger('click')
    })

    $('#btnConsultarModificacoes').on('click', async function () {
        await fazConsultaModificacoes();
    })


    async function fazConsultaModificacoes() {
        if ($.fn.DataTable.isDataTable('#tabelaModificacoes')) {
            $("#tabelaModificacoes").DataTable().destroy();
            $("#tabelaModificacoes").empty();
        }
        try {
            dataSetCols = [];
            $.LoadingOverlay('show');
            try {
                const url = "/sisplan/cadconsumo/v1/consultamodificacoes?";
                const response = await requisicao("GET", url, `PRODUTO=${pegaChave('#txtProdutoModificacao')}`, "", 360000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (jsonStr.length == 0) {
                    msgAlerta("Nenhum registro encontrado!");
                    $("#txtMeta").val();
                    if ($.fn.DataTable.isDataTable('#tabelaModificacoes')) {
                        $('#tabelaModificacoes').DataTable().destroy();
                        $('#tabelaModificacoes').empty();
                    }
                    return;
                }

                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                };

                let keys = Object.keys(jsonStr[0]);

                keys.forEach((k) => {
                    dataSetCols.push({
                        title: k,
                        data: k,
                    });
                });

                $('#tabelaModificacoes').DataTable({
                    bPaginate: true,
                    destroy: true,
                    colReorder: true,
                    autoWidth: true,
                    columns: dataSetCols,
                    data: jsonStr,
                });

            } catch (error) {
                console.error(error);
                msgErro("Não foi possível fazer consulta das Modificações! Tente novamente.");
                return;
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    $('#modalImportaConsumos').on('hide.bs.modal', function () {
        $('#txtCodigoImportacao').val('');
        $('#txtParteImportacaoConsumos').val('');
    });

    async function retornaDadosModalModificacoes(data) {
        try {
            $.LoadingOverlay('show')
            const camposFiltro = {
                tipo: data[0],
                produto: pegaChave('#txtCodigoConsumo'),
                insumo: data[3],
                setor: data[6],
                aplicacao: data[7],
                parte: data[8],
            }

            const response = await requisicao("GET", '/sisplan/cadconsumo/v1/retornadadosmodal?', `FILTROS=${JSON.stringify(camposFiltro)}`, null);

            if (response.status !== 200) {
                throw new Error()
            }

            const responseJson = await response.json()

            const { resultado } = responseJson

            await alimentaModalModificacoes(resultado)
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um erro ao carregar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function alimentaModalModificacoes({ camposPrincipais, consumoTamanhos, coresProduto, coresInsumo }) {
        insereValor('#txtInsumo', camposPrincipais?.insumo, camposPrincipais?.descricaoInsumo)
        insereValor('#txtUndInsumo', camposPrincipais?.unidade)
        insereValor('#txtSetorInsumo', camposPrincipais?.setor, camposPrincipais?.descricaoSetor)
        insereValor('#txtAplicacaoInsumo', camposPrincipais?.aplicacao, camposPrincipais?.descricaoAplicacao)
        insereValor('#txtParteInsumo', camposPrincipais?.parte, camposPrincipais?.descricaoParte)

        const novaLinha = {
            ORDEM: retornaBotaoOpcoesGradeTam(1),
            CODIGO: camposPrincipais?.insumo,
            DESCRICAO: camposPrincipais?.descricaoInsumo,
            UNIDADE: camposPrincipais?.unidade,
            SETOR: camposPrincipais?.setor,
            APLICACAO: camposPrincipais?.aplicacao,
            PARTE: camposPrincipais?.parte,
            TIPO: camposPrincipais?.tipo,
        }

        consumoTamanhos?.forEach((e) => {
            const { tamanho, consumo, preco } = e
            const consumoFormatado = parseFloat(consumo).toFixed(5)
            insereValor(`#txtTamanho${tamanho}`, consumoFormatado)
            $(`#chPreco${tamanho}`).prop('checked', preco != 'N')
            novaLinha[tamanho] = consumoFormatado;
            novaLinha[`preco${tamanho}`] = preco;
        })

        const arrayCores = []
        coresProduto?.forEach((e) => {
            const { corProduto, corInsumo, descricaoCorInsumo } = e
            insereValor(`#txtCorInsumo${ajustaIdCorConsumo(corProduto)}`, corInsumo)
            insereValor(`#txtDescricaoInsumo${ajustaIdCorConsumo(corProduto)}`, descricaoCorInsumo)
            arrayCores.push({
                corProduto,
                corInsumo,
                descricaoCorInsumo,
            })
        })
        novaLinha.CORES_PRODUTO = JSON.stringify(arrayCores)

        const arrayCoresInsumo = []
        coresInsumo?.forEach((e) => {
            $('#tabelaCoresInsumo').DataTable().row.add({
                COR: e?.cor,
                DESCRICAO: e?.descricao,
            })
            arrayCoresInsumo.push({
                cor: e?.cor,
                descricao: e?.descricao,
            })
        })

        $('#tabelaCoresInsumo').DataTable().draw(false)
        novaLinha.CORES_INSUMO = JSON.stringify(arrayCoresInsumo)
        await criaDataTableGradeTam([novaLinha])
        desbloqueiaCamposModal()
        $('#btnConfirmarGrade').removeClass('d-none')
        $('#btnCancelarGrade').removeClass('d-none')
        $('#btnIncluirGrade').addClass('d-none')
        $('.btnAcoesGradeConsumo').prop('disabled', true)
        $($('#tabelaGradeTamanho tr')[1]).addClass('selected')
        const bProduto = camposPrincipais?.tipo === 'P'
        criaPesquisas(bProduto)
        if (incluirCorNaoExistente) {
            await criarEventos(bProduto)
        }
    }

    async function gravaAlteracaoConsumos(dados) {
        try {
            $.LoadingOverlay('show')
            const produto = produtoCodigo
            const insumo = dados[3]
            const setor = dados[6]
            const aplicacao = dados[7]
            const parte = dados[8]
            const arrayConsumos = $('#tabelaConsumos').DataTable().data().toArray()
            const [_, _2, ordemMinima] = arrayConsumos.find(e => e[3] === insumo && e[6] === setor && e[7] === aplicacao && e[8] === parte)
            const [_3, _4, ordemMaxima] = arrayConsumos.slice().reverse().find(e => e[3] === insumo && e[6] === setor && e[7] === aplicacao && e[8] === parte)
            const arrayConsumosAgrupados = [];

            arrayConsumos.forEach((e) => {
                const arrayCores = retornaCoresProdInsumoTabConsumos(e);

                const itemExistente = arrayConsumosAgrupados.find(item =>
                    item.Insumo_Codigo === e[3] &&
                    item.Insumo_Setor === e[6] &&
                    item.Insumo_Aplicacao === e[7] &&
                    item.Insumo_Parte === e[8] &&
                    item.Insumo_Faixa === e[9]
                );

                if (itemExistente) {
                    itemExistente.Insumo_ListaCores.push(...arrayCores);
                } else {
                    arrayConsumosAgrupados.push({
                        Produto_Codigo: produto,
                        Insumo_Tipo: e[0],
                        Insumo_IdCons: e[1],
                        Insumo_Ordem: e[2],
                        Insumo_Codigo: e[3],
                        Insumo_Descricao: e[4],
                        Insumo_Unidade: e[5],
                        Insumo_Setor: e[6],
                        Insumo_Aplicacao: e[7],
                        Insumo_Parte: e[8],
                        Insumo_Faixa: e[9],
                        Insumo_Preco: e[10],
                        Insumo_Consumo: e[11],
                        Insumo_ListaCores: [...arrayCores],
                    });
                }
            });

            const arrayConsumosAnteriores = arrayConsumosAgrupados.filter(e => e.Insumo_Ordem < ordemMinima);
            const arrayConsumosPosteriores = arrayConsumosAgrupados.filter(e => e.Insumo_Ordem > ordemMaxima);

            const arrayConsumosNovos = []

            const tamanhosProduto = await retornaGradeTamanhosProduto(produtoCodigo);

            if ($.fn.DataTable.isDataTable('#tabelaGradeTamanho')) {

                const novosItensTabela = $('#tabelaGradeTamanho').DataTable().data().toArray()

                novosItensTabela.forEach((linhaTabela) => {
                    return tamanhosProduto.forEach((tamanhoProduto) => {
                        const arrayCoresTabela = JSON.parse(linhaTabela.CORES_PRODUTO)
                        const coresProduto = arrayCoresTabela.map((e) => ({
                            cor_p: e?.corProduto,
                            // cor_i: e?.corInsumo === '' ? '*****' : e.corInsumo,
                            cor_i: e?.corInsumo,
                            descCor_i: e?.descricaoCorInsumo,
                        }))

                        const { TAMANHO: tamanho } = tamanhoProduto
                        const qtdeFormatada = parseFloat(linhaTabela[tamanho] === '' ? 0 : linhaTabela[tamanho])
                        if (qtdeFormatada > 0) {
                            arrayConsumosNovos.push({
                                Produto_Codigo: produtoCodigo,
                                Insumo_Tipo: linhaTabela.TIPO,
                                Insumo_IdCons: '',
                                Insumo_Ordem: 0,
                                Insumo_Codigo: linhaTabela.CODIGO,
                                Insumo_Descricao: linhaTabela.DESCRICAO,
                                Insumo_Unidade: linhaTabela.UNIDADE,
                                Insumo_Setor: linhaTabela.SETOR,
                                Insumo_Aplicacao: linhaTabela.APLICACAO,
                                Insumo_Parte: linhaTabela.PARTE,
                                Insumo_Faixa: tamanho,
                                Insumo_Preco: linhaTabela[`preco${tamanho}`],
                                Insumo_Consumo: qtdeFormatada,
                                Insumo_ListaCores: coresProduto,
                            })
                        }
                    })
                })
            }

            const arrayFinal = [...arrayConsumosAnteriores, ...arrayConsumosNovos, ...arrayConsumosPosteriores].map((e, i) => {
                return {
                    ...e,
                    Insumo_Ordem: i + 1,
                }
            })

            const url = '/sisplan/cadconsumo/v1/incluiconsumos?';
            const response = await requisicao('POST', url, '', `LISTADECONSUMOS=${encodeURIComponent(JSON.stringify({ LISTACONSUMOSCRIADOS: arrayFinal }))}`, 360000);

            if (response.status == 200) {
                criaMensagemSucesso('Consumos cadastrados com sucesso!', () => { window.location.reload(true); });
                return;
            };

            if (response.status != 200) {
                msgErro('Não foi possível cadastrar os consumos! Verifique.');
                return;
            };
        } catch (e) {
            console.log(e)
            msgErro('Ocorreu um erro ao gravar os dados.')
        } finally {
            $.LoadingOverlay('hide')
        }
    }

    async function criarEventos(produto = false) {
        const { codigosCores } = await retornaCoresProduto();
        const codigoInsumo = pegaChave('#txtInsumo')

        codigosCores.forEach((it) => {
            const id = ajustaIdCorConsumo(it?.cor)
            const tabela = produto ? 'PA_ITEN' : 'MAT_ITEN'
            $(`#txtCorInsumo${id}`).on('blur', async function () {
                const corInput = this.value
                if (!corInput) {
                    return
                }
                const corExiste = await Existe(tabela, ['CODIGO', 'COR'], [codigoInsumo, corInput])
                if (!corExiste) {
                    msgAlerta(
                        'Cor não cadastrada para o insumo informado, deseja cadastrar?',
                        async () => {
                            const result = await cadastrarCor(produto, codigoInsumo, corInput)
                            if (!result) {
                                $(`#txtCorInsumo${id}`).val('')
                                $(`#txtDescricaoInsumo${id}`).val('')
                            }
                        },
                        () => {
                            $(`#txtCorInsumo${id}`).val('')
                            $(`#txtDescricaoInsumo${id}`).val('')
                        },
                        undefined,
                        () => null,
                        true,
                    )
                }
            })
        })
    }

    async function cadastrarCor(produto = false, codigoInsumo, cor) {
        try {
            $.LoadingOverlay('show')
            let response = null
            if (produto) {
                const tamanhos = await retornaGradeTamanhosProduto(codigoInsumo)

                const cores = tamanhos.map((it) => ({
                    codigo: codigoInsumo,
                    cor,
                    tam: it.TAMANHO,
                    ativo: 'S',
                }))

                const dados = {
                    cores,
                }
                response = await requisicao("POST", `/sisplan/produto/v1/grava_cor_produto?`, '', JSON.stringify(dados), 3600000)
            } else {
                const dados = {
                    cores: [
                        {
                            codigo: codigoInsumo,
                            cor,
                            ativo: 'S',
                        }
                    ]
                }
                response = await requisicao("POST", `/sisplan/material/v1/grava_cor_material?`, ``, JSON.stringify(dados), 3600000)
            }

            if (!response) {
                return
            }

            const json = await response.json()

            if (!json) {
                return
            }

            const { mensagem } = json
            if (mensagem?.codigo !== 200) {
                throw mensagem?.mensagem
            }

            const tipoItem = produto ? 'produto' : 'material'

            rotinaGeraLog('CONSUMOS_PRODUTO_WEB', codigoInsumo, `Inclusão de cor para ${tipoItem}: ${codigoInsumo}, cor: ${cor}`, 'Inclusão');

            toastr.success("Cor cadastrada com sucesso!", "Confirmação", {
                toastClass: "alert",
                iconClasses: {
                    error: "alert-error",
                    info: "alert-info",
                    success: "alert-success",
                    warning: "alert-warning",
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 1000,
                fadeOut: 1000,
            }).css({
                "margin-top": "20%",
                width: "500px",
                "max-width": "500px",
            })

            return true
        } catch (error) {
            console.error(error)
            msgErro('Ocorreu um erro ao cadastrar a cor.')
            return false
        } finally {
            $.LoadingOverlay('hide')
        }
    }
})