<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Conta</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.261.20.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.261.20.1">
  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.261.20.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.261.20.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.261.20.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.261.20.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.20.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.261.20.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.261.20.1">

  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.261.20.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.261.20.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.261.20.1">
  <!-- Google Font: Source Sans Pro -->
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 33.33333%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    .checkboxOpcoes {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1.6%;
      padding-bottom: 0%;
    }

    .labelTipo {
      margin-bottom: 3px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid var(--font-color) !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    #tabelaEmpresa td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaEmpresa td {
      padding: 0 !important;
      padding-left: 10px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <!-- <ol class="breadcrumb float-sm-right">
                  
                  <li class="breadcrumb-item"><a href="../cadconta">Acesso Conta</a></li>
                  <li class="breadcrumb-item active">Cadastro de Conta</li>
                </ol> -->
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Conta
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%;"><strong>Contas</strong></li>
                        <li id="personal" style="font-size: 100%;"><strong>Configuração</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro da conta</p>

                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                              <input type="number" readonly class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                            </div>
                            <div class="col-lg-9  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Descrição *</label>
                              <input type="text" class="input-default focus form-control text-uppercase" id="txtDescricao" required aria-describedby="descError" name="txtDescricao" class="form-control" placeholder="Descrição">
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAgencia">Agência *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAgencia" required aria-describedby="histError" name="txtAgencia" class="form-control" placeholder="Agência">
                              </div>
                            </div>
                            <div class="col-lg-8  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtBanco">Banco *</label>
                              <div class="input-group">
                                <input type="text" required class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnBanco" name="btnBanco" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnExcluiBanco" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtConta">Conta *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtConta" required aria-describedby="classeError" name="txtConta" class="form-control" placeholder="Conta">
                              </div>
                            </div>
                            <div class="col-lg-8  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTitular">Titular</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtTitular" name="txtTitular" class="form-control" placeholder="Titular">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-4  col-12 form-group" id="cnpjTour">
                              <label>CNPJ/CPF </label>
                              <input type="text" class="input-default focus form-control validate" id="txtCNPJ" name="txtCNPJ" placeholder="CNPJ ou CPF">
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtInscricao">Inscrição</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtInscricao" name="txtInscricao" class="form-control" placeholder="Condição de pagamento">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPix">Pix</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtPix" name="txtPix" class="form-control" placeholder="Pix">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSequencial">Sequencial</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSequencial" name="txtSequencial" class="form-control" placeholder="Sequencial">
                              </div>
                            </div>
                            <div class="col-lg-2 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDigitos">Dígitos</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtDigitos" name="txtDigitos" class="form-control" placeholder="Dígitos">
                              </div>
                            </div>
                            <div class="col-lg-2 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDias">Compensar em: </label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtDias" name="txtDias" class="form-control" placeholder="Dias">
                              </div>
                            </div>
                            <div class="col-lg-4 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtLimite">Limite</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" maxlength="20" id="txtLimite" name="txtLimite" class="form-control" placeholder="Limite">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMensagem">Mensagem</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtMensagem" name="txtMensagem" class="form-control" placeholder="Mensagem">
                              </div>
                            </div>
                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAvalista">Avalista</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAvalista" name="txtAvalista" class="form-control" placeholder="Avalista">
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card" id="contas">
                          <h2 class="fs-title">Contas</h2>
                          <div class="row">
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaDebito1">Conta Débito</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaDebito1" name="txtContaDebito1" class="form-control" placeholder="Conta Débito">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaDebito" name="btnTContaDebito" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaDebito" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaCredito1">Conta Crédito</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaCredito1" name="txtContaCredito1" class="form-control" placeholder="Conta Crédito">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaCredito" name="btnContaCredito" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnAContaCredito" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-6 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtSequencialPg">Sequencial PagFor</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSequencialPg" name="txtSequencialPg" class="form-control" placeholder="Sequencial PagFor">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtDigitos2">Dígitos</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtDigitos2" name="txtDigitos2" class="form-control" placeholder="Dígitos">
                              </div>
                            </div>
                            <div class="col-lg-3 col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtFloat">Float</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtFloat" name="txtFloat" class="form-control" placeholder="Float">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaCreditada">Conta Creditada</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaCreditada" name="txtContaCreditada" class="form-control" placeholder="Conta Creditada">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btnContaCreditada" name="btnContaCreditada" data-button="absolute" type="button">
                                    <i class="m-0 p-0 fas fa-search"></i>
                                  </button>
                                  <button class="btn bg-danger" id="btnLimpaContaCreditada" type="button">
                                    <i class="m-0 p-0 fas fa-trash"></i>
                                  </button>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-6  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtContaComplementar">Conta Complementar PagFor</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtContaComplementar" name="txtContaComplementar" class="form-control" placeholder="Conta Complementar PagFor">
                              </div>
                            </div>
                          </div>
                          <div class="row">
                            <div class="form-group col-lg-4 col-12">
                              <label>Conciliado Até</label>
                              <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtConciliado">
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAgCooperado">Agência Cooperado</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAgCooperado" name="txtAgCooperado" class="form-control" placeholder="Agência Cooperado">
                              </div>
                            </div>
                            <div class="group-default form-group col-12 col-lg-4">
                              <label for="">Tipo </label>
                              <div class="relative">
                                <select name="" id="txtTipo" value="" class="form-group input-default">
                                  <option value="0">Conta Corrente</option>
                                  <option value="1">Caixa</option>
                                  <option value="2">Particular</option>
                                  <option value="3">Aplicação</option>
                                  <option value="4">Loja</option>
                                </select>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar2" class="next action-button" value="Avançar" id="avancar2" />
                        <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                      </fieldset>

                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Configuração da Conta</h2>
                          <div class="row" id="configuracao">
                            <div class="radioTipo col-sm-6">
                              <div class="frete row">
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoEnvio">Caminho Arq. Envio</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoEnvio" name="txtCaminhoEnvio" class="form-control" placeholder="Caminho Ar. Envio">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoRetorno">Caminho Arq. Retorno</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoRetorno" name="txtCaminhoRetorno" class="form-control" placeholder="Caminho Ar. Retorno">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoRetornoLido">Caminho Arq. Retorno Lido</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoRetornoLido" name="txtCaminhoRetornoLido" class="form-control" placeholder="Caminho Ar. Retorno Lido">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoEnvioPg">Caminho Arq. Envio Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoEnvioPg" name="txtCaminhoEnvioPg" class="form-control" placeholder="Caminho Ar. Envio Pagto">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoRetornoPg">Caminho Arq. Retorno Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoRetornoPg" name="txtCaminhoRetornoPg" class="form-control" placeholder="Caminho Ar. Retorno Pagto">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCaminhoArqRetornoLidoPagto">Caminho Arq. Retorno Lido Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtCaminhoArqRetornoLidoPagto" name="txtCaminhoArqRetornoLidoPagto" class="form-control" placeholder="Caminho Ar. Retorno Pagto">
                                  </div>
                                </div>
                                <div class="col-sm-10">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Obs</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtObs" name="txtObs" class="form-control" placeholder="Obs">
                                  </div>
                                </div>
                              </div>
                            </div>

                            <div class="col-sm-6 table-wrap">

                              <div class="col-12  mt-4" id="tutFaturamento">
                                <fieldset class="form border-Field mb-0 pb-0">
                                  <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                  <div class="form-row ml-2">
                                    <div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkAtivo">
                                        <label class="mt-2" for="checkAtivo">Ativo</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkUsaSacador">
                                        <label for="checkUsaSacador">Usa Sacador Avalista do Cadastro de Empresa</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkPadrao">
                                        <label for="checkPadrao">Padrão</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkImprimeFluxo">
                                        <label for="checkImprimeFluxo">Imprime Fluxo</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkLancPendente">
                                        <label for="checkLancPendente">Lanc. Pendente</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkBaixaFinancerio">
                                        <label for="checkBaixaFinancerio">Permitir Baixas no Financeiro</label>
                                      </div>
                                      <div class="icheck-primary">
                                        <input type="checkbox" id="checkTransferencia">
                                        <label class="mb-2" for="checkTransferencia">Validar Transferências</label>
                                      </div>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>

                              <p style="font-weight: 700; margin: 15px 0 0 0; font-size: 1.1rem;">Selecionar Empresas</p>
                              <div class="col-sm-12  table-responsive">
                                <table id="tabelaEmpresa" class="table table-hover table-select table-condensed">
                                  <thead>
                                    <tr>
                                      <th>Sel</th>
                                      <th>Empresa</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>


                            </div>
                          </div>
                        </div>

                        <input type="button" name="gravar" class="next action-button" value="Gravar" id="gravar">
                        <input type="button" name="voltar3" class="previous action-button-previous" value="Voltar" id="voltar3" />
                      </fieldset>

                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
</body>

<?php
include_once('../../../modais.php');
?>

<!-- Control Sidebar -->
<aside class="control-sidebar control-sidebar-dark">
  <!-- Control sidebar content goes here -->
</aside>
<!-- /.control-sidebar -->
</div>

<!-- jQuery -->
<script src="../plugins/jquery/jquery.min.js?versao=3.261.20.1"></script>
<script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.261.20.1"></script>
<script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.261.20.1"></script>
<script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.261.20.1"></script>
<script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.261.20.1"></script>
<script src="../plugins/toastr/toastr.min.js?versao=3.261.20.1"></script>
<script>
  $.widget.bridge('uibutton', $.ui.button);
</script>
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/adminlte.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/requisicoes.js?versao=3.261.20.1"></script>
<script src="../dist/js/cliente/entidade.js?versao=3.261.20.1"></script>
<script src="../dist/js/loadingoverlay.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/valida_cpf_cnpj.js?versao=3.261.20.1"></script>
<script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/sisplan.js?versao=3.261.20.1"></script>
<script src="../utils/funcoes.js?versao=3.261.20.1"></script>
<script src="../utils/cookies.js?versao=3.261.20.1"></script>
<script src="../dist/js/jquery.mask.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/jquery.maskMoney.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/driver.min.js?versao=3.261.20.1"></script>
<script src="../dist/js/dataTables.keyTable2.js?versao=3.261.20.1"></script>
<script type="text/javascript" src="../config.js?versao=3.261.20.1"></script>
<script>
  $(document).ready(async function() {
    if (getCookie('usuario') == "") {
      window.location.href = `${BASE_URI}/login`;
      return;
    }

    let usuario = getCookie('usuario');
    let empresa = getCookie('empresa');

    ipInterno = IP_INTERNO;
    ipExterno = IP_EXTERNO;
    basicAuth = BASIC_AUTH;

    const temAcesso = await temAcessoTela('CADCONTA');
    if (!temAcesso.resultado) {
      toastrAcesso(temAcesso, BASE_URI);
      return;
    }

    const permissaoUsuarioLogado = await permissaoAcessos("CADCONTA");

    if (permissaoUsuarioLogado.INCLUI == 'N') {
      await criaMensagemErro("Sem permissão para incluir!", () => {
        window.location.href = `${BASE_URI}/cadconta`
      });
      return;
    }

    const queryString = window.location.href;
    const parametros = queryString.split("/");
    const conta = parametros[parametros.length - 1];

    $(window).on("beforeunload", function(e) {
      // e.preventDefault();
      e.stopPropagation();
      deletaRegistro("CADCONTA", getCookie("usuario"), conta);
      return undefined;
    });

    sArquivo = `${BASE_URI}/pages/cadconta/cadastro_cadconta/cadconta.js?versao=3.261.20.1`;
    insereJavaScriptPagina(sArquivo);

    const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
    habilitaCamposObrigatoriosTela(nomeTela);
  });
</script>
</body>

</html>