/* eslint-disable guard-for-in */
$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btnFiltros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os filtros padrões da tela.',
                position: 'right'
            }
        },
        {
            element: '#btnNovoPrecoProduto',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para iniciar o cadastro dos preços de um produto.',
                position: 'right'
            }
        },
        {
            element: '#tabelaCadProdPreco_wrapper',
            popover: {
                title: 'Tabela Materiais',
                description: 'Aqui estão os dados dos preços de produtos cadastrados.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("CADPRODPRECO");

    function retornaBotaoOpcoes(sCodigo) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + sCodigo + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '       <button class="dropdown-item" id="btn-editar">Alterar</button>     ' +
            '       <button class="dropdown-item" id="btn-excluir">Excluir</button>  ' +
            `       <button class="dropdown-item" id="btn-imprimir" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelCadProdPreco.FR3"' : '' }>Imprimir</button>  ` +
            '</div>';
        return retorno;
    }

    await consultaDados();

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnNovoPrecoProduto').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadprodpreco/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    // autocompleta filtros
    $('#txtConsultaProduto').autocompleta(1, `JSON={ "tabela":"MAT_PRECO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ["MAT_PRECO.TIPO = 'P'"]}`);
    $('#txtConsultaGrupo').autocompleta(1, `JSON={ "tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtConsultaSetor').autocompleta(1, `JSON={ "tabela":"cadfluxo", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ConsultaProduto').pesquisa_serverside(['#txtConsultaProduto'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"MAT_PRECO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["MAT_PRECO.TIPO = 'P'"]}`, 'Pesquisa de Produto');
    $('#btn-ConsultaGrupo').pesquisa_serverside(['#txtConsultaGrupo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Grupo');
    $('#btn-ConsultaSetor').pesquisa_serverside(['#txtConsultaSetor'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Setor');

    $('#btn-limpa-ConsultaProduto').on('click', function () {
        $('#txtConsultaProduto').val('');
    });

    $('#btn-limpa-ConsultaGrupo').on('click', function () {
        $('#txtConsultaGrupo').val('');
    });

    $('#btn-limpa-ConsultaSetor').on('click', function () {
        $('#txtConsultaSetor').val('');
    });

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaDados();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtConsultaProduto').val('');
        $('#txtConsultaGrupo').val('');
        $('#txtConsultaSetor').val('');
        $('#txtDataDe').val('1200-01-01');
        $('#txtDataAte').val('2500-12-31');
    });

    async function consultaDados() {
        try {
            $.LoadingOverlay("show");
            let produto = pegaChave('#txtConsultaProduto') != '' ? ` AND MAT_PRECO.CODIGO = '${pegaChave('#txtConsultaProduto')}'` : '';
            let grupo = pegaChave('#txtConsultaGrupo') != '' ? ` AND MAT_PRECO.CODIGO_IMPRESSAO = '${pegaChave('#txtConsultaGrupo')}'` : '';
            let setor = pegaChave('#txtConsultaSetor') != '' ? ` AND MAT_PRECO.SETOR = '${pegaChave('#txtConsultaSetor')}'` : '';
            let data = `AND (MAT_PRECO.DATA BETWEEN '${$('#txtDataDe').val()}' AND '${$('#txtDataAte').val()}')`;

            $("#tabelaCadProdPreco").DataTable({
                destroy: true,
                lengthChange: false,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie(
                        "ip_api"
                    )}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "GET",
                    headers: { Authorization: BASIC_AUTH },
                    data: {
                        EMPRESA: getCookie("empresa"),
                        JSON: `{
                        "tabela":"MAT_PRECO",
                        "camposSelect":[ "MAT_PRECO.CODIGO", "MAT_PRECO.DESCRICAO", "MAT_PRECO.PRECO_1", "MAT_PRECO.PRECO_2", "MAT_PRECO.PRECO_3"],
                        "where": ["(MAT_PRECO.TIPO = 'P') ${produto} ${grupo} ${setor} ${data}"]
                    }`
                    },
                },
                columnDefs: [
                    {
                        targets: [0], render: function (data, type, row) {
                            return retornaBotaoOpcoes(row[0]);
                        }
                    },
                    {
                        targets: [2], render: function (data, type, row, meta) {
                            let preco = 0;
                            if (typeof row[2] == 'string' && row[2] != '') {
                                preco = row[2].replace(',', '.');
                            }
                            const precoFormatado = parseFloat(preco).toFixed(3);
                            return precoFormatado == "NaN" ? row[2] : precoFormatado;

                        },
                        "className": 'pr-4 text-right'
                    },
                    {
                        targets: [3], render: function (data, type, row, meta) {
                            let preco = 0;
                            if (typeof row[3] == 'string' && row[3] != '') {
                                preco = row[3].replace(',', '.');
                            }
                            const precoFormatado = (parseFloat(preco)).toFixed(3);
                            return precoFormatado == "NaN" ? row[3] : precoFormatado;

                        },
                        "className": 'pr-4 text-right'
                    },
                    {
                        targets: [4], render: function (data, type, row, meta) {
                            let preco = 0;
                            if (typeof row[4] == 'string' && row[4] != '') {
                                preco = row[4].replace(',', '.');
                            }
                            const precoFormatado = (parseFloat(preco)).toFixed(3);
                            return precoFormatado == "NaN" ? row[4] : precoFormatado;

                        },
                        "className": 'pr-4 text-right'
                    }

                ]

            });

            $.LoadingOverlay("hide");
        } catch (error) {
            $.LoadingOverlay("hide");
            console.error(error);
            msgErro(`Não foi possível buscar os dados do produto`);
        }

    }

    $('#tabelaCadProdPreco').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadProdPreco').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADPRODPRECO', data[0]);
            if (registroLiberado) {
                window.location.href = `cadprodpreco/${data[0]}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProdPreco').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaCadProdPreco').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CADPRODPRECO', data[0]);
            if (registroLiberado) {
                window.location.href = `cadprodpreco/${data[0]}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaCadProdPreco').on('click', '#btn-excluir', async function () {

        const data = $('#tabelaCadProdPreco').DataTable().row($(this).parents('tr')).data();

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"PRECO_ITEN",
            "camposSelect":["DISTINCT ARTIGO"],
            "where": ["PRECO_ITEN.CODIGO = '${data[0]}'", "PRECO_ITEN.EMP_ID = ${getCookie('emp_id')}"]}`,
        )

        if (!response) {
            return;
        }

        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        let jsonStr = (await response.json()).RESULT[0];

        if (jsonStr.length > 0) {
            msgErro(`Artigo utilizado no código ${jsonStr[0].ARTIGO}, impossível continuar.`);
            return;
        }

        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                await excluiRegistro(data[0]);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $("#tabelaCadProdPreco").on("click", "#btn-imprimir", async function () {
        try {
            $.LoadingOverlay("show");

            let data = $("#tabelaCadProdPreco").DataTable().row($(this).parents("tr")).data();
            let url = `/sisplan/impressao/v1/relcadprodpreco?codigo=${data[0]}`;
            const bImprimeAutomatico = await verificaImprimirAutomatico('Cadprodpreco');
            let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'PrecoProduto');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                }
                await limparRelatorios();
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function excluiRegistro(codigo) {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao("DELETE", "/sisplan/cadprodpreco/v1/excluidados?", `CODIGO=${encodeURIComponent(codigo)}&EMP_ID=${getCookie('emp_id')}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.reload();
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

});