$(document).ready(async function () {
  $('#tabelaEtapasSolicitacao').on('click', '#btnEditar', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasSolicitacao').DataTable().row($(this).parents('tr')).data()
    switch (tipo) {
      case 'D':
        window.location.href = `central_compras/solicitacao_digitados`
        break
      case 'B':
        window.location.href = `central_compras/solicitacao_bloqueados`
        break
      case 'R':
        window.location.href = `central_compras/solicitacao_retornados`
        break
      case 'L':
        window.location.href = `central_compras/solicitacao_liberados`
        break
      case 'C':
        window.location.href = `central_compras/solicitacao_cotados`
        break
      case 'N':
        window.location.href = `central_compras/solicitacao_cancelados`
        break
      case 'A':
        window.location.href = `central_compras/solicitacao_atendidos`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  $('#tabelaEtapasSolicitacao').on('dblclick', 'tr', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasSolicitacao').DataTable().row($(this)).data()
    switch (tipo) {
      case 'D':
        window.location.href = `central_compras/solicitacao_digitados`
        break
      case 'B':
        window.location.href = `central_compras/solicitacao_bloqueados`
        break
      case 'R':
        window.location.href = `central_compras/solicitacao_retornados`
        break
      case 'L':
        window.location.href = `central_compras/solicitacao_liberados`
        break
      case 'C':
        window.location.href = `central_compras/solicitacao_cotados`
        break
      case 'N':
        window.location.href = `central_compras/solicitacao_cancelados`
        break
      case 'A':
        window.location.href = `central_compras/solicitacao_atendidos`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!")
    // }
  })
})

window.ItensSolicitacaoAcesso = window.ItensSolicitacaoAcesso || {}

ItensSolicitacaoAcesso.carregarGrafico = ({ data }) => {
  const gradientes = {
    digitados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(219, 219, 219)'],
        [1, 'rgba(89, 89, 89)'],
      ]
    },
    bloqueados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 159, 159)'],
        [1, 'rgba(128, 13, 6)'],
      ]
    },
    retornados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 202, 151)'], ,
        [1, 'rgba(135, 79, 12)'],
      ]
    },
    liberados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(178, 252, 159)'], ,
        [1, 'rgba(24, 117, 0)'],
      ]
    },
    cotados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(157, 192, 252)'], ,
        [1, 'rgba(17, 79, 186)'],
      ]
    },
    cancelados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(91, 227, 214, 1)'],
        [1, 'rgba(19, 148, 136)'],
      ]
    },
    atendidos: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(196, 107, 219)'],
        [1, 'rgba(117, 56, 133)'],
      ]
    },
  }

  const dadosGrafico = []
  const categorias = []

  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Itens de Solicitação ', '')
    dadosGrafico.push({
      y: item.quantidade,
      color: gradientes[nomeItem.toLowerCase()],
    })
    categorias.push(nomeItem)
  })

  GraficosCentralCompras.criarGraficoBarra({ container: 'graficoSolicitacoes', data: dadosGrafico, categories: categorias, })
}

ItensSolicitacaoAcesso.carregarCards = ({ data }) => {
  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Itens de Solicitação ', '')
    $(`#quantidade${nomeItem}Solicitacoes`).html(item.quantidade?.toLocaleString('pt-BR'))
  })
}

ItensSolicitacaoAcesso.criarTabelaEtapas = ({ data, columns }) => {
  if ($.fn.DataTable.isDataTable('#tabelaEtapasSolicitacao')) {
    $('#tabelaEtapasSolicitacao').DataTable().destroy()
    $('#tabelaEtapasSolicitacao').empty()
  }

  $('#tabelaEtapasSolicitacao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    data,
    columns,
    scrollX: true,
    scrollY: '200px',
  })
}