window.PerfilCompras = window.PerfilCompras || {}

PerfilCompras.preencherFiltrosPerfilCompras = async function () {
  $.LoadingOverlay('show')
  try {
    const dados = await PerfilCompras.buscarFiltrosPerfilCompras()

    if (!dados) {
      msgErro(
        'Perfil de compras não cadastrado para o usuário logado, impossível continuar.',
        () => window.history.back(),
        () => window.history.back(),
      )
      return false
    }

    if (dados.centrosCusto) {
      dados.centrosCusto.forEach((item) => adicionaValorPadraoVarios('centroCusto', item?.codigo, item?.descricao))
      $('#txtCentroCusto').prop('disabled', true)
      $('#btnCentroCusto').prop('disabled', true)
      $('#btnLimpaCentroCusto').prop('disabled', true)
    }
    if (dados.tipos) {
      dados.tipos.forEach((item) => adicionaValorPadraoVarios('tipo', item?.codigo, item?.descricao))
      $('#txtTipo').prop('disabled', true)
      $('#btnTipo').prop('disabled', true)
      $('#btnLimpaTipo').prop('disabled', true)
    }

    return true
  } catch (error) {
    console.error(error)
    msgErro('Não foi possível preencher os filtros do perfil de compras.')
    return false
  } finally {
    $.LoadingOverlay('hide')
  }
}

PerfilCompras.buscarFiltrosPerfilCompras = async function () {
  const response = await requisicao(
    'GET',
    `/sisplan/centralcompras/compra/v1/filtrosperfil?`,
    `ID=${getCookie('id_usuario')}`,
    '',
    3600000
  )

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}

PerfilCompras.buscarFiltrosPerfilCompras = async function () {
  const response = await requisicao(
    'GET',
    `/sisplan/centralcompras/compra/v1/filtrosperfil?`,
    `ID=${getCookie('id_usuario')}`,
    '',
    3600000
  )

  const json = await response.json()

  if (json) {
    const { resultado, mensagem } = json
    if (mensagem?.codigo !== 200) {
      throw mensagem?.mensagem
    }

    return resultado
  }
}