$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    })
    driver.defineSteps([
      {
        element: "#tutorial-step1",
        popover: {
          title: "Campos",
          description:
            "Aqui se encontram os campos essenciais para consultar e gravar as informações.",
          position: "bottom",
        },
      },
      {
        element: '#btnVoltar',
        popover: {
          title: 'Voltar',
          description: 'Aqui está o botão para voltar à consulta.',
          position: 'bottom'
        }
      },
      {
        element: '#btnGravar',
        popover: {
          title: 'Gravar',
          description: 'Aqui está o botão para gravar as informações.',
          position: 'bottom'
        }
      }
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('solicitacao', true, true, 'Numero')
  componenteFiltro('funcionario', true, true, 'Solicitante')
  componenteFiltro('tipo', true, true)
  componenteFiltro('centroCusto', true, true)
  componenteFiltro('itemSolicitacao', true, true, 'Codigo')
  componenteFiltro('cor', true, true)
  componenteFiltro('tamanho2', true, true, 'Tamanho')
  componenteFiltro('usuario3', true, true, 'Usuario', ["ATIVO = 'S'", "NOME NOT LIKE '[PERCENTUAL]TODOS[PERCENTUAL]'"])
  componenteFiltro('grupoMA', true, true, 'GrupoMaterial', ["TIPO = 'M'"])
  componenteFiltro('grupoPA', true, true, 'GrupoProduto')
  componenteFiltro('grupoMA', true, true, 'GrupoServico', ["TIPO = 'S'"])
  componenteFiltro('subGrupo', true, true, 'SubgrupoMaterial')

  $('#btnConsultar').on('click', function () {
    ItensSolicitacaoLiberados.idsSelecionados.clear()
    ItensSolicitacaoLiberados.consultar()
    $('#modalFiltros').modal('hide')
  })

  $('#tabelaItens').on('click', '#btnInformacoesItem', async function () {
    const datatableItens = $('#tabelaItens').DataTable()
    const { codigo, cor, tamanho, tipoItem } = datatableItens?.row($(this)?.parents('tr'))?.data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    const { codigo, cor, tamanho, tipoItem } = $('#tabelaItens').DataTable().row($(this)).data()
    ModalInformacoesItemCentralCompras.carregarModalInformacoesItem(codigo, cor, tamanho, tipoItem)
  })

  $("#tabelaItens").on('change', '.checkSel', function () {
    const linha = $(this).closest('tr')
    const [data] = $('#tabelaItens').DataTable().rows(linha).data().toArray()
    const { id } = data
    const isChecked = this.checked
    $(linha).toggleClass('selected', isChecked)

    if (!isChecked) {
      ItensSolicitacaoLiberados.idsSelecionados.delete(id)
      return
    }

    ItensSolicitacaoLiberados.idsSelecionados.add(id)
  })

  PerfilSolicitacoes.preencherFiltrosPerfilCompras().then((result) => {
    if (!result) {
      return
    }
    ItensSolicitacaoLiberados.consultar()
  })

  $('#btnRetornar').on('click', function () {
    const idsSelecionados = [...ItensSolicitacaoLiberados.idsSelecionados]
    if (!idsSelecionados || idsSelecionados.length === 0) return msgErro('Nenhum registro selecionado.')
    $('#modalRetornar').modal('show')
  })

  $('#btnConfirmarRetornar').on('click', () => {
    const idsSelecionados = [...ItensSolicitacaoLiberados.idsSelecionados]
    retornar({ idsSelecionados, obsRetorno: $('#txtObsRetorno').val(), idUsuario: getCookie('id_usuario') })
  })

  const retornar = async ({ idsSelecionados, obsRetorno, idUsuario }) => {
    try {
      $.LoadingOverlay('show')
      const response = await requisicao('PUT', `/sisplan/centralcompras/solicitacao/v1/retornar?`, '', JSON.stringify({ ids: idsSelecionados, obsRetorno, idUsuario }), 3600000)

      const dados = await response.json()
      if (dados) {
        const { mensagem } = dados
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onShown() {
            $('#modalRetornar').modal('hide')
            ItensSolicitacaoLiberados.idsSelecionados.clear()
            ItensSolicitacaoLiberados.consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }
    } catch (error) {
      console.error(error)
      msgErro('Ocorreu um erro ao retornar os itens selecionados.')
    } finally {
      $.LoadingOverlay('hide')
    }
  }

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnLimparFiltros').on('click', function () {
    limparFiltros()
  })

  function limparFiltros() {
    $('#txtNumero').empty().trigger('change')
    if (!$('#txtTipo').prop('disabled')) {
      $('#txtTipo').empty().trigger('change')
    }
    if (!$('#txtCentroCusto').prop('disabled')) {
      $('#txtCentroCusto').empty().trigger('change')
    }
    $('#txtCodigo').empty().trigger('change')
    $('#txtCor').empty().trigger('change')
    $('#txtTamanho').empty().trigger('change')
    $('#txtUsuario').empty().trigger('change')
    if (!$('#txtGrupoMaterial').prop('disabled')) {
      $('#txtGrupoMaterial').empty().trigger('change')
    }
    if (!$('#txtGrupoProduto').prop('disabled')) {
      $('#txtGrupoProduto').empty().trigger('change')
    }
    if (!$('#txtGrupoServico').prop('disabled')) {
      $('#txtGrupoServico').empty().trigger('change')
    }
    if (!$('#txtSubgrupoMaterial').prop('disabled')) {
      $('#txtSubgrupoMaterial').empty().trigger('change')
    }
    $('#txtCadastroDe').val('1200-01-01')
    $('#txtCadastroAte').val('2500-12-31')
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/central_compras`
  })
})

window.ItensSolicitacaoLiberados = window.ItensSolicitacaoLiberados || {}

ItensSolicitacaoLiberados.idsSelecionados = new Set()

ItensSolicitacaoLiberados.criarTabelaItens = ({ filtros }) => {
  if ($.fn.DataTable.isDataTable('#tabelaItens')) {
    $('#tabelaItens').DataTable().destroy()
    $('#tabelaItens').empty()
  }

  const columns = [
    {
      data: 'sel',
      title: `<div class="icheck-primary d-inline">
                <input type="checkbox" id="cbSelAll">
                <label for="cbSelAll"></label>
              </div>
              `,
      render: (_data, _type, _row, { row: rowIndex, col: colIndex }) => (
        `<div class="icheck-primary d-inline">
          <input type="checkbox" id="check_col_${colIndex}_row_${rowIndex}" class="checkSel">
          <label for="check_col_${colIndex}_row_${rowIndex}"></label>
        </div>`
      )
    },
    {
      data: 'numero',
      title: 'Número',
      render: (data) => (
        '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Informações Item" id="btnInformacoesItem">Informações Item</button>     ' +
        '</div>'
      )
    },
    {
      data: 'dataCadastro',
      title: 'Cadastro',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataEmissao',
      title: 'Emissão',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataEntrega',
      title: 'Entrega',
      render(data) {
        return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
      },
    },
    {
      data: 'dataBaixa',
      title: 'Baixa',
      render(data) {
        try {
          const date = new Date(data)
          if (date.getFullYear() < 2000) {
            return ''
          }

          return retornarDataISOEmYMD({ dataISO: data, reverso: true, usarUTC: true })
        } catch (_) {
          return ''
        }
      },
    },
    {
      data: 'solicitante',
      title: 'Solicitante',
    },
    {
      data: 'descricaoSolicitante',
      title: 'Descrição Solicitante',
    },
    {
      data: 'codigo',
      title: 'Código',
    },
    {
      data: 'descricao',
      title: 'Descrição',
    },
    {
      data: 'cor',
      title: 'Cor',
    },
    {
      data: 'descricaoCor',
      title: 'Descrição Cor',
    },
    {
      data: 'tamanho',
      title: 'Tamanho',
    },
    {
      data: 'descricaoTamanho',
      title: 'Descrição Tamanho',
      visible: false,
    },
    {
      data: 'ordem',
      title: 'Ordem',
    },
    {
      data: 'tipoItem',
      title: 'Tipo Item',
    },
    {
      data: 'observacao',
      title: 'Observação',
    },
    {
      data: 'codigoCliente',
      title: 'Código Cliente',
    },
    {
      data: 'nomeCliente',
      title: 'Nome Cliente',
    },
    {
      data: 'prazo',
      title: 'Prazo',
      visible: false,
    },
    {
      data: 'descricaoPrazo',
      title: 'Descrição Prazo',
      visible: false,
    },
    {
      data: 'colecao',
      title: 'Coleção',
      visible: false,
    },
    {
      data: 'descricaoColecao',
      title: 'Descrição Coleção',
      visible: false,
    },
    {
      data: 'motivo',
      title: 'Motivo',
      visible: false,
    },
    {
      data: 'descricaoMotivo',
      title: 'Descrição Motivo',
      visible: false,
    },
    {
      data: 'tipo',
      title: 'Tipo',
    },
    {
      data: 'descricaoTipo',
      title: 'Descrição Tipo',
    },
    {
      data: 'tabelaPreco',
      title: 'Tabela de Preço',
      visible: false,
    },
    {
      data: 'descricaoTabelaPreco',
      title: 'Descrição Tabela Preço',
      visible: false,
    },
    {
      data: 'centroCusto',
      title: 'Centro de Custo',
    },
    {
      data: 'descricaoCentroCusto',
      title: 'Descrição Centro de Custo',
    },
    {
      data: 'deposito',
      title: 'Depósito',
      visible: false,
    },
    {
      data: 'descricaoDeposito',
      title: 'Descrição Depósito',
      visible: false,
    },
    {
      data: 'ordemCompra',
      title: 'O.C.',
    },
    {
      data: 'fornecedorOrdemCompra',
      title: 'Descrição O.C.',
      visible: false,
    },
    {
      data: 'contaContabil',
      title: 'Conta Contábil',
      visible: false,
    },
    {
      data: 'descricaoContaContabil',
      title: 'Descrição Conta Contábil',
      visible: false,
    },
    {
      data: 'especificacao',
      title: 'Especificação',
    },
    {
      data: 'unidade',
      title: 'Unidade',
    },
    {
      data: 'unidadeCompra',
      title: 'Unidade de Compra',
    },
    {
      data: 'fatorConversao',
      title: 'Fator de Conversão',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'quantidade',
      title: 'Quantidade',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'preco',
      title: 'Preço',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'valor',
      title: 'Valor',
      className: 'text-right',
      render: function (data) {
        return retornarFloatFormatadoEmMonetario({ valor: data, quantidadeCasasDecimais: 2 })
      }
    },
    {
      data: 'status',
      title: 'Situação',
    },
    {
      data: 'nomeUltimoAprovador',
      title: 'Último Aprovador',
    },
    {
      data: 'aprovadoEm',
      title: 'Aprovado Em',
      render: function (data) {
        return retornarDataISOEmYMD({
          dataISO: new Date(data),
          incluirHora: true,
          reverso: true,
          usarUTC: true,
        })
      }
    },
    {
      data: 'usuario',
      title: 'Usuário',
    },
    {
      data: 'codigoUltimoFornecedor',
      title: 'Código Último Fornecedor',
    },
    {
      data: 'nomeUltimoFornecedor',
      title: 'Nome Último Fornecedor',
    },
    {
      data: 'id',
      title: 'Id',
      visible: false,
    },
  ]

  $('#tabelaItens').DataTable({
    sort: false,
    paging: true,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    pageLength: 18,
    colReorder: true,
    serverSide: true,
    ajax: {
      url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/centralcompras/solicitacao/v1/itensliberados`,
      type: "POST",
      headers: {
        'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
      },
      data: function (data) {
        const { start, length, draw } = data;
        return JSON.stringify({
          filtros,
          paginacao: {
            quantidadeMaximaRegistros: length,
            quantidadeRegistrosPular: start,
            contadorRequisicoes: draw,
          },
          empresa: getCookie('empresa')
        })
      },
      dataSrc: function (json) {
        if (!json || !json.data) {
          return []
        }
        return json.data
      },
      cache: true,
      beforeSend: function () {
        $.LoadingOverlay('show')
      },
      complete: function () {
        $.LoadingOverlay('hide')
      },
    },
    autoWidth: true,
    columns,
    scrollX: true,
    scrollY: '737px',
    rowCallback: function (row, data) {
      const ids = [...ItensSolicitacaoLiberados.idsSelecionados]
      const isChecked = ids?.some(item => item === data.id) ?? false
      $(row).toggleClass('selected', isChecked)
      const checkbox = $(row).find('.checkSel')
      $(checkbox).prop('checked', isChecked)
    }
  })
  ItensSolicitacaoLiberados.adicionarEventoSelecionarTodos()
  UtilsCentralCompras.criarContainerBotoes({
    tabela: 'tabelaItens',
  })
  UtilsCentralCompras.habilitarEsconderColunasItensSolicitacao({
    tabela: 'tabelaItens',
    tela: 'itensSolicitacaoLiberados',
  })
  UtilsCentralCompras.habilitarExportarCsv({
    tabela: 'tabelaItens',
    status: 'L',
    tipo: 'SOL',
    retornarFiltros: ItensSolicitacaoLiberados.retornarFiltros,
  })
}

ItensSolicitacaoLiberados.adicionarEventoSelecionarTodos = () => {
  $('#cbSelAll').off('change')
  $('#cbSelAll').on('change', async function () {
    const isChecked = this.checked
    const table = $('#tabelaItens').DataTable()
    if (table.rows().count() === 0) {
      msgErro('Nenhum item a ser selecionado.')
      $(this).prop('checked', false)
      return
    }
    if (!isChecked) {
      ItensSolicitacaoLiberados.idsSelecionados.clear()
      table.draw(false)
      return
    }

    const filtros = await ItensSolicitacaoLiberados.retornarFiltros()

    $.LoadingOverlay('show')
    requisicao(
      'POST',
      `/sisplan/centralcompras/solicitacao/v1/selecionartodositensliberados?`,
      '',
      JSON.stringify({ filtros }),
      3600000
    ).then(async (response) => {
      const json = await response.json()

      if (json) {
        const { resultado, mensagem } = json
        if (mensagem?.codigo !== 200) {
          throw mensagem?.mensagem
        }
        if (!resultado)
          throw new Error('Ids não foram buscados corretamente do back-end.')

        if (!resultado.ids)
          throw new Error('Nenhum id foi encontrado.')

        const { ids } = resultado
        ids.forEach((id) => ItensSolicitacaoLiberados.idsSelecionados.add(id))
      }
      table.draw(false)
    }).catch((error) => {
      console.error(error)
      msgErro('Ocorreu um erro ao selecionar todos os itens.')
    }).finally(() => $.LoadingOverlay('hide'))
  })
}

ItensSolicitacaoLiberados.retornarFiltros = async function () {
  const cadastroDe = $('#txtCadastroDe').val() || '1200-01-01'
  const cadastroAte = $('#txtCadastroAte').val() || '1200-01-01'
  const numero = await formataListas($('#txtNumero').val().toString())
  const solicitante = await formataListas($('#txtSolicitante').val().toString())
  const tipo = await formataListas($('#txtTipo').val().toString(), true)
  const centroCusto = await formataListas($('#txtCentroCusto').val().toString())
  const codigo = await formataListas($('#txtCodigo').val().toString())
  const cor = await formataListas($('#txtCor').val().toString())
  const tamanho = await formataListas($('#txtTamanho').val().toString())
  const usuario = await formataListas($($('#txtUsuario')?.[0]?.innerHTML)?.toArray().map((it) => pegaDescricao($(it).text())).toString())
  const grupoMaterial = await formataListas($('#txtGrupoMaterial').val().toString())
  const grupoProduto = await formataListas($('#txtGrupoProduto').val().toString())
  const grupoServico = await formataListas($('#txtGrupoServico').val().toString())
  const subgrupoMaterial = await formataListas($('#txtSubgrupoMaterial').val().toString())

  return {
    cadastroDe,
    cadastroAte,
    numero,
    solicitante,
    tipo,
    centroCusto,
    codigo,
    cor,
    tamanho,
    usuario,
    grupoMaterial,
    grupoProduto,
    grupoServico,
    subgrupoMaterial,
  }
}

ItensSolicitacaoLiberados.consultar = function () {
  ItensSolicitacaoLiberados.retornarFiltros()
    .then((filtros) => {
      ItensSolicitacaoLiberados.criarTabelaItens({ filtros })
    })
}