function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let d = parametros[parametros.length - 1];
    let gBanco;
    let gCampo;
    let gTipo;
    let gCarteira;
    let gPosicoes240 = 'create';

    if (d != 'create') {
        $('#txtBanco').prop('disabled', true);
        $('#txtCampo').prop('disabled', true);
        gBanco = d.split('-')[0];
        gCampo = d.split('-')[1];
        gTipo = d.split('-')[2];
        gCarteira = d.split('-')[3];
        gPosicoes240 = d.split('-')[4];
    }

    componenteFiltro('carteira');

    await preencheDados();

    async function preencheDados() {

        try {
            $.LoadingOverlay('show');

            try {

                where = `["POSICAO.BANCO = '${gBanco}'", "POSICAO.CAMPO = '${gCampo}'", "POSICAO.TIPO = '${gTipo}'"`;

                if (gCarteira != '') {
                    where += `, "POSICAO.CARTEIRA = '${gCarteira}'"`;
                }

                where += ']';

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"POSICAO",
                "camposSelect":["POSICAO.BANCO", "POSICAO.CAMPO", "POSICAO.INICIO", "POSICAO.TAMANHO", "POSICAO.TIPO", "POSICAO.SEPARADOR",
                                "POSICAO.CARTEIRA", "CARTEIRA.DESCRICAO DESC_CARTEIRA", "POSICAO.IDENT_SEGUIMENTO", "POSICAO.TAM_AUX", "POSICAO.FIXO1",
                                "POSICAO.FIXO2", "POSICAO.POSICOES_240"],
                "leftjoin": [
                            {"tabela" : "CARTEIRA", "condicao" : "POSICAO.CARTEIRA = CARTEIRA.CARTEIRA"}
                ],
                "where": ${where}}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                $('#txtBanco').val(gBanco);
                $('#txtInicio').val(data[0].INICIO);
                $('#txtTamanho').val(data[0].TAMANHO);
                $('#txtSeparador').val(data[0].SEPARADOR);
                insereValor('#txtCarteira', gCarteira, data[0].DESC_CARTEIRA);
                $('#txtIdSeg').val(data[0].IDENT_SEGUIMENTO);
                $('#txtTipo').val(gTipo);
                $('#txtCampo').val(gCampo);
                $('#cb240Posicoes').prop('checked', gPosicoes240 == 'S');
            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#txtCampo').on('change', function () {
        if ($('#txtCampo').val() == 'NR_BANCO') {
            $('#divSegundaOpcao').removeClass('d-none');
        } else {
            $('#divSegundaOpcao').addClass('d-none');
        }
    })

    $('#btnGravar').on('click', async function () {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"POSICAO",
            "camposSelect":["BANCO"],
            "where": ["BANCO = '${$('#txtBanco').val()}'", "CAMPO = '${$('#txtCampo').val()}'", "CARTEIRA = '${$('#txtCarteira').val()}'"]}`,
        )

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        if (jsonStr.RESULT[0].length > 0 && d == 'create') {
            throw msgErro('Já existe um registro com este banco, campo e carteira. Favor verificar.');
        }

        if ($('#txtBanco').val() == '') {
            throw msgErro('É necessário informar um banco. Favor verificar.');
        }
        if ($('#txtCampo').val() == '' || $('#txtCampo').val() == null || $('#txtCampo').val() == undefined) {
            throw msgErro('É necessário selecionar um campo. Favor verificar.');
        }

        await gravaDados();
    })

    async function gravaDados() {
        try {
            $.LoadingOverlay('show');
            try {
                posicao = {};

                let sBanco = d == 'create' ? $('#txtBanco').val() : gBanco;
                let sCampo = d == 'create' ? $('#txtCampo').val() : gCampo;
                let sCarteira = d == 'create' ? $('#txtCarteira').val() : gCarteira;

                posicao.BANCO = $('#txtBanco').val();
                posicao.CAMPO = $('#txtCampo').val();
                posicao.INICIO = parseInt($('#txtInicio').val());
                posicao.TAMANHO = parseInt($('#txtTamanho').val());
                posicao.TIPO = $('#txtTipo').val();
                posicao.SEPARADOR = $('#txtSeparador').val();
                posicao.CARTEIRA = pegaChave('#txtCarteira');
                posicao.IDENT_SEGUIMENTO = $('#txtIdSeg').val();
                posicao.TAM_AUX = parseInt($('#txtSegundaOpcao').val());
                posicao.BANCO_ORIG = sBanco;
                posicao.CAMPO_ORIG = sCampo;
                posicao.TIPO_ORIG = gTipo;
                posicao.CARTEIRA_ORIG = sCarteira;
                posicao.POSICOES_240 = isChecked('#cb240Posicoes') ? 'S' : 'N';
                posicao.POSICOES_240_ORIG = gPosicoes240;

                let response = await requisicao("POST", `/Sisplan/Cadastros/V1/escposicao?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(posicao))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Dados gravados com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/escposicao`;
                    },
                })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (e) {
                console.log(e);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    $('#btnVoltar').on('click', function () {
        msgAlerta('Tem certeza que deseja cancelar as alterações?', () => {
            window.location.href = `${BASE_URI}/escposicao`
        })
    })


    $("#tutorial").on("click", function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: "Sair",
                closeBtnText: "Fechar",
                nextBtnText: "Próximo",
                prevBtnText: "Anterior",
                allowClose: false,
            });
            driver.defineSteps([
                {
                    element: "#msform",
                    popover: {
                        title: "Dados",
                        description:
                            "Aqui você informa os dados da posição.",
                        position: "right",
                    },
                },
                {
                    element: "#btnVoltar",
                    popover: {
                        title: "Botão Voltar",
                        description:
                            "Clique neste botão para voltar para a tela de acesso",
                        position: "right",
                    },
                },
                {
                    element: "#btnGravar",
                    popover: {
                        title: "Botão Gravar",
                        description: "Clique neste botão para gravar os dados.",
                        position: "top",
                    },
                },
            ]);
            driver.start();
        });
    });
});