componenteFiltro("banco", false, false, "BancoAsaas");
componenteFiltro("conta", false, false, "ContaAsaas");
componenteFiltro("classe", false, false, "ClasseBaixaAsaas");
componenteFiltro("classe", false, false, "ClasseTaxaAsaas");
componenteFiltro("historico", false, false, "HistoricoAsaas");
componenteFiltro("moeda", false, false, "MoedaAsaas");

async function criaDataTableAsaas() {
  let valDifParam = await buscaValoresDifParametroEscritural();
  let controlaValorDifParam = await controlaValorDifParametroEscritural();

  if ($.fn.DataTable.isDataTable('#tabelaAsaas')) {
    $('#tabelaAsaas').DataTable().destroy();
    $('#tabelaAsaas').empty();
  };

  $("#tabelaAsaas").DataTable({
    paging: true,
    filter: false,
    info: false,
    length: false,
    order: false,
    destroy: true,
    data: {},
    columns: dataSetColsAsaas,
    columnDefs: [
      {
        targets: [0], render: function (_data, _type, _row, meta) {
          let selecionaDif = false;

          if (controlaValorDifParam == true) {
            if (Math.abs(_row.VALOR_LIQUIDO - _row.VALOR) >= valDifParam) {
              selecionaDif = false;
            } else {
              selecionaDif = true;
            }
          };

          if ((!(_row.NUMERO == '') && !(_row.VALOR_PAGO >= _row.VALOR_LIQUIDO) && (selecionaDif == true)) || (!(_row.NUMERO == '') && (_row.VALOR_PAGO < _row.VALOR_LIQUIDO)) ) {
            _row.SEL = 'S';
          } else {
            _row.SEL = 'N';
          };

          return `<div class="icheck-primary d-inline">
										<input type="checkbox" ${(_row.SEL === 'S') ? 'checked' : ''} ${((_row.NUMERO == '') || (_row.VALOR_PAGO == _row.VALOR_LIQUIDO)) ? 'disabled' : ''} class="checkboxSelTabAsaas" id="check_col_${meta.row}_row_${meta.col}">
										<label for="check_col_${meta.row}_row_${meta.col}"></label>
									</div>`;
        },
      },
      {
        type: 'date-br',
        targets: [11, 12, 13],
        render(data) {
          if (data) {
            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
          } else {
            return '';
          }

        },
      },
      {
        targets: [5, 6, 7, 8, 16],
        render(data) {
          if (data < 0) {
            return `-${parseFloat(Math.abs(data)).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;
          } else {
            return parseFloat(data).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
          }
        },
        "className": 'pr-4 text-right'
      }
    ],
    rowCallback: async function (row, data) {
      if (data.NUMERO == '') {
        $(row).css('background-color', '#B4524D');
        $(row).css('color', '#ecfdff');
      }
      else if (data.VALOR_PAGO === data.VALOR_LIQUIDO) {
        $(row).css('background-color', '#3A5E44');
        $(row).css('color', '#ecfdff');
      }
      else if (data.VALOR != data.VALOR_LIQUIDO) {
        $(row).css('background-color', '#04336C');
        $(row).css('color', '#ecfdff');
      }
    },
  });
};

$('#btnVerBaixasAsaas').on('click', async function () {
  await insereDadosNaTabelaAsaas();
});

$('#btnConfirmarAsaas').on('click', async function () {
  await gravaDadosNaTabelaAsaas();
});

$('#txtContaAsaas').on('blur', async function () {
  if ($(this).val() != '') {
    const conta = pegaChave('#txtContaAsaas');

    const pesquisaBanco = {
      tabela: "CADCONTA",
      camposSelect: ["CADCONTA.BANCO", "CADBAN.NOME_BANCO"],
      innerJoin: [
        { "tabela": "CADBAN", "condicao": "CADBAN.BANCO = CADCONTA.BANCO" }
      ],
      where: [`CADCONTA.CONTA = '${conta}'`]
    };

    const jsonBanco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaBanco));

    if (jsonBanco.length == 0) {
      return;
    };

    $('#txtBancoAsaas').val(`[${jsonBanco[0].BANCO}] - ${jsonBanco[0].NOME_BANCO}`);
  }
});

$('#txtBancoAsaas').on('blur', async function () {
  if ($(this).val() == '') {
    $('#txtContaAsaas').val('');
  }
});

$('#txtContaAsaas').on('blur', async function () {
  if ($(this).val() == '') {
    $('#txtBancoAsaas').val('');
  }
});

$('#btnLimpaBancoAsaas').on('click', async function () {
  $('#txtContaAsaas').val('');
});

$('#btnLimpaContaAsaas').on('click', async function () {
  $('#txtBancoAsaas').val('');
});

function retornaFiltrosAsaas() {
  const banco = pegaChave('#txtBancoAsaas');
  const conta = pegaChave('#txtContaAsaas');
  const classeBaixa = pegaChave('#txtClasseBaixaAsaas');
  const classeTaxa = pegaChave('#txtClasseTaxaAsaas');
  const historico = pegaChave('#txtHistoricoAsaas');
  const moeda = pegaChave('#txtMoedaAsaas');

  return `BANCO=${banco}&CONTA=${conta}&CLASSE_BAIXA=${classeBaixa}&CLASSE_TAXA=${classeTaxa}&HISTORICO=${historico}&MOEDA=${moeda}`;
};

async function insereDadosNaTabelaAsaas() {
  $.LoadingOverlay('show');
  try {
    await criaDataTableAsaas();

    const url = '/sisplan/escretorno/v1/buscabaixasasaas?';

    const listaRegistrosAsaas = [];

    for (let i = 0; i < window.databody.length; i++) {
      const obj = {
        "sel": window.databody[i].sel,
        "nsu": window.databody[i].nsu,
        "parcela": window.databody[i].parcela,
        "dt_pagamento": window.databody[i].dt_pagamento,
        "valor_liquido": window.databody[i].valor,
      };
      listaRegistrosAsaas.push(obj);
    };

    let response = await requisicao('POST', url, '', `LISTA_REGISTROS=${encodeURIComponent(JSON.stringify({ DATA: listaRegistrosAsaas }))}`, 500000, false);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (!jsonStr || jsonStr.length === 0) {
      msgAlerta('Não foi possível encontrar os dados das baixas do extrato de cartão Asaas. Por favor, tente novamente.');
      return
    };

    for (let j = 0; j < jsonStr.length; j++) {
      const index = listaRegistrosAsaas.findIndex(item => item.nsu === jsonStr[j].NSU);

      if (index > -1) {
        jsonStr[j].VALOR_LIQUIDO = listaRegistrosAsaas[index].valor_liquido;
      };
    };

    $('#tabelaAsaas').DataTable().rows.add(jsonStr).draw(false);

    $('#tabelaAsaas tbody').on('change', '.checkboxSelTabAsaas', function () {

      const table = $('#tabelaAsaas').DataTable();

      const row = table.row($(this).closest('tr'));
      const data = row.data();

      if (this.checked) {
        data.SEL = 'S';
      } else {
        data.SEL = 'N';
      }
    });

  } catch (error) {

    console.error(error);
    msgErro(`Ocorreu um erro ao ver as baixas do arquivo Asaas! Por favor, verifique. Erro: ${error}`);

  } finally {
    $.LoadingOverlay('hide');
  }
};

async function gravaDadosNaTabelaAsaas() {
  $.LoadingOverlay('show');
  try {
    const url = '/sisplan/escretorno/v1/gravabaixasasaas?';

    const paramsReceber = await BuscaParametrosReceber();

    if (paramsReceber[15].VALOR == '0' && isEmpty($('#txtClasseBaixaAsaas'))) {
      await msgAguardaConfirmacao('Classe/Baixa não informado, deseja utilizar a classe das Duplicatas?', () => { }, () => { throw new Error('Operação Cancelada!') })
    } else if (paramsReceber[15].VALOR == '1' && isEmpty($('#txtClasseBaixaAsaas'))) {
      return msgAlerta('Classe/Baixa não informado, verifique!')
    }

    const params = retornaFiltrosAsaas();

    const listaBaixasAsaas = [];

    const dataTableAsaas = $('#tabelaAsaas').DataTable().rows().data();

    for (let i = 0; i < dataTableAsaas.length; i++) {
      if (dataTableAsaas[i].SEL === 'S') {
        const obj = {
          "NUMERO": dataTableAsaas[i].NUMERO,
          "CODCLI": dataTableAsaas[i].COD_CLI,
          "DT_PAGAMENTO": dataTableAsaas[i].DT_PAGAMENTO,
          "VALOR": dataTableAsaas[i].VALOR,
          "VALOR_LIQUIDO": dataTableAsaas[i].VALOR_LIQUIDO,
          "VALOR_PAGO": dataTableAsaas[i].VALOR_LIQUIDO,
          "DT_EMISSAO": dataTableAsaas[i].DT_EMISSAO,
          "FATURA": dataTableAsaas[i].FATURA,
          "CLASSE_DUP": dataTableAsaas[i].CLASSE_DUP,
          "BANCO_DUP": dataTableAsaas[i].BANCO,
          "CONTA_DUP": dataTableAsaas[i].CONTA,
        };
        listaBaixasAsaas.push(obj);
      }
    };
    if (listaBaixasAsaas.length === 0) {
      msgAlerta('Nenhum registro selecionado para baixa. Por favor, selecione ao menos um registro.');
      return;
    };

    let response = await requisicao('POST', url, '', `${params}&LISTA_BAIXAS=${encodeURIComponent(JSON.stringify({ DATA: listaBaixasAsaas }))}`, 500000, false);

    if (!response) {
      return;
    }

    if (response.status !== 200) {
      msgAlerta('Não foi possível gravar os dados das baixas do extrato de cartão Asaas. Por favor, tente novamente.');
      return
    };

    await criaMensagemSucesso('Baixas do arquivo Asaas gravadas com sucesso!', () => { window.location.reload() });

  } catch (error) {
    console.error(error);
    msgErro(`Ocorreu um erro ao gravar as baixas do arquivo Asaas! Por favor, verifique. Erro: ${error}`)
  } finally {
    $.LoadingOverlay('hide');
  }
}
