$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros..",
          position: "right",
        },
      },
      {
        element: "#btnNovaExp",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar uma expedição.",
          position: "right",
        },
      },
      {
        element: "#tabelaClientesForne",
        popover: {
          title: "Tabela Caixas",
          description: "Aqui estão as caixas expedidas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  await setarDataAtual('txtDataIni', 1);

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });


  $('#txtCaixa').on('change', async function () {
    let caixa = $('#txtCaixa').val();

    if (caixa == '') {
      return;
    }

    if (pegaChave('#txtCaixa').length > 1) {
      caixa = pegaChave('#txtCaixa');
    }

    const pesquisaParam = {
      tabela: 'PEDIDO3',
      camposSelect: ['PEDIDO3.CAIXA', 'ENTIDADE.NOME'],
      leftJoin: [
        { tabela: 'PEDIDO', condicao: 'PEDIDO.NUMERO = PEDIDO3.NUMERO' },
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }
      ],
      where: [`PEDIDO3.CAIXA = '${caixa}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum pedido encontrado');
      $('#txtCaixa').val('');
      $('#txtCaixa').focus();
    }

    insereValor('#txtCaixa', caixa, jsonStr[0].NOME);
  });

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.expedicao == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, expedicao: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaExpedidos').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.expedicao ?? ['EMPRESA']);
  })


  $('#btnCaixa').pesquisa_serverside(
    ['#txtCaixa'],
    ['PEDIDO3.CAIXA'],
    ['ENTIDADE.NOME'],
    `{
      "tabela":"PEDIDO3", 
      "camposSelect":["PEDIDO3.CAIXA", "ENTIDADE.NOME"], 
      "leftjoin": [
        {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},
        {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
      ],
      "groupby": ["PEDIDO3.CAIXA", "ENTIDADE.NOME"]
    }`,
    'Pesquisa Caixa'
  );

  $('#btnACaixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#txtPedido').on('change', async function () {
    let pedido = $('#txtPedido').val();

    if (pedido == '') {
      return;
    }

    if (pegaChave('#txtPedido').length > 1) {
      pedido = pegaChave('#txtPedido');
    }

    const pesquisaParam = {
      tabela: 'PEDIDO',
      camposSelect: ['ENTIDADE.NOME'],
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }],
      where: [`PEDIDO.NUMERO = '${pedido}'`]
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length == 0) {
      msgAlerta('Nenhum pedido encontrado');
      $('#txtPedido').val('');
      $('#txtPedido').focus();
    }

    insereValor('#txtPedido', pedido, jsonStr[0].NOME);
  });

  $('#btnPedido').pesquisa_serverside(
    ['#txtPedido'],
    ['PEDIDO3.NUMERO'],
    ['ENTIDADE.NOME'],
    `{
    "tabela":"PEDIDO3", 
    "camposSelect":["PEDIDO3.NUMERO", "ENTIDADE.NOME"], 
    "leftjoin": [
      {"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},
      {"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}
    ],
    "groupby": ["PEDIDO3.NUMERO", "ENTIDADE.NOME"]
  }`,
    'Pesquisa Pedido'
  );

  $('#btnAPedido').on('click', function () {
    $('#txtPedido').val('');
  });


  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>       ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '   </div>'
    );
  }

  function retornaBotaoOpcoes(pedido) {
    var retorno = '<div style="text-align:start;"> ' +
      '   <div class="dropdown" style="position: initial"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + pedido + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-editar" type="button" class="dropdown-item">Alterar</button>' +
      '    <button id="btn-excluir" type="button" class="dropdown-item">Excluir</button>' +
      `    <button id="btn-imprimirIndividual" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelExpedicaoIndividual.FR3"' : ''} class="dropdown-item">Imprimir</button>` +
      `    <button id="btn-imprimirEtiqueta" type="button" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelEtiquetaExpedicao.FR3"' : ''} class="dropdown-item">Imprimir Etiqueta</button>`;
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  await consultaExp();

  $("#btnConsultar").on("click", async function () {
    await consultaExp();
    $("#modal-filtros").modal("hide");
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#txtCaixa').val('');
    $('#txtPedido').val('');
    $('#txtDataIni').val('');
  });

  async function consultaExp() {
    $.LoadingOverlay('show');
    try {
      let params = '1 = 1';
      params += pegaChave('#txtCaixa') != '' ? ` AND PEDIDO3.CAIXA = '${pegaChave('#txtCaixa')}'` : '';
      params += pegaChave('#txtPedido') != '' ? ` AND PEDIDO3.NUMERO = '${pegaChave('#txtPedido')}'` : '';
      params += $('#txtDataIni').val() != '' ? ` AND PEDIDO3.DATA >= '${$('#txtDataIni').val()}'` : '';
      params += $('#txtDataFim').val() != '' ? ` AND PEDIDO3.DATA <= '${$('#txtDataFim').val()}'` : '';

      $('#tabelaExpedidos').DataTable({
        destroy: true,
        info: false,
        lengthChange: true,
        serverSide: true,
        processing: true,
        colReorder: true,
        scrollY: "50vh",
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "POST",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{` +
              `"tabela":"PEDIDO3",` +
              `"camposSelect":["PEDIDO3.CAIXA", "ENTIDADE.NOME"], ` +
              `"leftjoin": [` +
              `{"tabela": "PEDIDO", "condicao": "PEDIDO.NUMERO = PEDIDO3.NUMERO"},` +
              `{"tabela": "ENTIDADE", "condicao": "ENTIDADE.CODCLI = PEDIDO.CODCLI"}` +
              `],` +
              `"groupby": ["PEDIDO3.CAIXA", "ENTIDADE.NOME"],` +
              `"where": ["${params}"]` +
              `}`
          },
        },
        columnDefs: [
          {
            render(row) {
              return retornaBotaoOpcoes(row);
            },
            targets: [0],
          },
        ],
      });
      $("input[type='search']").focus();
      $.LoadingOverlay('hide');
    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
    }

    const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    $('#tabelaExpedidos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
    $('#tabelaExpedidos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

    $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
    $('#buttonExcel').prop('title', 'Exportar')

    $('#buttonExcel').on('click', async function () {
      const tabela = $("#tabelaExpedidos").DataTable().data().toArray();

      const dados = tabela.map((item) => ({
        'CODIGO': item[0].toString(),
        'CLIENTE': item[1].toString()
      }))

      if (dados.length > 0) {
        await exportaCSV("", "", undefined, null, 'Relatório de caixas expedidas', '', '', 999, false, false, dados);
      } else {
        msgAlerta("Não foi possível exportar, sem dados na tabela.")
      };
    })

    $('#buttonColVis').on('click', async function () {
      $.LoadingOverlay('show');
      $('#modal-ColunasVisiveis').modal('show');
      $.LoadingOverlay('hide');
    });

    $('#tabelaExpedidos').DataTable().columns().every(function () {
      if ((colunasInvisiveis.expedicao).indexOf(this.dataSrc()) != -1) {
        this.visible(false);
      }
    });
  };

  if ($.fn.DataTable.isDataTable('#tabelaExpedidos')) {
    $("#tabelaExpedidos").DataTable().columns.adjust().draw(false);
  }

  $('#tabelaExpedidos').on('click', '#btn-editar', async function () {
    const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();

    if (await validaCaixa(data[0])) {
      msgAlerta('Expedição possui reserva ou quantidade total já faturada, impossível editar.\nDeseja visualizar a caixa?', () => { window.location.href = `expedicao/${btoa([data[0], false])}` });
      return;
    } else {
      window.location.href = `expedicao/${btoa([data[0], true])}`;
    }
  });

  $("#tabelaExpedidos").on("dblclick", "tr", async function () {
    const data = $('#tabelaExpedidos').DataTable().row($(this)).data();

    if (await validaCaixa(data[0])) {
      msgAlerta('Expedição possui reserva ou quantidade total já faturada, impossível editar.\nDeseja visualizar a caixa?', () => { window.location.href = `expedicao/${btoa([data[0], false])}` });
      return;
    } else {
      window.location.href = `expedicao/${btoa([data[0], true])}`;
    }
  });

  $('#tabelaExpedidos').on('click', '#btn-excluir', async function () {

    const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();
    if (await validaCaixaFaturada(data[0])) {
      msgAlerta('Caixa já faturada, impossível excluir.');
      return;
    }

    msgAlerta('Você realmente deseja excluir essa expedição?', async () => {
      await excluiRegistro(data[0]);
    });
  });

  async function validaCaixa(sCaixa) {
    $.LoadingOverlay("show");
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: ['ID_RESERVA', 'QTDE', 'QTDE_F'],
        where: [`CAIXA = '${sCaixa}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      let total = 0;

      jsonStr.map((item) => {
        total += item.QTDE_F
      });

      // if (jsonStr[0].ID_RESERVA > 0) {
      //   return true;
      // }
      if (total > 0) {
        return true;
      }
      return false;

    } finally {
      $.LoadingOverlay("hide");
    }
  }

  async function excluiRegistro(sCaixa) {

    const response = await requisicao('DELETE', '/expedicao?', `CAIXA=${sCaixa}`);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      msgErro(jsonStr.mensagem.mensagem);
      return;
    }

    criaMensagemSucesso('Expedição excluída com sucesso.', () => { window.location.reload(); });
  };

  async function validaCaixaFaturada(sCaixa) {
    $.LoadingOverlay('show');
    try {
      const pesquisaParam = {
        tabela: 'PEDIDO3',
        camposSelect: ['QTDE_F'],
        where: [`CAIXA = '${sCaixa}'`]
      }

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
      let total = 0;

      jsonStr.map((item) => {
        total += item.QTDE_F
      });

      if (total > 0) {
        return true;
      }
      return false;
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function buscaParametros() {
    const filtros = `CAIXA=${$('#txtCaixa').val()}` +
      `&PEDIDO=${$('#txtPedido').val()}` +
      `&DATADE=${formataDataBonita($('#txtDataIni').val())}` +
      `&DATAATE=${formataDataBonita($('#txtDataFim').val())}`
    return filtros
  }

  $('#tabelaExpedidos').on('click', '#btn-imprimirIndividual', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimirexpedicaoindividual?`;

      const filtros = `CAIXA=${data[0]}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelExpedicaoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelExpedicaoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#tabelaExpedidos').on('click', '#btn-imprimirEtiqueta', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaExpedidos').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimiretiquetaexpedicao?`;

      const filtros = `CAIXA=${data[0]}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelEtiquetaExpedicao');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelEtiquetaExpedicao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  retornaHintRelatorio('btnImprimir', 'RelExpedicao')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/imprimiracessoexpedicao?`;

        const filtros = buscaParametros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelExpedicao');
        let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelExpedicao');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  })

  $('#btnConfirmarColunas').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      let novasColunas = retornaNovasColunasInvisiveis();

      if (novasColunas.includes('0')) {
        msgAlerta('A coluna "CAIXA" não pode ser ocultada.');
        novasColunas = novasColunas.filter(index => index !== '0');
      }

      localStorage.setItem(
        'colunasInvisiveisRelatorios',
        JSON.stringify({ ...colunas, expedicao: novasColunas })
      );

      const tabela = $('#tabelaExpedidos').DataTable();

      tabela.columns().visible(true);

      tabela.columns().every(function () {
        const colIndex = this.index();
        if (novasColunas.includes(String(colIndex))) {
          this.visible(false);
        }
      });

    } catch (error) {
      console.error(error);
      msgAlerta(error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });
});
