$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([
            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnIncluir',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de um preço terceiros.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para imprimir um relatório dos preços terceiros por cor e tamanho.',
                    position: 'right'
                }
            }
        ]);
        driver.start();
    });
});

const colunasTabelaProduto = [
    { data: "CODIGO", title: "Código" },
    { data: "DESCPROD", title: "Desc. Prod." },
    { data: "NUMERO", title: "Tabela" },
    { data: "PARTE", title: "Parte" },
    { data: "DESCPARTE", title: "Desc. Parte" },
    { data: "COR", title: "Cor" },
    { data: "DESCCOR", title: "Desc. Cor" },
    { data: "TAMANHO", title: "Tamanho" },
    { data: "TIPO", title: "Tipo" }
];
const colunasTabelaSetores = [
    { data: "SETOR", title: "Setor" },
    { data: "DESCRICAO", title: "Descrição" },
    { data: "CODIGO", title: "Código" },
    { data: "NUMERO", title: "Tabela" },
    { data: "COR", title: "Cor" },
    { data: "DESCCOR", title: "Desc. Cor" },
    { data: "TAMANHO", title: "Tamanho" },
    { data: "PRECOPROD", title: "Preço" },
    { data: "PARTE", title: "Parte" },
    { data: "DESCPARTE", title: "Desc. Parte" },
];

$(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("FACPRECOCORTAM");

    let tabelaProdutosColVis = false;
    let tabelaSetoresColVis = false;

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (colunas === null || colunas.facprecocoram_Produtos === undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, facprecocoram_Produtos: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    };

    if (colunas === null || colunas.facprecocoram_Setores === undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, facprecocoram_Setores: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    };

    // #region Eventos
    $("#btnFiltros").on("click", function () {
        $("#modal-filtros").modal("show");
    });

    componenteFiltro('produto', true, true);
    componenteFiltro('tabPreco', true, true);
    componenteFiltro('setor', true, true);
    componenteFiltro('cor', true, true);
    componenteFiltro('tamanho', true, true);
    componenteFiltro('parte', true, true);

    $('#btnProdutoAlt').pesquisa('#txtProdutoAlt', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "PRODUTO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Produto', 'PRODUTO');
    $('#txtProdutoAlt').autocompleta(3, montaPesquisa(2, "PRODUTO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaProdutoAlt').on("click", function () { $("#txtProdutoAlt").val("") })

    $('#btnTabPrecoAlt').pesquisa('#txtTabPrecoAlt', 'REGIAO', 'DESCRICAO', montaPesquisa(1, "REGIAO", '["REGIAO","DESCRICAO"]'), 'Pesquisa Tabela de Preço', 'REGIAO');
    $('#txtTabPrecoAlt').autocompleta(2, montaPesquisa(2, "REGIAO", '["REGIAO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaTabPrecoAlt').on("click", function () { $("#txtTabPrecoAlt").val("") })

    $('#btnSetorAlt').pesquisa('#txtSetorAlt', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "CADFLUXO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtSetorAlt').autocompleta(1, montaPesquisa(2, "CADFLUXO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaSetorAlt').on("click", function () { $("#txtSetorAlt").val("") });

    $('#btnParteAlt').pesquisa('#txtParteAlt', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "TIPO_APL", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtParteAlt').autocompleta(1, montaPesquisa(2, "TIPO_APL", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaParteAlt').on("click", function () { $("#txtParteAlt").val("") });

    $('#btnProdutoExc').pesquisa('#txtProdutoExc', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "PRODUTO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Produto', 'PRODUTO');
    $('#txtProdutoExc').autocompleta(3, montaPesquisa(2, "PRODUTO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaProdutoExc').on("click", function () { $("#txtProdutoExc").val("") })

    $('#btnTabPrecoExc').pesquisa('#txtTabPrecoExc', 'REGIAO', 'DESCRICAO', montaPesquisa(1, "REGIAO", '["REGIAO","DESCRICAO"]'), 'Pesquisa Tabela de Preço', 'REGIAO');
    $('#txtTabPrecoExc').autocompleta(2, montaPesquisa(2, "REGIAO", '["REGIAO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaTabPrecoExc').on("click", function () { $("#txtTabPrecoExc").val("") })

    $('#btnSetorExc').pesquisa('#txtSetorExc', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "CADFLUXO", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtSetorExc').autocompleta(1, montaPesquisa(2, "CADFLUXO", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaSetorExc').on("click", function () { $("#txtSetorExc").val("") });

    $('#btnParteExc').pesquisa('#txtParteExc', 'CODIGO', 'DESCRICAO', montaPesquisa(1, "TIPO_APL", '["CODIGO","DESCRICAO"]'), 'Pesquisa Setor', 'CADSETOR');
    $('#txtParteExc').autocompleta(1, montaPesquisa(2, "TIPO_APL", '["CODIGO CHAVE","DESCRICAO DESCRICAO"]'));
    $('#btnLimpaParteExc').on("click", function () { $("#txtParteExc").val("") });

    consultar();

    $("#btnLimparFiltros").on("click", function () {
        $.LoadingOverlay('show');
        try {
            $('#btnLimpaProduto').trigger('click');
            $('#btnLimpaTabPreco').trigger('click');
            $('#btnLimpaSetor').trigger('click');
            $('#btnLimpaCor').trigger('click');
            $('#btnLimpaTamanho').trigger('click');
            $('#txtParte').val('');
        } finally {
            $.LoadingOverlay('hide');
        };
    });

    $("#btnConsultar").on("click", function () {
        consultar();
    });

    retornaHintRelatorio('btnImprimir', 'RelFacPrecoCorTam')
    $("#btnImprimir").on("click", function () {
        imprimirRelatorio();
    });

    $('#btnIncluir').on('click', function () {
        $.LoadingOverlay('show');
        try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
                try {
                    window.location.href = `fac_preco_cor_tam/create`;
                } finally {
                    $.LoadingOverlay('hide');
                }
            } else {
                msgAlertaSemConfirmacao("Sem permissão para incluir!");
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#tabelaProdutos tbody').on('click', 'tr', function () {
        var data = $('#tabelaProdutos').DataTable().row(this).data();

        $('#tabelaProdutos tbody tr.selected').removeClass('selected');
        $(this).addClass('selected');

        filtraTabelaSetores(data.CODIGO, data.COR, data.TAMANHO, data.NUMERO, data.PARTE);
    });

    // #region Funções
    function montaPesquisa(tipo, tabela, campos) {
        if (tipo === 1)
            return `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"${tabela}", "camposSelect":${campos}  }`;

        if (tipo === 2)
            return `JSON={ "tabela":"${tabela}", "camposSelect":${campos} }`
    };

    async function consultar() {
        $.LoadingOverlay('show')
        try {
            const filtros = JSON.stringify(await pegaFiltros());
            const response = await requisicao('GET', '/sisplan/facprecocortam/v1/buscadados?', `JSON=${filtros}&TELA_ACESSO=S`, '', 600000);

            if (!response)
                throw new Error("Ocorreu um erro ao buscar os dados, tente novamente mais tarde.");

            const dadosProdutos = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro ao buscar os dados: " + dadosProdutos.mensagem);

            criaTabelas(dadosProdutos.RESULT, []);
        } catch (error) {
            msgAlerta(error.message);
            console.log(error);
        } finally {
            $(".modal-header > .close").trigger("click");
            $.LoadingOverlay('hide');
        };
    };


    async function imprimirRelatorio() {
        try {
            $.LoadingOverlay('show');
            const url = `/sisplan/impressao/v1/imprimirfacprecocortam`;
            const filtros = JSON.stringify(await pegaFiltros());

            const arquivo = await GeraRelatorio(`${url}?JSON=${filtros}&TELA_ACESSO=S&`, 'GET', 100000, false, 'RelFacPrecoCorTam');
            const bImprimeAutomatico = await verificaImprimirAutomatico('RelFacPrecoCorTam');
            if (arquivo !== undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                };
                await limparRelatorios();
            };
        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function pegaFiltros() {
        return {
            PRODUTO: await formataListas($("#txtProduto").val().toString()),
            TABELA: await formataListas($("#txtTabPreco").val().toString()),
            SETOR: await formataListas($("#txtSetor").val().toString()),
            COR: await formataListas($("#txtCor").val().toString()),
            TAM: await formataListas($("#txtTamanho").val().toString()),
            PARTE: await formataListas($("#txtParte").val().toString())
        };
    };

    function criaTabelas(dadosProduto, dadosSetores) {
        criaDataTableCamposNaoFixos("#tabelaProdutos", "30vh", dadosProduto, colunasTabelaProduto, [], [], [], 0, [], [], true, [["Alterar", "btnAlterar"], ["Exluir", "btnExcluir"]]);

        if ($.fn.DataTable.isDataTable('#tabelaProdutos'))
            $("#tabelaProdutos").DataTable().columns.adjust().draw(false);

        $("#buttonExcel_tabelaProdutos").on("click", async function () {
            $.LoadingOverlay('show')
            try {
                const dados = $("#tabelaProdutos").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório Produtos - FacPrecoCorTam', '', '', 999, false, false, dados);
            } catch (error) {
                console.log(error.message)
            } finally {
                $.LoadingOverlay('hide')
            };
        });
        $("#buttonColVis_tabelaProdutos").on("click", function () {
            $.LoadingOverlay('show');
            try {
                setarTabelaEdicao("#tabelaProdutos");
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide');
            };
        });

        criaDataTableCamposNaoFixos("#tabelaSetores", "18vh", dadosSetores, colunasTabelaSetores, [2, 3, 4, 5, 6], [], [7], 2, [], [], false, []);

        if ($.fn.DataTable.isDataTable('#tabelaSetores'))
            $('#tabelaSetores').DataTable().columns.adjust().draw(false);

        $("tabelaSetores_length > label").addClass("d-none");
        $("#buttonExcel_tabelaSetores").on("click", async function () {
            $.LoadingOverlay('show')
            try {
                const dados = $("#tabelaSetores").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório Setores - FacPrecoCorTam', '', '', 999, false, false, dados);
            } catch (error) {
                console.log(error.message)
            } finally {
                $.LoadingOverlay('hide')
            };
        });
        $("#buttonColVis_tabelaSetores").on("click", function () {
            $.LoadingOverlay('show');
            try {
                setarTabelaEdicao("#tabelaSetores");
                $('#modal-ColunasVisiveis').modal('show');
            } finally {
                $.LoadingOverlay('hide');
            };
        });
    };

    async function filtraTabelaSetores(codigo, cor, tam, tabela, parte) {
        $.LoadingOverlay('show');
        try {
            const json = JSON.stringify({
                PRODUTO: codigo,
                COR: cor,
                TAM: tam,
                TABELA: tabela,
                PARTE: parte
            });

            const response = await requisicao('GET', '/sisplan/facprecocortam/v1/buscasetor?', `JSON=${json}`, '', 60000);

            if (!response)
                throw new Error("Ocorreu um erro, tente novamente mais tarde.");

            const jsonStr = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro: " + jsonStr.mensagem);

            $("#tabelaSetores").DataTable().clear().rows.add(jsonStr.RESULT).draw();
        } catch (error) {
            msgAlerta(`Não foi possível buscar os setores do produto: ${error.message}`);
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    function validaDadosPreenchidos(alt) {
        $.LoadingOverlay('show');
        try {
            const comp = alt ? "Alt" : "Exc"
            if ($(`#txtProduto${comp}`).val() === "")
                throw new Error("PRODUTO");

            if ($(`#txtTabPreco${comp}`).val() === "")
                throw new Error("TABELA");

            if ($(`#txtParte${comp}`).val() === "")
                throw new Error("PARTE");

            if (alt) {
                if ($(`#txtSetor${comp}`).val() === "")
                    throw new Error("SETOR");
            } else {
                if ($(`#txtSetor${comp}`).val() === "")
                    return 'SETOR_N_PREENCHIDO';
            };

            return true;
        } catch (error) {
            msgAlerta(`Necessário informar o campo: ${error.message}`);
            return false;
        } finally {
            $.LoadingOverlay('hide');
        };
    };

    function editarPreco() {
        const params = {
            CODIGO: pegaChave("#txtProdutoAlt"),
            DESC_PROD: pegaDescricao("#txtProdutoAlt"),
            TABELA: pegaChave("#txtTabPrecoAlt"),
            DESC_TABELA: pegaDescricao("#txtTabPrecoAlt"),
            PARTE: pegaChave("#txtParteAlt"),
            DESC_PARTE: pegaDescricao("#txtParteAlt"),
            SETOR: pegaChave("#txtSetorAlt"),
            DESC_SETOR: pegaDescricao("#txtSetorAlt")
        };
        const url = `fac_preco_cor_tam/${btoa(JSON.stringify(params))}`;

        window.location.href = url;
    };

    async function excluirPreco() {
        $.LoadingOverlay('show');
        try {
            const params = JSON.stringify({
                PRODUTO: pegaChave("#txtProdutoExc"),
                TABELA: pegaChave("#txtTabPrecoExc"),
                PARTE: pegaChave("#txtParteExc"),
                SETOR: pegaChave("#txtSetorExc")
            });

            const response = await requisicao('DELETE', '/sisplan/facprecocortam/v1/deletar?', `JSON=${params}`, '', 600000);

            if (!response)
                throw new Error("Ocorreu um erro ao excluir os dados, tente novamente mais tarde.");

            const jsonStr = await response.json();

            if (response.status !== 200)
                throw new Error("Ocorreu um erro ao excluir os dados: " + jsonStr.mensagem);

            criaMensagemSucesso("Deletado com sucesso!", () => { consultar() })
        } catch (error) {
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide');
            $("#modal-filtros-excluir").modal("hide");
        };
    };

    function bloqueiaCampos(campos, value = true) {
        for (let x = 0; x < campos.length; x++) {
            $(campos[x]).prop("disabled", value);
        };
    };

    function criaDataTableCamposNaoFixos(
        sIdTabela,
        sScrollY = "30vh",
        sData,
        sColumns,
        sColunasInvisiveis = [],
        sColunasDinheiro = [],
        sColunasDecimais = [],
        casasDecimais = 0,
        sColunasCentro = [],
        sColunasDireita = [],
        sBotoesOpcoes = false,
        sBotoesOpcoesPersonalizados = []
    ) {
        criaDataTablePadrao(
            sIdTabela,
            true,
            true,
            sIdTabela === "#tabelaProdutos",
            true,
            true,
            false,
            sScrollY,
            sData,
            sColumns,
            sColunasInvisiveis,
            [],
            sColunasDinheiro,
            sColunasDecimais,
            {},
            casasDecimais,
            `buttonColVis_${sIdTabela.replace("#", "")}`,
            `buttonExcel_${sIdTabela.replace("#", "")}`,
            false,
            sColunasCentro,
            sColunasDireita,
            [],
            [],
            false,
            sBotoesOpcoes,
            sBotoesOpcoesPersonalizados
        );

        if ($.fn.DataTable.isDataTable('#tabelaProdutos'))
            $("#tabelaProdutos").DataTable().columns.adjust().draw(false);

        if ($.fn.DataTable.isDataTable('#tabelaSetores'))
            $('#tabelaSetores').DataTable().columns.adjust().draw(false);

        $("#tabelaProdutos").off("click");
        $('#tabelaProdutos').on('click', '.btnAlterar', async function (e) {
            e.preventDefault();
            const dados = $('#tabelaProdutos').DataTable().row(".selected").data();
            $("#modal-filtros-alterar").modal("show");

            insereValor("#txtProdutoAlt", dados.CODIGO, { tabela: 'PRODUTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.CODIGO });
            insereValor("#txtTabPrecoAlt", dados.NUMERO, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: dados.NUMERO });
            insereValor("#txtParteAlt", dados.PARTE, dados.DESCPARTE);
            $("#txtSetorAlt").val("");

            bloqueiaCampos(
                [
                    "#txtProdutoAlt", "#btnProdutoAlt", "#btnLimpaProdutoAlt",
                    "#txtTabPrecoAlt", "#btnTabPrecoAlt", "#btnLimpaTabPrecoAlt",
                    "#txtParteAlt", "#btnParteAlt", "#btnLimpaParteAlt"
                ]
            );
        });

        $("#btnAvancar").on("click", function () {
            if (validaDadosPreenchidos(true))
                editarPreco();
        });

        $(`.btnExcluir`).on("click", function (e) {
            e.preventDefault();
            const dados = $('#tabelaProdutos').DataTable().row(".selected").data();
            $("#modal-filtros-excluir").modal("show");

            insereValor("#txtProdutoExc", dados.CODIGO, { tabela: 'PRODUTO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: dados.CODIGO });
            insereValor("#txtTabPrecoExc", dados.NUMERO, { tabela: 'REGIAO', campoBusca: 'DESCRICAO', campoWhere: 'REGIAO', valorWhere: dados.NUMERO });
            insereValor("#txtParteExc", dados.PARTE, dados.DESCPARTE);
            $("#txtSetorExc").val("");

            bloqueiaCampos(
                [
                    "#txtProdutoExc", "#btnProdutoExc", "#btnLimpaProdutoExc",
                    "#txtTabPrecoExc", "#btnTabPrecoExc", "#btnLimpaTabPrecoExc",
                    "#txtParteExc", "#btnParteExc", "#btnLimpaParteExc"
                ]
            );
        });

        $("#btnExcluir").on("click", function () {
            msgAguardaConfirmacao(
                "Tem certeza que deseja excluir este registro?",
                () => {
                    const val = validaDadosPreenchidos(false);
                    if (val && val !== 'SETOR_N_PREENCHIDO') excluirPreco();
                    else if (val === 'SETOR_N_PREENCHIDO')
                        msgAguardaConfirmacao(
                            "SETOR não foi informado, será excluído TODOS os preços de TODOS os setores deste produto. Essa ação é irreversível, deseja realmente continuar?",
                            () => {
                                excluirPreco()
                            },
                            () => { }
                        );
                },
                () => {
                    $("#modal-filtros-excluir").modal("hide");
                }
            );
        });
    };

    function setarTabelaEdicao(tabela) {
        tabelaProdutosColVis = tabela === '#tabelaProdutos';
        tabelaSetoresColVis = tabela === '#tabelaSetores';
    };

    $('#btnConfirmarColunas').on('click', async function () {
        $.LoadingOverlay('show');
        try {
            const novasColunas = retornaNovasColunasInvisiveis();

            if (tabelaProdutosColVis) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, facprecocortam_Produtos: novasColunas }))
                $('#tabelaProdutos').DataTable().columns().visible(true);
                $('#tabelaProdutos').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        };
                    }
                );
            } else if (tabelaSetoresColVis) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, facprecocortam_Setores: novasColunas }))
                $('#tabelaSetores').DataTable().columns().visible(true);
                $('#tabelaSetores').DataTable().columns().every(
                    function () {
                        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        };
                    }
                );
            };

            tabelaProdutosColVis = false;
            tabelaSetoresColVis = false;
        } catch (error) {
            console.error(error);
            msgAlerta(error.message);
        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        };
    });

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        const tabela = tabelaProdutosColVis ? "#tabelaProdutos" : tabelaSetoresColVis ? "#tabelaSetores" : "";

        $(tabela).DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        if (tabelaProdutosColVis) {
            adicionaColunas(cols, colunasInvisiveis.facprecocortam_Produtos ?? [], ["Código"]);
        } else if (tabelaSetoresColVis) {
            let listaOcultos = ["COR", "DESCCOR", "TAM", "CODIGO", "TABELA"]
            for (let x = 0; x < listaOcultos.length; x++) {
                colunasInvisiveis.facprecocortam_Produtos.push(listaOcultos[x]);
            };
            adicionaColunas(cols, colunasInvisiveis.facprecocortam_Setores ?? [], ["Setor", "Preço"]);
        };
    });
});