<style>
  #telatour {
    padding: 0px !important;
  }

  .form-group {
    margin-bottom: 0;
  }

  .inputclass {
    height: 40px !important;
    font-size: 100%;
  }
</style>

<div id="modal-CEP" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 id="myModalLabel" class="modal-title">Cadastro de CEP</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body pb-0">

        <form id="form_CEP">
          <div class="form-card">
            <div class="card-body" id="telatour">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txt_Cep">CEP *</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control validate" required aria-describedby="cepError" id="txt_Cep" name="txt_Cep" class="form-control" placeholder="CEP">
                  </div>
                </div>
                <div class="col-lg-8  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEndereco">Endereço</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control validate" id="txtEndereco" name="txtEndereco" class="form-control" placeholder="Endereço">
                  </div>
                </div>
                <div class="col-lg-4  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtBairroCEP">Bairro</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control validate" id="txtBairroCEP" name="txtBairroCEP" class="form-control" placeholder="Bairro">
                  </div>
                </div>
                <div class="col-lg-4  col-12 form-group" id="produtotuto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtUfCEPCadastro">UF *</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" required aria-describedby="ufError" id="txtUfCEPCadastro" name="txtUfCEPCadastro" placeholder="UF" />
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnUf" name="btnUf" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAUf" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-8  col-12 form-group" id="produtotuto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCidadeCEPCadastro">Cidade *</label>
                  <div class="input-group">
                    <input type="text" readonly class="input-default focus form-control" required aria-describedby="cidadeError" id="txtCidadeCEPCadastro" name="txtCidadeCEPCadastro" class="form-control" placeholder="Cidade">
                    <div class="input-group-append">
                      <button class="btn bg-danger d-none" id="btnCidade" name="btnCidade" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger d-none" id="btnACidade" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-12 col-12 form-group" style="margin-bottom: 4px;" id="produtotuto">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPaisCEPCadastro">País *</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" required aria-describedby="paisError" id="txtPaisCEPCadastro" name="txtPaisCEPCadastro" class="form-control" placeholder="País">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnPais" name="btnPais" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAPais" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" id="btnVoltarCEP" class="inputclass btn btn-success btn-sisp btn-lg action-button-previous" data-dismiss="modal">Voltar</button>
            <input type="button" name="gravar" id="btnGravarCEP" class="inputclass btn btn-danger btn-sisp btn-lg action-button" value="Gravar">
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script src="../plugins/jquery/jquery.min.js?versao=3.261.20.1"></script>
<script>
  $(document).ready(async function() {
    $("#txt_Cep").mask("00000-000");
    $("#txtCidadeCEPCadastro").prop("disabled", true);

    $("#form_CEP").validate({
      debug: false,
      ignore: "",
      rules: {
        txt_Cep: {
          required: true,
        },
        txtCidadeCEPCadastro: {
          required: true,
        },
        txtUfCEPCadastro: {
          required: true,
        },
        txtPaisCEPCadastro: {
          required: true,
        },
      },
      messages: {
        txt_Cep: {
          required: "Informe um cep válido.",
        },
        txtCidadeCEPCadastro: {
          required: "Informe uma cidade válida.",
        },
        txtUfCEPCadastro: {
          required: "Informe um estado válido.",
        },
        txtPaisCEPCadastro: {
          required: "Informe um país válido.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $("#btnGravarCEP").click(function() {
      let validator = $("#form_CEP").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        gravarCep();
      }
    });

    $("#txt_Cep").blur(async function() {
      if ($("#txt_Cep").val() != "" && $("#txt_Cep").val().length == 9) {
        await buscaCepCad();
      } else {
        msgAlerta("Preencha um cep válido antes de continuar!");
      }
    });
    $("#btnVoltarCEP").on("click", async function() {
      if ($('#modal-CEP').attr('cepField') == 'txtCep') {
        $('#txtCep').val('');
        $('#txtCidade').val('');
        $('#txtUF').val('');
        $('#txtRua').val('');
        $('#txtBairro').val('');
      }
      if ($('#modal-CEP').attr('cepField') == 'txtCepEntrega') {
        $('#txtCepEntrega').val('');
        $('#txtCidadeEntrega').val('');
        $('#txtUFEntrega').val('');
        $('#txtRuaEntrega').val('');
        $('#txtBairroEntrega').val('');
      }
      if ($('#modal-CEP').attr('cepField') == 'txtCepCobranca') {
        $('#txtCepCobranca').val('');
        $('#txtCidadeCobranca').val('');
        $('#txtUfCobranca').val('');
        $('#txtRuaCobranca').val('');
        $('#txtBairroCobranca').val('');
      }
      $('#modal-CEP').modal('hide');
      if ($('#modal-CEP').attr('cepField') == 'Cep') {
        $('#txtCep').val('');
        $('#txtCep').focus();
      }
      if ($('#modal-CEP').attr('cepField') == 'CepEntrega') {
        $('#txtCepEntrega').val('');
        $('#txtCepEntrega').focus();
      }
      if ($('#modal-CEP').attr('cepField') == 'CepCobranca') {
        $('#txtCepCobranca').val('');
        $('#txtCepCobranca').focus();
      }
    });

    async function buscaCepCad() {
      try {
        try {
          cep = $("#txt_Cep").val().replace("-", "");

          if (!cep) {
            return;
          }

          $.LoadingOverlay("show");
          let response = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"cadcep", "camposSelect":["cep"], "where": ["cep = '${cep}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (jsonStr.RESULT[0].length > 0) {
            msgAlerta("Cep já cadastrado, inserindo no campo da entidade.");
            setTimeout(function() {
              $('#txtCep').val(cep);
              $('#txtCep').trigger('blur');
              $('#modal-CEP').modal('hide');
            }, 3000);
          } else {
            try {
              let responseStr = await requisicao("GET", "/sisplan/cep/v1/CEP?", `CEP=${cep}`, null);
              if (!responseStr) {
                return;
              }

              carregaDados(cep);
            } finally {
              $.LoadingOverlay("hide");
            }
          }
        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    async function carregaDados(ceppesquisa) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/pesquisa?",
            `JSON={ 
                        "tabela":"cadcep", 
                        "camposSelect":["cadcep.cep", "CIDADE.codigo", "tabuf.coduf", "tabuf.codigo", "CIDADE.cod_uf", "CIDADE.nome", "cadcep.nomcep", "cadcep.bairro", "cadcep.cod_pais", "tabuf.descricao"], 
                        "innerJoin": [{"tabela": "cidade", 
                        "condicao": "cidade.codigo = cadcep.codmun"}], 
                        "leftJoin": [{"tabela": "tabuf", 
                        "condicao": "tabuf.codigo = cidade.cod_uf"}],
                        "where": ["cadcep.cep = '${ceppesquisa}'"]}`,
            null
          );

          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txt_Cep").val(jsonStr.RESULT[0][0].CEP);
          $("#txtEndereco").val(jsonStr.RESULT[0][0].NOMCEP);
          $("#txtBairroCEP").val(jsonStr.RESULT[0][0].BAIRRO);

          insereValor(
            "#txtCidadeCEPCadastro",
            jsonStr.RESULT[0][0].CODIGO,
            jsonStr.RESULT[0][0].NOME
          );
          insereValor(
            "#txtUfCEPCadastro",
            jsonStr.RESULT[0][0].COD_UF,
            jsonStr.RESULT[0][0].DESCRICAO
          );

          if (jsonStr.RESULT[0][0].COD_PAIS != "") {
            try {
              let responseOperadora = await requisicao("GET", "/Sisplan/Funcoes/v1/pesquisa?", `JSON={ "tabela":"cadpais", "camposSelect":["nome"], "where": ["codigo = '${jsonStr.RESULT[0][0].COD_PAIS}'"]}`, null);

              if (!responseOperadora) {
                return;
              }
              let jsonStrOperadora = await responseOperadora.json();
              if (responseOperadora.status != 200) {
                msgErro(jsonStrClasse.RESULT[0].mensagem);
                return;
              }

              insereValor(
                "#txtPaisCEPCadastro",
                jsonStr.RESULT[0][0].COD_PAIS,
                jsonStrOperadora.RESULT[0][0].NOME
              );
            } catch (error) {
              console.error(error);
            }
          }
        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    async function gravarCep() {
      try {
        $.LoadingOverlay("show");
        let cep = {};

        cep.CEP = $("#txt_Cep").val().replace("-", "");
        cep.NOMCEP = $("#txtEndereco").val();
        cep.BAIRRO = $("#txtBairroCEP").val();
        cep.CODMUN = pegaChave($("#txtCidadeCEPCadastro").val(), cep.CODMUN);
        cep.CODIGO = pegaChave($("#txtUfCEPCadastro").val(), cep.CODIGO);
        cep.COD_PAIS = pegaChave($("#txtPaisCEPCadastro").val(), cep.COD_PAIS);

        let response = await requisicao("POST", "/sisplan/cep/v1/CEP?", `JSON=${JSON.stringify(cep)}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              $('#modal-CEP').modal('hide');
              if ($('#modal-CEP').attr('cepField') == 'txtCep') {
                $('#txtCidade').val(pegaDescricao('#txtCidadeCEPCadastro'));
                $('#txtUF').val(pegaChave('#txtUfCEPCadastro'));
                $('#txtRua').val($('#txtEndereco').val());
                $('#txtBairro').val($('#txtBairroCEP').val());
              }
              if ($('#modal-CEP').attr('cepField') == 'txtCepEntrega') {
                $('#txtCidadeEntrega').val(pegaDescricao('#txtCidadeCEPCadastro'));
                $('#txtUFEntrega').val(pegaChave('#txtUfCEPCadastro'));
                $('#txtRuaEntrega').val($('#txtEndereco').val());
                $('#txtBairroEntrega').val($('#txtBairroCEP').val());
              }
              if ($('#modal-CEP').attr('cepField') == 'txtCepCobranca') {
                $('#txtCidadeCobranca').val(pegaDescricao('#txtCidadeCEPCadastro'));
                $('#txtUFCobranca').val(pegaChave('#txtUfCEPCadastro'));
                $('#txtRuaCobranca').val($('#txtEndereco').val());
                $('#txtBairroCobranca').val($('#txtBairroCEP').val());
              }
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível gravar os dados do CEP: ${error}`);
      }
    }
  });
</script>