$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([
      {
        element: '#txtCodigo',
        popover: {
          title: 'Código',
          description: "Aqui, adicionamos o código da Medida.",
          position: 'top'
        }
      },
      {
        element: '#txtDescricao',
        popover: {
          title: 'Descricao',
          description: 'Aqui, adicionamos o descrição da Medida.',
          position: 'top'
        }
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#infoimagem",
        popover: {
          title: "Foto da Medida",
          description:
            "Ao clicar na foto, você consegue alterá-la.",
          position: "left",
        },
      },
      {
        element: '#gravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Clique aqui para gravar o cadastro da função.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  async function aplicaMascara() {
    $('.campoValor').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2
    });

    $('.campoInteger').on('input', function (e) {
      let valorAtual = $(this).val();

      let novoValor = valorAtual.replace(/\D/g, '');

      if (novoValor != valorAtual) {
        $(this).val(novoValor);
      }
    });
  }

  await aplicaMascara()

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let medidas = parametros[parametros.length - 1];
  await buscaFoto(medidas);

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('MEDIDAS', getCookie('usuario'), medidas);
    window.location.href = `${BASE_URI}/medidas`;
  });

  $('#txtCodigo').on('blur', async function () {
    if ($(this).val() != '') {
      return
    }
    $.LoadingOverlay('show')
    try {
      const newCodigo = await RetornaProximo('CODIGO', 'MEDIDAS', 'CODIGO', 5)

      $(this).val(newCodigo)
    } catch (error) {
      console.error(error)
      msgAlerta(error.message)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  if (medidas != '' && medidas != 'create') {

    if (await liberarRegistro('MEDIDAS', medidas) == false) {
      window.location.href = '../medidas';
    } else {

      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MEDIDAS", 
                    "camposSelect":["CODIGO", "DESCRICAO", "DESC_INGLES", "ORIENTACAO", "TOLERANCIA", "TIPO_ENCOLHA"], 
                    "where": ["CODIGO = '${medidas}'"]}`, null);

          if (!response) {
            return;
          }
          let jsonStrBuscaDados = await response.json();
          if (response.status != 200) {
            msgErro(jsonStrBuscaDados.RESULT[0].mensagem);
            return;
          }

          $('#txtCodigo').val(jsonStrBuscaDados.RESULT[0][0].CODIGO);
          $('#txtDescricao').val(jsonStrBuscaDados.RESULT[0][0].DESCRICAO);
          $('#txtDescCompl').val(jsonStrBuscaDados.RESULT[0][0].DESC_INGLES);
          $('#txtTolerancia').val(jsonStrBuscaDados.RESULT[0][0].TOLERANCIA);
          $('#txtOrientacao').val(jsonStrBuscaDados.RESULT[0][0].ORIENTACAO);
          $(`input[value="${jsonStrBuscaDados.RESULT[0][0].TIPO_ENCOLHA}"]`).prop('checked', true);
          $('.campoValor').each(function () {
            let valorAtual = $(this).val();
            $(this).val(valorAtual).trigger('mask');
          });

        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados da Medida: ${error}`);
        }
      } finally {
        $('#txtCodigo').attr('readonly', true);
        $.LoadingOverlay('hide');
      }
    }
  }

  $("#gravar").click(
    async function () {
      if (medidas === 'create') {
        const codigo = $('#txtCodigo').val()
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"MEDIDAS", 
                "camposSelect":["CODIGO", "DESCRICAO"], 
                "where": ["CODIGO = '${codigo}'"]}`, null);

        let jsonCodigo = await response.json();
        if (jsonCodigo.RESULT[0].length > 0) {
          msgAlerta('Código já existe. Favor verifique!');
          $.LoadingOverlay("hide");
          return;
        }
      };

      try {
        $.LoadingOverlay("show");

        const codigo = $('#txtCodigo').val()
        const descricao = $('#txtDescricao').val()

        if (codigo == '') {
          throw new Error('Código da medida não informado, impossível Continuar!')
        }

        if (descricao == '') {
          throw new Error('Descrição da medida não informado, impossível Continuar!')
        }

        try {
          let file = $('input[type=file]')[0].files[0];
          let reader = new FileReader();
          let baseString;
          reader.onloadend = function () {
            baseString = reader.result;
          };
          reader.readAsDataURL(file);

          function convertToJPEG(base64String) {
            return new Promise((resolve, reject) => {
              const img = new Image();
              img.onload = function () {
                const canvas = document.createElement('canvas');
                canvas.width = img.width;
                canvas.height = img.height;
                const ctx = canvas.getContext('2d');
                ctx.drawImage(img, 0, 0);
                const jpegDataURL = canvas.toDataURL('image/jpeg');
                resolve(jpegDataURL);
              };
              img.src = base64String;
            });
          }

          await new Promise((resolve) => setTimeout(resolve, 100));
          baseString = await convertToJPEG(baseString);

          let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
          if (!response) {
            return;
          }
          jsonGravafoto = await response.json();
          let pastaFoto = jsonGravafoto.mensagem;

          response = await requisicao(
            'POST',
            '/sisplan/funcoes/v1/FotoItem?',
            `PDIRETORIOSALVAR=${pastaFoto}&NOMEARQUIVO=medida${codigo}.${file.name.split('.').pop()}`,
            `SBASE64=${encodeURIComponent(baseString)}`
          );
        } catch (error) {
          console.error(error);
        }

        let obsMedida  = {};

        obsMedida.Codigo = codigo
        obsMedida.Descricao = descricao
        obsMedida.DescCompl = $('#txtDescCompl').val();
        obsMedida.Tolerancia = $('#txtTolerancia').val();
        obsMedida.Orientacao = $('#txtOrientacao').val();
        obsMedida.TipoEncolhimento = $('input[name="tipo"]:checked').val();

        let response = await requisicao('POST', '/Sisplan/Cadastros/v1/cadmedidas?', `JSON=${encodeURIComponent(JSON.stringify(obsMedida))}`, null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        };

        let jsonStrGravar = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStrGravar.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr.success(
          `Cadastro efetuado com sucesso!`,
          'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/medidas`;
          }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });

      } catch (error) {
        console.error(error);
        msgAlerta(error.message)
        $.LoadingOverlay("hide");
      }
    });

  $('#fileimagem').change(async function () {
    try {
      $.LoadingOverlay("show");
      const leitorDeArquivos = new FileReader();
      const previaDaImagem = document.querySelector('.imagem');
      const inputArquivo = document.querySelector('.upload');

      let imagemEnviada = inputArquivo.files[0];
      let extencao = imagemEnviada.name.match(/\.([^\.]+)$/)[1]
      if (['jpg', 'png'].indexOf(extencao) == -1) {
        msgAlerta('Impossivel adicionar arquivos diferentes de .JPG e .PNG')
        return
      }
      leitorDeArquivos.readAsDataURL(imagemEnviada);
      leitorDeArquivos.addEventListener('loadend', function (load) {
        previaDaImagem.src = load.target.result;
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaFoto(codigo) {
    try {
      let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
      let response = await requisicao('GET', urlRequisicao, `codigo=medida${codigo}`, null);

      if (!response) {
        return;
      }
      let jsonStrBuscaFoto = await response.json();
      if (response.status !== 200) {
        $("#infoimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      let sBase64 = jsonStrBuscaFoto.mensagem;

      let extension = "png";
      let contentType = response.headers.get('content-type');
      if (contentType && contentType.indexOf('image/') === 0) {
        extension = contentType.replace('image/', '');
      }

      if (extension === "png") {
        $("#infoimagem").attr('src', `data:image/png;base64,${sBase64}`);
      } else {
        let jpegBase64 = await convertToJPEG(sBase64);
        $("#infoimagem").attr('src', `data:image/jpg;base64,${jpegBase64}`);
      }

    } catch (error) {
      console.error(error);
      $("#infoimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  }

});
