$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    $('#avancar1').trigger('click');
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'bandeiras') {
                    $('#voltar').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro geral.',
                position: 'top'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#bandeiras',
            popover: {
                title: 'Bandeiras',
                description: 'Aqui ficarão os dados das bandeiras cadastradas..',
                position: 'top'
            }
        },
        {
            element: '#btnIncluir',
            popover: {
                title: 'Botão Incluir',
                description: 'Clique aqui para adicionar uma bandeira.',
                position: 'left'
            }
        },
        {
            element: '#voltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Clique aqui para voltar para a aba anterior.',
                position: 'left'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a operadora.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    $('#txtTaxaOp').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtTaxaBand').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#inputTaxa').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let operadora = parametros[parametros.length - 1];
    let dadosArray;
    let contaFs = 1;

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('OPERADORATEF', getCookie('usuario'), operadora);
        window.location.href = `${BASE_URI}/operadoratef`;
    });

    $(document).ready(function () {

        $(".next").click(function () {

            contaFs += 1;

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                currentFs = $(this).parent();
                nextFs = $(this).parent().next();

                $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

                nextFs.show();
                currentFs.animate({
                    opacity: 0
                }, {
                    step(now) {
                        opacity = 1 - now;

                        currentFs.css({
                            'display': 'none',
                            'position': 'relative'
                        });
                        nextFs.css({
                            'opacity': opacity
                        });
                    },
                    duration: 600
                });
            }
        });

        $(".previous").click(function () {

            contaFs -= 1;

            currentFs = $(this).parent();
            previousFs = $(this).parent().prev();
            $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
            previousFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;
                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    previousFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        });

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                },
                txtCpf: {
                    required: true,
                },
                txtDiaPagto: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDesc: {
                    required: "Informe um nome válido."
                },
                txtCpf: {
                    required: "Informe um CPF/CNPJ válido."
                },
                txtDiaPagto: {
                    required: "Informe um dia de pagamento válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#account').on('click', function () {
        if (operadora != 'create') {
            if (contaFs == 2) {
                $('#voltar').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (operadora != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
        }
    });

    $('#tabela-parcelas').DataTable({
        paging: false,
        autoWidth: true,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
    });

    $('#tabela-bandeiras').DataTable({
        paging: false,
        autoWidth: true,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
    });

    $('#txtEmpAdmin').autocompleta(4, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#btnEmpAdmin').pesquisa('#txtEmpAdmin', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI", "NOME"]}`, 'Pesquisa Entidade', 'ENTIDADE');
    $('#btnAEmpAdmin').on('click', function () {
        $('#txtEmpAdmin').val('');
    });

    $('#txtClasseGer').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btnClasseGer').pesquisa('#txtClasseGer', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe', 'CLASSE_GER');
    $('#btnAClasseGer').on('click', function () {
        $('#txtClasseGer').val('');
    });

    async function RetornaBandeiras() {
        var _url = `/Sisplan/Funcoes/v1/pesquisa?`;
        var _params = `JSON={ "tabela":"BANDEIRA", "camposSelect":["ID", "DESCRICAO"], "where": ["ATIVO = 'S'"], "orderby": ["ORDEM","DESCRICAO"]}`;

        try {
            var response = await requisicao('GET', _url, _params, null);

            if (!response) {
                return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr['RESULT'][0].mensagem)
                return;
            }
            return jsonStr['RESULT'][0];
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as bandeiras');
        }
    }

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '     <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
            '     <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    async function addBandeira() {
        var dados = await RetornaBandeiras();
        for (const bandeira of dados) {
            var optionText = bandeira.DESCRICAO;
            var optionValue = bandeira.DESCRICAO;
            $('#select_bandeira').append(`<option value="${optionValue}">${optionText}</option>`);
        }
    }

    addBandeira();

    if (operadora != '' && operadora != 'create') {
        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        if (await liberarRegistro('OPERADORATEF', operadora) == false) {
            window.location.href = '../operadoratef';
        } else {
            try {
                $.LoadingOverlay("show");
                try {
                    const empId = getCookie('emp_id');

                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"TEF_OPERADORA", 
                                                                                                    "camposSelect":["CLASSE_GER", "ID", "EMP_ID", "TAXA", "OPERADORA", "ID_ENT", "MAQUINETA", "CAMPO_NSU", "PARCELA_ARREDON", "CAMPO_BANDEIRA"], 
                                                                                                    "where": ["ID = '${operadora}'"]}`, null);

                    let json = await response.json();

                    if (json.RESULT[0][0].ID_ENT != 0) {
                        const idEntidade = json.RESULT[0][0].ID_ENT;

                        let responseEntidade = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":["ID", "CODCLI", "NOME"], 
                        "where": ["ID = '${idEntidade}'"]}`, null);

                        let jsonEntidade = await responseEntidade.json();

                        insereValor('#txtEmpAdmin', jsonEntidade.RESULT[0][0].CODCLI, jsonEntidade.RESULT[0][0].NOME);
                    }

                    if (json.RESULT[0][0].CLASSE_GER != '') {
                        const classe = json.RESULT[0][0].CLASSE_GER;

                        let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"CLASSE_GER", "camposSelect":["DESCRICAO"], 
                        "where": ["CODIGO = '${classe}'"]}`, null);

                        let jsonClasse = await responseClasse.json();

                        insereValor('#txtClasseGer', json.RESULT[0][0].CLASSE_GER, jsonClasse.RESULT[0][0].DESCRICAO);
                    }

                    $('#txtOperadora').val(json.RESULT[0][0].OPERADORA);
                    $('#txtTaxaOp').val(json.RESULT[0][0].TAXA);
                    $('#txtMaquineta').val(json.RESULT[0][0].MAQUINETA);
                    $('#txtCampoNsu').val(json.RESULT[0][0].CAMPO_NSU);
                    $('#selectParcelaArredondamento').val(json.RESULT[0][0].PARCELA_ARREDON);
                    $("#txtCampoBandeira").val(json.RESULT[0][0].CAMPO_BANDEIRA);

                    let responseBandeira = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ "tabela":"TEF_BANDEIRA", "camposSelect":["BANDEIRA", "EMP_ID", "TAXA", "ID", "ID_OPERADORA"], 
                    "where": ["ID_OPERADORA = '${operadora}'"]}`, null);

                    let jsonBandeira = await responseBandeira.json();

                    let jsonBandeiraFormatado = jsonBandeira.RESULT[0]
                    const bandeiras = [];

                    for (let i = 0; i < jsonBandeiraFormatado.length; i++) {
                        const dados = jsonBandeiraFormatado[i];
                        $('#tabela-bandeiras').DataTable().row.add([dados.ID, dados.BANDEIRA, dados.TAXA, retornaBotaoOpcoes()]).draw(false);
                        let cadaBandeira = {}
                        cadaBandeira.ID = dados.ID;
                        cadaBandeira.BANDEIRA = dados.BANDEIRA;
                        cadaBandeira.TAXA = dados.TAXA;
                        cadaBandeira.EMP_ID = empId;
                        cadaBandeira.ID_OPERADORA = operadora == '' ? '' : operadora;
                        bandeiras.push(cadaBandeira);
                    }

                    for (let i = 0; i < bandeiras.length; i++) {
                        const parcelas = [];
                        const dadosBandeira = bandeiras[i];
                        const responseParcelas = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"TEF_PARCELAS", "camposSelect":[ "ID_OPERADORA", "PARCELA", "PRAZO", "TAXA", "EMP_ID", "ID_BANDEIRA"],  "where": ["ID_BANDEIRA = '${dadosBandeira.ID}' AND EMP_ID = '${empId}' AND ID_OPERADORA = '${operadora}'"], "orderby": ["PARCELA"]}`, null);

                        if (!responseParcelas) {
                            return;
                        }

                        let jsonParcelas = await responseParcelas.json();
                        if (responseParcelas.status != 200) {
                            msgErro(jsonParcelas.RESULT[0].mensagem);
                            return;
                        }

                        const jsonFormatado = jsonParcelas.RESULT[0];

                        for (let i = 0; i < jsonFormatado.length; i++) {
                            const dados2 = jsonFormatado[i];
                            let cadaParcela = {}
                            cadaParcela.PARCELA = dados2.PARCELA;
                            cadaParcela.PRAZO = dados2.PRAZO;
                            cadaParcela.TAXA = dados2.TAXA;
                            cadaParcela.ID_OPERADORA = operadora == '' ? '' : operadora;
                            cadaParcela.ID_BANDEIRA = dadosBandeira.ID;
                            cadaParcela.EMP_ID = empId;
                            parcelas.push(cadaParcela);
                        }
                        bandeiras[i].PARCELAS = parcelas;
                    }
                    dadosArray = bandeiras;

                } catch (error) {
                    msgErro('Não foi possível carregar os dados da operadora.');
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('#tabela-bandeiras').on('click', '#btn-excluir', async function () {
        msgAlerta('Você realmente deseja excluir esse registro?', async () => {
            const data = $("#tabela-bandeiras").DataTable().row($(this).parents("tr"));
            let valorLinha = data.data();
            let params = {}
            params.ID = valorLinha[0];
            params.ID_BANDEIRA = valorLinha[0];
            params.EMP_ID = getCookie('emp_id');
            params.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);
            if (params.ID != '') {
                const excluiuRegistro = await deletarBandeiraEParcela(params);
                if (excluiuRegistro) {
                    toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                        toastClass: "success",
                        iconClasses: {
                            error: "alert-error",
                            info: "alert-info",
                            success: "alert-success",
                            warning: "alert-warning",
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            data.remove().draw(false);
                        },
                    }).css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
                }
            } else {
                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            }
            for (let i = 0; i < dadosArray.length; i++) {
                const dados = dadosArray[i];
                const saoIguais = (dados.ID == valorLinha[0] && dados.BANDEIRA == valorLinha[1] && dados.TAXA == valorLinha[2]);
                const posicao = i;
                if (saoIguais) {
                    dadosArray.splice(posicao, 1);
                }
            }
        });
    });

    async function deletarBandeiraEParcela(params) {
        try {
            $.LoadingOverlay("show");
            try {
                const url = `/sisplan/operadoratef/v1/bandeiraparcela?`;
                let response = await requisicao('DELETE', url, `JSON=${(JSON.stringify(params))}`);

                if (!response) {
                    return false;
                }

                if (response.status != 200) {
                    msgErro(json.RESULT[0].mensagem);
                    return false;
                }

                return true;

            } catch (error) {
                msgErro('Erro ao excluir os dados.');
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#tabela-bandeiras').on('dblclick', 'tr', async function () {
        const data = $('#tabela-bandeiras').DataTable().row($(this)).data();
        $('#modal-bandeira').modal('show');

        $('#select_bandeira').val(data[1]);
        $('#txtTaxaBand').val(data[2]);
        $('#ultimoId').val(data[0]);
        $('#ultimaTaxa').val(data[2]);
        $('#ultimaBandeira').val(data[1]);
        const id = $('#ultimoId').val();
        const ultimaBandeira = $('#ultimaBandeira').val();
        const ultimaTaxa = parseFloat($('#ultimaTaxa').val());

        for (let i = 0; i < dadosArray.length; i++) {
            const dados = dadosArray[i];
            const saoIguais = (dados.ID == id && dados.BANDEIRA == ultimaBandeira && dados.TAXA == ultimaTaxa)
            if (saoIguais) {
                const dadosParcelas = dadosArray[i].PARCELAS;
                for (let i = 0; i < dadosParcelas.length; i++) {
                    const dados2 = dadosParcelas[i]
                    $('#tabela-parcelas').DataTable().row.add([dados2.PARCELA, dados2.PRAZO, `<input class="input-default inputTaxa txtTaxaParcela_${dados2.PARCELA} focus" style="width:150px;" type="number" value="${dados2.TAXA}" min="0"/>`]).draw(false);

                }
                return;
            }
        }
    });

    $('#tabela-bandeiras').on('click', '#btn-editar', async function () {
        const data = $('#tabela-bandeiras').DataTable().row($(this).parents('tr')).data();
        $('#modal-bandeira').modal('show');

        $('#select_bandeira').val(data[1]);
        $('#txtTaxaBand').val(data[2]);
        $('#ultimoId').val(data[0]);
        $('#ultimaTaxa').val(data[2]);
        $('#ultimaBandeira').val(data[1]);
        const id = $('#ultimoId').val();
        const ultimaBandeira = $('#ultimaBandeira').val();
        const ultimaTaxa = parseFloat($('#ultimaTaxa').val());

        for (let i = 0; i < dadosArray.length; i++) {
            const dados = dadosArray[i];
            const saoIguais = (dados.ID == id && dados.BANDEIRA == ultimaBandeira && dados.TAXA == ultimaTaxa)
            if (saoIguais) {
                const dadosParcelas = dadosArray[i].PARCELAS;
                for (let i = 0; i < dadosParcelas.length; i++) {
                    const dados2 = dadosParcelas[i]
                    $('#tabela-parcelas').DataTable().row.add([dados2.PARCELA, dados2.PRAZO, `<input class="input-default inputTaxa txtTaxaParcela_${dados2.PARCELA} focus" style="width:150px;" type="number" value="${dados2.TAXA}" min="0"/>`]).draw(false);

                }
                return;
            }
        }
    });

    $('#modal-bandeira').on('shown.bs.modal', function () {
        $('#select_bandeira').val('');
        $('#txtTaxaBand').val('');
        $('#tabela-parcelas').DataTable().clear().draw(false);
    });

    async function retornaQtdeParcelas() {
        try {
            $.LoadingOverlay("show");
            try {
                const responseParcelas = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"COND_ITEM", "camposSelect":[ "COND_ITEM.PARCELA", "COND_ITEM.PRAZO"],  "where": ["COND_ITEM.CODCOND IN (SELECT MAX(CONDICAO.CODCOND) FROM CONDICAO_001 CONDICAO WHERE CONDICAO.NRPAR = (SELECT MAX(NRPAR) NRPAR FROM CONDICAO_001))"]}`, null);

                if (!responseParcelas) {
                    return;
                }

                let jsonParcelas = await responseParcelas.json();
                if (responseParcelas.status != 200) {
                    msgErro(jsonParcelas.RESULT[0].mensagem);
                    return;
                }

                const jsonFormatado = jsonParcelas.RESULT[0];

                for (let i = 0; i < jsonFormatado.length; i++) {
                    const dados = jsonFormatado[i];
                    $('#tabela-parcelas').DataTable().row.add([dados.PARCELA, dados.PRAZO, `<input class="input-default inputTaxa txtTaxaParcela_${dados.PARCELA} focus" style="width:150px;" type="number" min="0"/>`]).draw(false);
                }
            } catch (error) {
                msgErro('Erro ao retornar parcelas.');
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $("#btnIncluir").on("click", async function () {
        $('#ultimoId').val('');
        $('#ultimaTaxa').val('');
        $('#ultimaBandeira').val('');
        $('#modal-bandeira').modal('show');
        await retornaQtdeParcelas();
    });

    $("#btnConfirmar").on("click", async function () {
        $('#modal-bandeira').modal('hide');
        try {
            const ultimoId = $('#ultimoId').val();
            const ultimaBandeira = $('#ultimaBandeira').val();
            const ultimaTaxa = parseFloat($('#ultimaTaxa').val());
            const bandeira = $('#select_bandeira').val();
            const taxa = $('#txtTaxaBand').val() == '' ? 0 : parseFloat($('#txtTaxaBand').val());

            for (let x = 0; x < $('#tabela-bandeiras').DataTable().rows().data().length; x++) {
                const dados = $('#tabela-bandeiras').DataTable().rows().data()[x];
                const idBandeira = dados[0];
                const idsIguais = (idBandeira == ultimoId && ultimaBandeira == dados[1] && ultimaTaxa == dados[2])
                if (idsIguais) {
                    $('#tabela-bandeiras').DataTable().row(x).data([idBandeira, bandeira, taxa, retornaBotaoOpcoes()]);
                    await montaJsonBandeiras(bandeira, taxa, ultimoId);
                    return;
                }
            }
            $('#tabela-bandeiras').DataTable().row.add(['', bandeira, taxa, retornaBotaoOpcoes()]).draw(false);
            await montaJsonBandeiras(bandeira, taxa, ultimoId);

        } catch (error) {
            msgErro('Erro ao incluir/editar bandeira.');
        }
    });

    async function montaJsonBandeiras(nomeBandeira, taxa, id) {
        const varQueContemBandeiras = dadosArray;
        const ultimaBandeira = $('#ultimaBandeira').val();
        const ultimaTaxa = parseFloat($('#ultimaTaxa').val());
        const bandeiras = [];
        const parcelas = [];
        let cadaBandeira = {};

        if (varQueContemBandeiras == undefined) {
            cadaBandeira.ID = id;
            cadaBandeira.BANDEIRA = nomeBandeira;
            cadaBandeira.TAXA = taxa == '' ? 0 : taxa;
            cadaBandeira.EMP_ID = getCookie('emp_id');
            cadaBandeira.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);
            for (let i = 0; i < $('#tabela-parcelas').DataTable().rows().count(); i++) {
                const dados = $('#tabela-parcelas').DataTable().row(i).data();
                let cadaParcela = {}
                const parcela = dados[0];
                const taxaParcela = $('.txtTaxaParcela_' + parcela).val();
                cadaParcela.PARCELA = parcela
                cadaParcela.PRAZO = dados[1];
                cadaParcela.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);
                cadaParcela.ID_BANDEIRA = cadaBandeira.ID;
                cadaParcela.TAXA = taxaParcela == '' ? 0 : taxaParcela
                cadaParcela.EMP_ID = getCookie('emp_id');
                parcelas.push(cadaParcela);
            }
            cadaBandeira.PARCELAS = parcelas;
            bandeiras.push(cadaBandeira);
            dadosArray = bandeiras;
        } else {
            for (let i = 0; i < dadosArray.length; i++) {
                const dados = dadosArray[i];
                const saoIguais = (dados.ID == id && ultimaBandeira == dados.BANDEIRA && ultimaTaxa == dados.TAXA)
                if (saoIguais) {
                    dados.BANDEIRA = nomeBandeira
                    dados.TAXA = taxa == '' ? 0 : taxa;
                    const parcelas = []
                    for (let i = 0; i < $('#tabela-parcelas').DataTable().rows().count(); i++) {
                        const dados2 = $('#tabela-parcelas').DataTable().row(i).data();
                        const parcela = dados2[0];
                        const taxaParcela = $('.txtTaxaParcela_' + parcela).val();
                        let cadaParcela = {}
                        cadaParcela.PARCELA = parcela
                        cadaParcela.PRAZO = dados2[1];
                        cadaParcela.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);
                        cadaParcela.ID_BANDEIRA = dados.ID;
                        cadaParcela.TAXA = taxaParcela == '' ? 0 : taxaParcela
                        cadaParcela.EMP_ID = getCookie('emp_id');
                        parcelas.push(cadaParcela);
                    }
                    dados.PARCELAS = parcelas
                    $('#ultimoId').val('');
                    $('#ultimaTaxa').val('');
                    $('#ultimaBandeira').val('');
                    return;
                }
            }
            cadaBandeira.ID = id;
            cadaBandeira.BANDEIRA = nomeBandeira;
            cadaBandeira.TAXA = taxa == '' ? 0 : taxa;
            cadaBandeira.EMP_ID = getCookie('emp_id');
            cadaBandeira.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);

            for (let i = 0; i < $('#tabela-parcelas').DataTable().rows().count(); i++) {
                const dados = $('#tabela-parcelas').DataTable().row(i).data();
                let cadaParcela = {}
                const parcela = dados[0];
                const taxaParcela = $('.txtTaxaParcela_' + parcela).val();
                cadaParcela.PARCELA = parcela
                cadaParcela.PRAZO = dados[1];
                cadaParcela.ID_OPERADORA = ((operadora == 'create' || operadora == '') ? '' : operadora);
                cadaParcela.ID_BANDEIRA = id;
                cadaParcela.TAXA = taxaParcela == '' ? 0 : taxaParcela
                cadaParcela.EMP_ID = getCookie('emp_id');
                parcelas.push(cadaParcela);
            }
            cadaBandeira.PARCELAS = parcelas;
            dadosArray.push(cadaBandeira);
        }
        $('#ultimoId').val('');
        $('#ultimaTaxa').val('');
        $('#ultimaBandeira').val('');
    }

    $("#btnGravar").on("click", async function () {
        try {
            $.LoadingOverlay("show");
            try {
                const codOperadora = $('#txtOperadora').val().toUpperCase();
                const taxaOp = $('#txtTaxaOp').val() == '' ? 0 : parseFloat($('#txtTaxaOp').val());
                const empAdmin = pegaChave('#txtEmpAdmin') != '' ? pegaChave('#txtEmpAdmin') : '';
                const codClasse = pegaChave('#txtClasseGer');
                let dadosOperadora = {};

                if (empAdmin != '') {
                    const responseIdEntidade = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "ID"],  "where": ["CODCLI = '${empAdmin}'"]}`, null);

                    if (!responseIdEntidade) {
                        return;
                    }

                    let jsonIdEntidade = await responseIdEntidade.json();
                    if (responseIdEntidade.status != 200) {
                        msgErro(jsonIdEntidade.RESULT[0].mensagem);
                        return;
                    }
                    dadosOperadora.ID_ENT = jsonIdEntidade.RESULT[0][0].ID;
                } else {
                    dadosOperadora.ID_ENT = ''
                }

                if (dadosArray != undefined) {
                    dadosOperadora.BANDEIRAS = dadosArray;
                }

                dadosOperadora.EMP_ID = getCookie('emp_id');
                dadosOperadora.OPERADORA = codOperadora;
                dadosOperadora.TAXA = taxaOp;
                dadosOperadora.ID = ((operadora == 'create' || operadora == '') ? '' : operadora);
                dadosOperadora.CLASSE_GER = codClasse;
                dadosOperadora.MAQUINETA = pegaValor('#txtMaquineta');
                dadosOperadora.CAMPO_NSU = pegaValor('#txtCampoNsu');
                dadosOperadora.PARCELA_ARREDON = $("#selectParcelaArredondamento").val();
                dadosOperadora.CAMPO_BANDEIRA = $("#txtCampoBandeira").val();

                const url = `/sisplan/operadoratef/v1/operadoratef?`;

                let response = await requisicao('POST', url, '', `JSON=${(JSON.stringify(dadosOperadora))}`);

                if (!response) {
                    return;
                }

                let json = await response.json();
                if (response.status != 200) {
                    msgErro(json.RESULT[0].mensagem);
                    return;
                }
                toastr.success(
                    'Cadastro efetuado com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/operadoratef`;
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            } catch (error) {
                msgErro('Erro ao gravar os dados.');
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    $('#btnTutorialTaxas').on('click', function () {
        msgAlerta('     O cadastro das taxas na tela Informações do TEF funciona com base no nível de cadastro, no caso a primeira taxa considerada é a Taxa da Operadora (localizada nos Dados Gerais na primeira aba da tela) agora caso seja informado a Taxa da Bandeira (localizada ao clicar em incluir ou editar uma bandeira informada) ela será considerada no lugar da Taxa da Operadora e caso seja informado alguma taxa para a parcela, ela será considerada no lugar das outras taxas, ou seja, a tela trabalha levando em consideração sempre o nível mais baixo do cadastro, iniciando na Taxa da Operadora (nível mais alto) indo até a Taxa da Parcela (nível mais baixo).' + "\n" +
            '       Observação: Caso seja necessário utilizar a Taxa da Bandeira ao invés da Taxa da Parcela, no cadastro de condição de pagamento, existe um flag, que se for marcado, para aquela condição, ele considera somente até o nível da Taxa da Bandeira, sendo assim, ignorando caso tenha Taxa da Parcela informado.');
    });

});