$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    })
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para incluir um novo perfil.",
          position: "right",
        },
      },
      {
        element: "#tabelaItens",
        popover: {
          title: "Tabela de Perfis",
          description: "Aqui está a lista de perfis cadastrados.",
          position: "top",
        },
      },
    ])
    driver.start()
  })
})

$(document).ready(async function () {
  componenteFiltro('centroCusto', false, false)
  componenteFiltro('tipo', false, false)
  componenteFiltro('grupoMA', false, false, 'GrupoMaterial')
  componenteFiltro('grupoPA', false, false, 'GrupoProduto')
  componenteFiltro('grupoMA', false, false, 'GrupoServico')
  componenteFiltro('subGrupo', false, false, 'SubgrupoMaterial')
  preencherFiltrosSalvos()

  const permissaoUsuarioLogado = await permissaoAcessos('PERFIL_COMPRAS')

  $('#btnFiltros').on('click', function () {
    $('#modalFiltros').modal('show')
  })

  $('#btnConsultar').on('click', () => {
    consultar()
    $('#modalFiltros').modal('hide')
  })

  async function retornarFiltros() {
    const etapa = $('#selectEtapa').val()
    const centroCusto = pegaChave('#txtCentroCusto')
    const tipo = pegaChave('#txtTipo')
    const grupoMaterial = pegaChave('#txtGrupoMaterial')
    const grupoProduto = pegaChave('#txtGrupoProduto')
    const grupoServico = pegaChave('#txtGrupoServico')
    const subgrupoMaterial = pegaChave('#txtSubgrupoMaterial')

    return {
      etapa,
      centroCusto,
      tipo,
      grupoMaterial,
      grupoProduto,
      grupoServico,
      subgrupoMaterial,
    }
  }

  function retornarBotaoOpcoes(data) {
    const retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" id="tutorialTabela" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btnEditar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btnExcluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Duplicar" id="btnDuplicar">Duplicar</button>     ' +
      '</div>'
    return retorno
  }

  async function consultar() {
    const filtros = await retornarFiltros()
    atualizarFiltrosAbasAcessoSessionStorage('perfil_compras', filtros)
    retornarDados({ filtros })
  }

  async function retornarDados({ filtros }) {
    if ($.fn.DataTable.isDataTable('#tabelaItens')) {
      $('#tabelaItens').DataTable().destroy()
      $('#tabelaItens').empty()
    }

    const columns = [
      {
        data: 'id',
        title: 'Id',
        render: function (data) {
          return retornarBotaoOpcoes(data)
        },
      },
      {
        data: 'nomeUsuario',
        title: 'Nome Usuário',
      },
      {
        data: 'etapa',
        title: 'Etapa',
        render: function (data) {
          return retornarDescricaoEtapa(data)
        }
      },
    ]

    $('#tabelaItens').DataTable({
      sort: false,
      paging: true,
      destroy: true,
      lengthChange: false,
      filter: false,
      info: false,
      ordering: false,
      sorting: false,
      order: false,
      pageLength: 15,
      serverSide: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/perfil_compras/v1/retornardadosacesso`,
        type: "POST",
        headers: {
          'Authorization': getCookie('accessToken') ? 'Bearer ' + getCookie('accessToken') : '',
        },
        data: function (data) {
          const { start, length, draw } = data;
          return JSON.stringify({
            filtros,
            paginacao: {
              quantidadeMaximaRegistros: length,
              quantidadeRegistrosPular: start,
              contadorRequisicoes: draw,
            },
            empresa: getCookie('empresa')
          })
        },
        cache: true,
        beforeSend: function () {
          $.LoadingOverlay('show')
        },
        complete: function () {
          $.LoadingOverlay('hide')
        },
        dataSrc: function (json) {
          if (!json || !json.data) {
            return []
          }
          return json.data
        }
      },
      autoWidth: true,
      columns,
      scrollX: true,
      scrollY: '50vh',
    })
  }

  function preencherFiltrosSalvos() {
    const filtrosSessionStorage = sessionStorage.getItem('filtrosConsultasAbasAcesso')
    if (!filtrosSessionStorage) {
      consultar()
      return
    }
    if (filtrosSessionStorage) {
      const { perfil_compras: filtros } = JSON.parse(filtrosSessionStorage)
      if (!filtros) {
        consultar()
        return
      }
      const { etapa, ...filtrosRetornarDescricoes } = filtros
      carregarFiltrosSalvos(filtrosRetornarDescricoes).then(({ centroCusto, tipo, grupoMaterial, grupoProduto, grupoServico, subgrupoMaterial }) => {
        setTimeout(() => {
          if (centroCusto) insereValor('#txtCentroCusto', centroCusto.codigo, centroCusto.descricao)
          if (tipo) insereValor('#txtTipo', tipo.codigo, tipo.descricao)
          if (grupoMaterial) insereValor('#txtGrupoMaterial', grupoMaterial.codigo, grupoMaterial.descricao)
          if (grupoProduto) insereValor('#txtGrupoMaterial', grupoMaterial.codigo, grupoMaterial.descricao)
          if (grupoServico) insereValor('#txtGrupoServico', grupoServico.codigo, grupoServico.descricao)
          if (subgrupoMaterial) insereValor('#txtSubgrupoMaterial', subgrupoMaterial.codigo, subgrupoMaterial.descricao)
          if (filtros.etapa) $('#selectEtapa').val(filtros.etapa)
        }, 150)
        retornarDados({ filtros })
      }).catch(
        () => msgErro('Ocorreu um erro ao preencher os filtros salvos.')
      ).finally(() => { })
    }
  }

  async function carregarFiltrosSalvos(filtros) {
    const response = await requisicao("POST", `/sisplan/perfil_compras/v1/retornardadosinputsfiltrosacesso?`, '', JSON.stringify(filtros), 3600000)
    const json = await response.json()

    if (json) {
      const { resultado, mensagem } = json
      if (mensagem?.codigo !== 200) {
        throw mensagem?.mensagem
      }

      return resultado
    }
  }

  $('#btnLimparFiltros').on('click', function () {
    $('#txtCentroCusto').val('')
    $('#txtTipo').val('')
    $('#txtGrupoMaterial').val('')
    $('#txtGrupoProduto').val('')
    $('#txtGrupoServico').val('')
    $('#txtSubgrupoMaterial').val('')
    $('#selectEtapa').val('')
  })

  $('#tabelaItens').on('click', '#btnEditar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data && data?.id) {
        const registroLiberado = await verificarRegistro('PERFIL_COMPRAS', data?.id)
        if (registroLiberado) {
          const chaveUrl = encodeURIComponent(JSON.stringify({
            id: data?.id,
            duplicar: false,
          }))
          window.location.href = `perfil_compras/CHAVE=${chaveUrl}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaItens').DataTable().row($(this)).data()
      if (data && data?.id) {
        const registroLiberado = await verificarRegistro('PERFIL_COMPRAS', data?.id)
        if (registroLiberado) {
          const chaveUrl = encodeURIComponent(JSON.stringify({
            id: data?.id,
            duplicar: false,
          }))
          window.location.href = `perfil_compras/CHAVE=${chaveUrl}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!")
    }
  })

  $('#tabelaItens').on('click', '#btnExcluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      const row = $('#tabelaItens').DataTable().row($(this).parents('tr'))
      const data = row.data()
      if (data && data.id) {
        const id = data.id
        if (!id) return
        const registroLiberado = await verificarRegistro('PERFIL_COMPRAS', id)
        if (registroLiberado) {
          msgAlerta(
            'Deseja realmente excluir o perfil selecionado?',
            () => { },
            () => { },
            () => excluir(id),
          )
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!")
    }
  })

  $('#tabelaItens').on('click', '#btnDuplicar', async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const data = $('#tabelaItens').DataTable().row($(this).parents('tr')).data()
      if (data && data?.id) {
        const registroLiberado = await verificarRegistro('PERFIL_COMPRAS', data?.id)
        if (registroLiberado) {
          const chaveUrl = encodeURIComponent(JSON.stringify({
            id: data?.id,
            duplicar: true,
          }))
          window.location.href = `perfil_compras/CHAVE=${chaveUrl}`
        }
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para duplicar!")
    }
  })

  async function excluir(id) {
    if (!id) return
    $.LoadingOverlay('show')
    requisicao('DELETE', `/sisplan/perfil_compras/v1/excluir?`, `&ID=${id}`, '', 3600000)
      .then(async (response) => {
        if (response.status !== 204) {
          const json = await response.json()
          throw json?.mensagem?.mensagem
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 1000,
          fadeOut: 1000,
          onHidden() {
            consultar()
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        })
      }).catch((error) => {
        console.error(error)
        msgErro(error || 'Ocorreu um erro ao realizar a exclusão.')
      }
      ).finally(() => $.LoadingOverlay('hide'))
  }

  function retornarDescricaoEtapa(etapa) {
    switch (etapa) {
      case 'SOL':
        return 'Solicitações'
      case 'COT':
        return 'Cotações'
      case 'COM':
        return 'Compras'
      default:
        return ''
    }
  }

  $('#btnIncluir').on('click', () => {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const chaveUrl = encodeURIComponent(JSON.stringify({
        id: 'create',
        duplicar: false,
      }))
      window.location.href = `perfil_compras/CHAVE=${chaveUrl}`
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!")
    }
  })
})