$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta.",
          position: "right"
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um ramo de atuação.",
          position: "right"
        },
      },
      {
        element: "#btnImprimir",
        popover: {
          title: "Botão Imprimir",
          description:
            "Clique aqui para imprimir os ramos de atuação.",
          position: "right"
        }
      },
      {
        element: "#tabelaRamoAtuacao",
        popover: {
          title: "Tabela de Dados",
          description: "Aqui estão os dados dos ramos de atuação cadastrados.",
          position: "top"
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await consultaDados();
  const permissaoUsuarioLogado = await permissaoAcessos("RAMOATUACAO");

  $('#txtRamoAtuacao').autocompleta(1, `JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#btnRamoAtuacao').pesquisa('#txtRamoAtuacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Ramo Atuação', '');

  $('#btnARamoAtuacao').on('click', async function () {
    $('#txtRamoAtuacao').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtRamoAtuacao').val('');
    $('#selectTipo').val('');
  });

  $("#btnIncluir").on("click", async function () {

    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const proximo = await RetornaProximo('RAMO_ATUACAO', 'RAMO_ATUACAO', 'CODIGO', 0);

      window.location.href = `ramoatuacao/${proximo}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" title="Excluir" id="btn-excluir">Excluir</button>     ' +
      '</div>';
    return retorno;
  };


  $("#btnImprimir").on("click", async function () {
    try {
      $.LoadingOverlay("show");

      const codigo = pegaChave('#txtRamoAtuacao');
      const tipo = $('#selectTipo').val();

      let url = `/sisplan/impressao/v1/relramoatuacao?codigo=${codigo}&tipo=${tipo}`;
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'RamoAtuacao');
      if (arquivo != undefined) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await consultaDados();
    $("#modal-filtros").modal("hide");
  });

  async function consultaDados() {
    try {
      $.LoadingOverlay("show");
      try {

        let params = '[ " 1=1 ';
        if ($('#txtRamoAtuacao').val() != '') {
          params += ` AND CODIGO = '${pegaChave('#txtRamoAtuacao')}'`;
        }
        if ($('#selectTipo').val() != '') {
          params += ` AND TIPO = '${$('#selectTipo').val()}'`;
        }
        params += ' " ]';

        let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela": "RAMO_ATUACAO", "camposSelect": ["CODIGO", "DESCRICAO", "TIPO"], "where": ${params}}`, null);
        if (!response) { return; }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        if (colunasInvisiveis == null || colunasInvisiveis.acessoServRamoAtuacao == undefined) {
          localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoServRamoAtuacao: ['EMPRESA'] }));
          colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
        }

        if (jsonStr.RESULT[0].length > 0) {
          $("#tabelaRamoAtuacao").DataTable({
            searching: true,
            destroy: true,
            lengthChange: true,
            scrollX: true,
            scrollY: '350px',
            serverSide: false,
            processing: true,
            "columns": [{
              "title": "Código",
              "data": "CODIGO"
            },
            {
              "title": "Descrição",
              "data": "DESCRICAO"
            },
            {
              "title": "Tipo",
              "data": "TIPO"
            }],
            data: jsonStr.RESULT[0],
            columnDefs: [
              {
                targets: [0], render: function (data) {
                  return retornaBotaoOpcoes(data);
                },
              },
            ],
          });

          $('#tabelaRamoAtuacao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
          $('#tabelaRamoAtuacao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
          $('#buttonExcel').prop('title', 'Exportar');

          $('#buttonColVis').on('click', async function () {
            $.LoadingOverlay('show');
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          });

          $('#buttonExcel').on('click', async function () {
            const dados = $("#tabelaRamoAtuacao").DataTable().data().toArray();
            await exportaCSV("", "", undefined, null, 'Relatório da aba serviços acesso ramo de atuação', '', '', 999, false, false, dados);
          });

          $('#tabelaRamoAtuacao').DataTable().columns().every(function () {
            if ((colunasInvisiveis.acessoServRamoAtuacao).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          });

          $("input[type='search']").focus();
        }
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRamoAtuacao').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoServRamoAtuacao ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoServRamoAtuacao: novasColunas }));

      $('#tabelaRamoAtuacao').DataTable().columns().visible(true);

      $('#tabelaRamoAtuacao').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  async function excluiLinha(codigo) {

    let response = await requisicao("DELETE", `/Sisplan/Cadastros/V1/ramoatuacao?`, `CODIGO=${codigo}`, 15000);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgAlerta(jsonStr[0].mensagem);
      return;
    }

    toastr
      .success("Exclusão realizada com sucesso!", "Confirmação", {
        toastClass: "alert",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/ramoatuacao`;
        },
      })
      .css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
  }

  $("#tabelaRamoAtuacao").on("click", "#btn-excluir", async function () {
    msgAlerta('Deseja excluir este registro?', async () => {
      if (permissaoUsuarioLogado.EXCLUI == 'S') {
        let data = $("#tabelaRamoAtuacao").DataTable().row($(this).parents("tr")).data();
        await excluiLinha(data.CODIGO);
      } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
      }
    })
  });

  $("#tabelaRamoAtuacao").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaRamoAtuacao").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("RAMOATUACAO", data.CODIGO);
      if (clienteLiberado) {
        window.location.href = `ramoatuacao/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaRamoAtuacao").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaRamoAtuacao").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("RAMOATUACAO", data.CODIGO);
      if (clienteLiberado) {
        window.location.href = `ramoatuacao/${data.CODIGO}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
