$(document).ready(async function () {

  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relEmbarque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEmbarque: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relEmbarque: novasColunas }))

      $('#tabelaRelEmbarque').DataTable().columns().visible(true);

      $('#tabelaRelEmbarque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para Imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });


  preencheOrdenacaoTela('RelEmbarque');

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtTipoCliente').autocompleta(1, `JSON={ "tabela":"SITCLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(3, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $("#txtUF").autocompleta(1, `JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
  $('#txtOperFiscal').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": ${sWhereOperFiscal}}`);
  $('#txtNotas').autocompleta(2, `JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA CHAVE", "DT_EMISSAO DESCRICAO"], "where": null}`);

  $('#btnTransportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
  $('#btnTipoCliente').pesquisa('#txtTipoCliente', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Tipo Cliente', 'SITCLI');
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}', 'Pesquisa de Cliente');
  $('#btnUF').pesquisa('#txtUF', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa UF', 'TABUF');
  $('#btnOperFiscal').pesquisa('#txtOperFiscal', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operacao Fiscal', 'OPER_FISCAL');
  $('#btnNotas').pesquisa_serverside(['#txtNotas'], ['FATURA'], ['DT_EMISSAO'], '{ "tabela":"NOTA", "camposSelect":[ "FATURA", "DT_EMISSAO"]}', 'Pesquisa de Nota');

  $('#txtTransportadora').listaFiltros();
  $('#txtTipoCliente').listaFiltros();
  $('#txtRepresentante').listaFiltros();
  $('#txtCliente').listaFiltros();
  $('#txtUF').listaFiltros();
  $('#txtOperFiscal').listaFiltros();
  $('#txtNotas').listaFiltros();

  $('#btnLimpaTransportadora').on('click', function () {
    if ($('#txtTransportadora').val() == '') {
      $('#listaTransportadora').val('');
    }
    $('#txtTransportadora').val('');
    $('#txtTransportadora').focus();
  });

  $('#btnLimpaTrasportadora2').on('click', function () {
    if ($('#txtTrasportadora2').val() == '') {
      $('#listaTrasportadora2').val('');
    }
    $('#txtTrasportadora2').val('');
    $('#txtTrasportadora2').focus();
  });

  $('#btnLimpaTipoCliente').on('click', function () {
    if ($('#txtTipoCliente').val() == '') {
      $('#listaTipoCliente').val('');
    }
    $('#txtTipoCliente').val('');
    $('#txtTipoCliente').focus();
  });

  $('#btnLimpaRepresentante').on('click', function () {
    if ($('#txtRepresentante').val() == '') {
      $('#listaRepresentante').val('');
    }
    $('#txtRepresentante').val('');
    $('#txtRepresentante').focus();
  });

  $('#btnLimpaCliente').on('click', function () {
    if ($('#txtCliente').val() == '') {
      $('#listaCliente').val('');
    }
    $('#txtCliente').val('');
    $('#txtCliente').focus();
  });

  $('#btnLimpaUF').on('click', function () {
    if ($('#txtUF').val() == '') {
      $('#listaUF').val('');
    }
    $('#txtUF').val('');
    $('#txtUF').focus();
  });

  $('#btnLimpaOperFiscal').on('click', function () {
    if ($('#txtOperFiscal').val() == '') {
      $('#listaOperFiscal').val('');
    }
    $('#txtOperFiscal').val('');
    $('#txtOperFiscal').focus();
  });

  $('#btnLimpaNotas').on('click', function () {
    if ($('#txtNotas').val() == '') {
      $('#listaNotas').val('');
    }
    $('#txtNotas').val('');
    $('#txtNotas').focus();
  });

  $('#btnLimparFiltros').on('click', function () {
    $('#txtDtEmissaoDe').val('1200-01-01');
    $('#txtDtEmissaoAte').val('2500-12-31');
    $('#txtDtSaidaDe').val('1200-01-01');
    $('#txtDtSaidaAte').val('2500-12-31');
    $('#txtDtEmbarqueDe').val('1200-01-01');
    $('#txtDtEmbarqueAte').val('2500-12-31');
    $('#txtTransportadora').val('');
    $('#txtTipoCliente').val('');
    $('#txtRepresentante').val('');
    $('#txtCliente').val('');
    $('#txtUF').val('');
    $('#txtOperFiscal').val('');
    $('#txtNotas').val('');
    $('#selectTipoNatureza').val('');
    $('#listaTransportadora').val('');
    $('#listaTransportadora2').val('');
    $('#listaTipoCliente').val('');
    $('#listaRepresentante').val('');
    $('#listaCliente').val('');
    $('#listaUF').val('');
    $('#listaOperFiscal').val('');
    $('#listaNotas').val('');
  });

  // $('#cbTodasEmpresas').on('change', function () {
  //   if ($('#cbTodasEmpresas')[0].checked == true) {
  //     carregaEmpresasDisponiveis();
  //   }
  // });

  retornaHintRelatorio('btnImprimir', 'relembarque')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/relembarque?`;

        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEmbarque&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEmbarque');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelEmbarque');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function montaPesquisa(colunaOrdenacao = '') {
    const sTipo = $('#radioEtiqueta').is(':checked') ? 'ETIQUETA' : 'MINUTA';
    const whereCompleto = await montaWherePesquisa(sTipo);
    const ligacaoCompleta = await montaLigacoesPesquisa(sTipo);
    const camposCompleto = await montaCamposSelect(sTipo);
    const groupByCompleto = await montaGroupBy(sTipo);

    const ordemOrdenacao = $('#txtOrdem').val();
    const orderBy = colunaOrdenacao == '' ? await retornaOrderBy(ordemOrdenacao) : colunaOrdenacao;

    try {
      try {
        $.LoadingOverlay("show");

        const pesquisa = {
          tabela: 'NOTA',
          camposSelect: camposCompleto.camposSelect,
          leftjoin: ligacaoCompleta,
          where: [`1=1 ${whereCompleto}`],
          groupby: groupByCompleto,
          orderby: [orderBy]
        }

        return {
          pesquisa: pesquisa,
          colunas: camposCompleto.colunas
        }

      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  }

  async function buscaDados(colunaOrdenacao = '') {
    if ($('#tabelaRelEmbarque')[0].rows.length > 0) {
      await limpaTabela();
    }
    Graficos.limpaGrafico(['graficoRelEmbarque']);

    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    let dataSetCols = [];

    try {
      try {
        $.LoadingOverlay("show");

        const pesquisa = await montaPesquisa(colunaOrdenacao);

        for (let i = 0; i < pesquisa.colunas.length; i++) {
          dataSetCols.push({
            'title': pesquisa.colunas[i],
            'data': pesquisa.colunas[i]
          });
        }

        $('#tabelaRelEmbarque').DataTable({
          paging: true,
          lengthChange: true,
          filter: false,
          info: true,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: "POST",
            headers: {
              'Authorization': BASIC_AUTH
            },
            data: {
              EMPRESA: getCookie('empresa'),
              JSON: JSON.stringify(pesquisa.pesquisa),
              CLIENTE: 'N'
            },
            dataSrc(data) {
              const cols = pesquisa.colunas;
              const array = data.data;
              return array.map(row => {
                return row.reduce((obj, value, index) => {
                  obj[cols[index]] = value;
                  return obj;
                }, {});
              });
            }
          },
          columns: dataSetCols,
          colReorder: true,
          "columnDefs": [
            {
              "render": function (data) {
                return parseFloat(data).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                });
              },
              "targets": 3,
              "className": 'pr-4 text-right'
            },
            {
              "targets": [14, 15, 16],
              "className": 'pr-4 text-right'
            }
          ],
          initComplete: function () {
            const tabela = this.api();
            const dados = tabela.data().toArray();

            dados.forEach(item => {
              item.VALOR_NOTA = parseFloat(item.VALOR_NOTA.replace('.', '').replace(',', '.'));
            });

            if (dados.length > 0) {
              Graficos.criarGrafico({
                container: 'graficoRelEmbarque',
                tipo: 'donut',
                dados: dados,
                nomeSerie: 'Valor',
                colunasAgrupamento: ['NOME_REPRESEN'],
                colunasValor: ['VALOR_NOTA'],
                title: 'Valor por transportadora'
              });
            }
          }
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelEmbarque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelEmbarque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/Sisplan/Funcoes/v1/pesquisa?';
          const pesquisa = await montaPesquisa();
          await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa.pesquisa))}`, true, null, 'Relatório de Embarque', '#tabelaRelEmbarque');
        })

        $('#tabelaRelEmbarque').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relEmbarque).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

        $('#tabelaRelEmbarque th').on('click', async function () {
          const nomeColuna = $(this).html();
          const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
          const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
          await buscaDados(nomeColuna + ' ' + ordenacao);
        });
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }

  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelEmbarque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relEmbarque ?? [])
  })

  $('#btnEmail').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/embarque/v1/emailxml?`;

        const filtros = await retornaFiltros();
        const response = await requisicao('POST', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();
        if (response != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        } else {
          msgSucesso('E-mails enviados com sucesso!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    const sEmissaoDe = $('#txtDtEmissaoDe').val();
    const sEmissaoAte = $('#txtDtEmissaoAte').val();
    const sSaidaDe = $('#txtDtSaidaDe').val() != '1200-01-01' ? $('#txtDtSaidaDe').val() : '';
    const sSaidaAte = $('#txtDtSaidaAte').val() != '2500-12-31' ? $('#txtDtSaidaAte').val() : '';
    const sEmbarqueDe = $('#txtDtEmbarqueDe').val() != '1200-01-01' ? $('#txtDtEmbarqueDe').val() : '';
    const sEmbarqueAte = $('#txtDtEmbarqueAte').val() != '2500-12-31' ? $('#txtDtEmbarqueAte').val() : '';
    const sTransportadora = await formataListas($('#listaTransportadora').val());
    const sTipoCliente = await formataListas($('#listaTipoCliente').val());
    const sRepresentante = await formataListas($('#listaRepresentante').val());
    const sCliente = await formataListas($('#listaCliente').val());
    const sUF = await formataListas($('#listaUF').val());
    const sOperacaoFiscal = await formataListas($('#listaOperFiscal').val());
    const sNotas = await formataListas($('#listaNotas').val());
    const sEmpID = $('.empresa_selecionada:checked').toArray().length > 0
      ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : getCookie('emp_id');
    const sNaturezaVenda = $('#cbTipoNatVendas').prop('checked') != false ? 'V' : '';
    const sNotasDenegadas = $('#cbNotasDenegadas').prop('checked');
    const sSemDtEmbarque = $('#cbSemDtEmbarque').prop('checked');
    const sTipoNatureza = $('#selectTipoNatureza').val();
    let sTipo;

    if ($('#radioEtiqueta').prop('checked')) {
      sTipo = 'ETIQUETA';
    }
    if ($('#radioMinuta').prop('checked')) {
      sTipo = 'MINUTA';
    }

    const params = `EMISSAO_DE=${sEmissaoDe}` +
      `&EMISSAO_ATE=${sEmissaoAte}` +
      `&SAIDA_DE=${sSaidaDe}` +
      `&SAIDA_ATE=${sSaidaAte}` +
      `&EMBARQUE_DE=${sEmbarqueDe}` +
      `&EMBARQUE_ATE=${sEmbarqueAte}` +
      `&TRANSPORTADORA=${sTransportadora}` +
      `&TIPO_CLIENTE=${sTipoCliente}` +
      `&REPRESENTANTE=${sRepresentante}` +
      `&CLIENTE=${sCliente}` +
      `&UF=${sUF}` +
      `&OPERACAO_FISCAL=${sOperacaoFiscal}` +
      `&NOTAS=${sNotas}` +
      `&EMP_ID=${sEmpID}` +
      `&TIPO=${sTipo}` +
      `&TIPO_NATUREZA=${sTipoNatureza}` +
      `&NATUREZA_VENDA=${sNaturezaVenda}` +
      `&NOTAS_DENEGADAS=${sNotasDenegadas}` +
      `&SEM_DT_EMBARQUE=${sSemDtEmbarque}`;

    return params;
  }

  async function montaWherePesquisa(tipo) {
    let where = '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND NOTA.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}'` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND NOTA.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}'` : '';
    where += $('#txtDtSaidaDe').val() != '' ? $('#txtDtSaidaDe').val() != '1200-01-01' ? ` AND NOTA.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}'` : '' : '';
    where += $('#txtDtSaidaAte').val() != '' ? $('#txtDtSaidaAte').val() != '2500-12-31' ? ` AND NOTA.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}'` : '' : '';
    where += $('#txtDtEmbarqueDe').val() != '' ? $('#txtDtEmbarqueDe').val() != '1200-01-01' ? ` AND NOTA.DT_EMBARQUE >=  '${$('#txtDtEmbarqueDe').val()}'` : '' : '';
    where += $('#txtDtEmbarqueAte').val() != '' ? $('#txtDtEmbarqueAte').val() != '2500-12-31' ? ` AND NOTA.DT_EMBARQUE <=  '${$('#txtDtEmbarqueAte').val()}'` : '' : '';
    where += $('#listaTransportadora').val() != '' ? ` AND (NOTA.TRANSPORT IN (${await formataListas($('#listaTransportadora').val())}) OR NOTA.CODTRAN_MINUTA IN (${await formataListas($('#listaTransportadora').val())}))` : '';
    where += $('#listaTipoCliente').val() != '' ? ` AND CLIENTE.SIT_CLI in (${await formataListas($('#listaTipoCliente').val())})` : '';
    where += $('#listaRepresentante').val() != '' ? ` AND REPRESEN.CODREP in (${await formataListas($('#listaRepresentante').val())})` : '';
    where += $('#listaCliente').val() != '' ? ` AND NOTA.CODCLI in (${await formataListas($('#listaCliente').val())})` : '';
    where += $('#listaOperFiscal').val() != '' ? ` AND NOTA.OPERACAO IN (${await formataListas($('#listaOperFiscal').val())})` : '';
    where += $('#listaNotas').val() != '' ? ` AND NOTA.FATURA IN (${await formataListas($('#listaNotas').val())})` : '';
    where += $('#cbTipoNatVendas').prop('checked') != false ? " AND (NOTA_NATUREZA.TIPO = 'V')" : '';
    where += $('#cbNotasDenegadas').prop('checked') != false ? " AND (NOTA.IMPRESSO = 'D')" : "AND (NOTA.IMPRESSO <> 'D')";
    where += $('#cbSemDtEmbarque').prop('checked') != false ? " AND NOTA.DT_EMBARQUE IS NULL" : '';
    where += $('.empresa_selecionada:checked').toArray().length > 0
      ? ` AND NOTA.EMP_ID IN (${$('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))})`
      : ` AND NOTA.EMP_ID IN (${getCookie('emp_id')})`;

    switch ($('#selectTipoNatureza').val()) {
      case "1":
        where += " AND NOTA_NATUREZA.TP_BASE = '1'";
        break;
      case "2":
        where += " AND NOTA_NATUREZA.TP_BASE = '2'";
        break;
      default:
        break;
    }

    if (tipo == 'ETIQUETA') {
      where += $('#listaUF').val() != '' ? ` AND CIDADE.COD_UF IN (${await formataListas($('#listaUF').val())})` : '';
    } else {
      where += " AND NOTAITEN.EMPENHO <> 'S'";
      where += $('#listaUF').val() != '' ? ` AND CIDADE2.COD_UF IN (${await formataListas($('#listaUF').val())})` : '';
    }

    where += " AND NOTA.IMPRESSO <> 'C'";

    return where;

  }

  async function montaLigacoesPesquisa(tipo) {
    let ligacao = '';
    if (tipo == 'ETIQUETA') {
      ligacao = [{ "tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = CLIENTE.CODCLI", "alias": "CLIENTE" },
      { "tabela": "CADCEP", "condicao": "CLIENTE.CEP_ENT = CADCEP.CEP" },
      { "tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CADCEP.CODMUN" },
      { "tabela": "TABTRAN", "condicao": "((CASE WHEN UDF_LEN(NOTA.CODTRAN_MINUTA)>0 THEN NOTA.CODTRAN_MINUTA ELSE NOTA.TRANSPORT END) = TABTRAN.codigo)" },
      { "tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = NOTA.CODREP" },
      { "tabela": "TABTRAN", "condicao": "REDESP.CODIGO = NOTA.REDESP", "alias": "REDESP" },
      { "tabela": "CADCEP", "condicao": "REDESP.CEP = CADCEP2.CEP", "alias": "CADCEP2" },
      { "tabela": "CIDADE", "condicao": "CIDADE2.CODIGO = CADCEP2.CODMUN", "alias": "CIDADE2" },
      { "tabela": "NATUREZA", "condicao": "NOTA_NATUREZA.NATUREZA = NOTA.NATUREZA", "alias": "NOTA_NATUREZA" }];

    } else {
      ligacao = [{ "tabela": "TABTRAN", "condicao": "((CASE WHEN UDF_LEN(NOTA.CODTRAN_MINUTA)>0 THEN NOTA.CODTRAN_MINUTA ELSE NOTA.TRANSPORT END) = TABTRAN.CODIGO)" },
      { "tabela": "CADCEP", "condicao": "TABTRAN.CEP = CEP1.CEP", "alias": "CEP1" },
      { "tabela": "CIDADE", "condicao": "CIDADE1.CODIGO = CEP1.CODMUN", "alias": "CIDADE1" },
      { "tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = CLIENTE.CODCLI", "alias": "CLIENTE" },
      { "tabela": "CADCEP", "condicao": "CLIENTE.CEP_ENT = CEP2.CEP", "alias": "CEP2" },
      { "tabela": "CIDADE", "condicao": "CIDADE2.CODIGO = CEP2.CODMUN", "alias": "CIDADE2" },
      { "tabela": "REPRESEN", "condicao": "REPRESEN.CODREP = NOTA.CODREP" },
      { "tabela": "TABTRAN", "condicao": "REDESP.CODIGO = NOTA.REDESP", "alias": "REDESP" },
      { "tabela": "CADCEP", "condicao": "REDESP.CEP = CEP3.CEP", "alias": "CEP3" },
      { "tabela": "CIDADE", "condicao": "CIDADE3.CODIGO = CEP3.CODMUN", "alias": "CIDADE3" },
      { "tabela": "NATUREZA", "condicao": "NOTA_NATUREZA.NATUREZA = NOTA.NATUREZA", "alias": "NOTA_NATUREZA" },
      { "tabela": "NOTAITEN", "condicao": "NOTAITEN.FATURA = NOTA.FATURA" },
      { "tabela": "PED_ITEN", "condicao": "(PED_ITEN.NUMERO = NOTAITEN.PEDIDO AND PED_ITEN.CODIGO = NOTAITEN.CODIGO AND PED_ITEN.COR = NOTAITEN.COR AND PED_ITEN.TAM = NOTAITEN.TAMANHO AND PED_ITEN.ORDEM = NOTAITEN.ORD_PED)" },
      { "tabela": "PEDIDO", "condicao": "PED_ITEN.NUMERO = PEDIDO.NUMERO" },
      { "tabela": "CADCEP", "condicao": "CLIENTE.CEP = CEP4.CEP", "alias": "CEP4" },
      { "tabela": "CIDADE", "condicao": "CIDADE4.CODIGO = CEP4.CODMUN", "alias": "CIDADE4" }];
    }

    return ligacao;

  }

  async function montaCamposSelect(tipo) {
    let camposSelect = [];
    let colunas = [];

    if (tipo == 'ETIQUETA') {

      camposSelect = ["NOTA.FATURA", "NOTA.SERIE", "NOTA.CHAVE_NFE", "NOTA.VALOR VALOR_NOTA", "NOTA.CODCLI", "CLIENTE.NOME CLIENTE",
        "CASE WHEN UDF_LEN(NOTA.CODTRAN_MINUTA)>0 THEN NOTA.CODTRAN_MINUTA ELSE NOTA.TRANSPORT END CODTRANS",
        "TABTRAN.NOME AS DESCTRANS", "NOTA.CODREP AS COD_REPRESEN", "REPRESEN.NOME AS NOME_REPRESEN", "CIDADE.COD_UF AS ESTCEP",
        "NOTA.DT_EMISSAO", "NOTA.DT_SAIDA", "NOTA.DT_EMBARQUE", "NOTA.VOLUMES", "NOTA.PESOB", "NOTA.PESOL"
        // "NOTA.EMP_ID",
        // "CLIENTE.TIPO TIPO_ENTIDADE", "CLIENTE.FANTASIA", "CLIENTE.END_ENT", "CLIENTE.NUM_ENT", "CLIENTE.COMP_ENT",
        // "CLIENTE.CEP ESTADO", "CLIENTE.CEP_ENT", "CLIENTE.BAIRRO", "CIDADE.NOME AS NOMCEP", "TABTRAN.CONTATO",
        // "CLIENTE.CNPJ", "CLIENTE.CNPJ_ENT", "CLIENTE.INSCRICAO", "CLIENTE.ENDERECO", "CLIENTE.NUMERO", "CLIENTE.COMPLEMENTO",
        // "CLIENTE.BAIRRO_ENT", "CLIENTE.DDD_FONE", "CLIENTE.TELEFONE", "CLIENTE.FONE_COMPL", "CLIENTE.NRLOJA AS LOJA",
        // "NOTA.REDESP AS COD_REDESPACHO", "REDESP.NOME AS NOME_REDESPACHO", "REDESP.BAIRRO AS BAIRRO_REDESPACHO",
        // "REDESP.CEP AS CEP_REDESPACHO", "REDESP.ENDERECO AS END_REDESPACHO", "REDESP.TELEFONE AS FONE_REDESPACHO",
        // "CIDADE2.COD_UF AS UF_REDESPACHO", "CIDADE2.NOME AS CIDADE_REDESPACHO", "NOTA.NUM_COTACAO", "NOTA.VAL_FRETE_PAGO",
        // "0.0000 AS CUBAGEM", "0.0000 AS VOL_CAIXAS", "CAST('''' AS VARCHAR(250)) BARRA_CAIXA", "NOTA.PECAS", "NOTA.CIF"
      ];

      colunas = ["FATURA", "SERIE", "CHAVE_NFE", "VALOR_NOTA", "CODCLI", "CLIENTE", "CODTRANS", "DESCTRANS", "COD_REPRESEN",
        "NOME_REPRESEN", "ESTADO", "DT_EMISSAO", "DT_SAIDA", "DT_EMBARQUE", "VOLUMES", "PESOB", "PESOL"];

    } else {

      camposSelect = ["NOTA.FATURA", "NOTA.SERIE", "NOTA.CHAVE_NFE", "NOTA.VALOR VALOR_NOTA", "NOTA.CODCLI", "CLIENTE.NOME CLIENTE",
        "CASE WHEN UDF_LEN(NOTA.CODTRAN_MINUTA)>0 THEN NOTA.CODTRAN_MINUTA ELSE NOTA.TRANSPORT END CODTRANS",
        "TABTRAN.NOME DESCTRANS", "NOTA.CODREP COD_REPRESEN", "REPRESEN.NOME NOME_REPRESEN", "CIDADE2.COD_UF ESTCEP",
        "NOTA.DT_EMISSAO", "NOTA.DT_SAIDA", "NOTA.DT_EMBARQUE", "NOTA.VOLUMES", "NOTA.PESOB",
        "NOTA.PESOL", `(SELECT CAST(${await retornaCampoList('NOTAITEN.PEDIDO', ", ", true)} AS VARCHAR(1000)) PEDIDOS FROM [NOTAITEN] NOTAITEN WHERE (NOTAITEN.FATURA = NOTA.FATURA)) PEDIDOS`
        // "NOTA.EMP_ID",
        // "(SELECT CAST (${await retornaCampoList('NOTAITEN.COR', ", ", true)} AS VARCHAR(3050)) CORES FROM [NOTAITEN] NOTAITEN WHERE (NOTAITEN.FATURA = NOTA.FATURA)) CORES",
        // "TABTRAN.CODIGO COD_TRAN", "TABTRAN.CGC CNPJ_TRAN", "TABTRAN.INSCRICAO INCRICAO_TRAN", "TABTRAN.ENDERECO END_ERECOTRAN", "TABTRAN.TELEFONE FONE_TRAN", "TABTRAN.CONTATO CONTATO_TRAN",
        // "TABTRAN.CEP CEP_TRAN", "NOTA.ESPECIE", "NOTA.PECAS", "NOTA.VAL_FRETE", "CLIENTE.TELEFONE", "CLIENTE.FONE_COMPL", "CLIENTE.NRLOJA LOJA", "NOTA.REDESP COD_REDESPACHO",
        // "CIDADE1.NOME NOMCEP", "CIDADE1.COD_UF ESTTRAN", "CLIENTE.TIPO TIPO_ENTIDADE", "CLIENTE.CEP ENTIDADE_CEP", "CIDADE4.COD_UF ESTCEP_CLI", "CIDADE4.NOME CIDADECLI_CLI",
        // "CIDADE2.NOME CIDADECLI", "CLIENTE.CEP_ENT ESTADO", "CLIENTE.CNPJ", "CLIENTE.CNPJ_ENT", "CLIENTE.INSCRICAO", "CLIENTE.ENDERECO", "CLIENTE.END_ENT", "CLIENTE.NUMERO", "NOTA.CIF",
        // "CLIENTE.NUM_ENT", "CLIENTE.COMPLEMENTO", "CLIENTE.BAIRRO", "CLIENTE.BAIRRO_ENT", "CLIENTE.DDD_FONE", "REDESP.NOME NOME_REDESPACHO", "REDESP.BAIRRO BAIRRO_REDESPACHO",
        // "REDESP.CEP CEP_REDESPACHO", "REDESP.ENDERECO END_REDESPACHO", "REDESP.TELEFONE FONE_REDESPACHO", "CIDADE3.COD_UF UF_REDESPACHO", "CIDADE3.NOME CIDADE_REDESPACHO",
        // "NOTA.NUM_COTACAO", "NOTA.VAL_FRETE_PAGO", "0.0000 CUBAGEM", "CAST(${await retornaCampoList('PEDIDO.PED_CLI', ", ", true)} AS VARCHAR(1000)) PED_CLI",
        // "0.0000 VOL_CAIXAS", "CLIENTE.FANTASIA FANTASIA_CLIENTE", "TABTRAN.FANTASIA FANTASIA_TRANSP", "CAST('''' AS VARCHAR(250)) BARRA_CAIXA", "'''' NUM_CAIXA"
      ];

      colunas = ["FATURA", "SERIE", "CHAVE_NFE", "VALOR_NOTA", "CODCLI", "CLIENTE", "CODTRANS", "DESCTRANS", "COD_REPRESEN", "NOME_REPRESEN", "ESTADO", "DT_EMISSAO", "DT_SAIDA",
        "DT_EMBARQUE", "VOLUMES", "PESOB", "PESOL", "PEDIDOS"];

    }

    return objeto = {
      camposSelect: camposSelect,
      colunas: colunas
    };

  }

  async function montaGroupBy(tipo) {
    let groupBy = [];
    if (tipo == 'MINUTA') {
      groupBy = ["NOTA.FATURA", "NOTA.CIF", "NOTA.SERIE", "NOTA.CODCLI", "NOTA.PECAS", "NOTA.PESOB", "NOTA.PESOL", "NOTA.VALOR", "NOTA.VAL_FRETE", "NOTA.TRANSPORT",
        "NOTA.VOLUMES", "NOTA.ESPECIE", "NOTA.DT_EMISSAO", "NOTA.DT_SAIDA", "NOTA.EMP_ID", "TABTRAN.CODIGO", "TABTRAN.NOME", "TABTRAN.CGC", "TABTRAN.INSCRICAO", "TABTRAN.ENDERECO",
        "TABTRAN.TELEFONE", "TABTRAN.CONTATO", "TABTRAN.CEP", "NOTA.CODTRAN_MINUTA", "CIDADE1.NOME", "CIDADE1.COD_UF", "CLIENTE.NOME", "CIDADE2.COD_UF", "CIDADE2.NOME",
        "CLIENTE.CEP", "CLIENTE.TIPO", "CIDADE4.COD_UF", "CIDADE4.NOME", "CLIENTE.CEP_ENT", "CLIENTE.CNPJ", "CLIENTE.CNPJ_ENT", "CLIENTE.INSCRICAO", "CLIENTE.ENDERECO",
        "CLIENTE.END_ENT", "CLIENTE.NUMERO", "CLIENTE.NUM_ENT", "CLIENTE.COMPLEMENTO", "CLIENTE.BAIRRO", "CLIENTE.BAIRRO_ENT", "CLIENTE.DDD_FONE", "CLIENTE.TELEFONE",
        "CLIENTE.FONE_COMPL", "CLIENTE.NRLOJA", "NOTA.CODREP", "REPRESEN.NOME", "NOTA.REDESP", "REDESP.NOME", "REDESP.BAIRRO", "REDESP.CEP", "REDESP.ENDERECO",
        "REDESP.TELEFONE", "CIDADE3.COD_UF", "CIDADE3.NOME", "NOTA.NUM_COTACAO", "NOTA.VAL_FRETE_PAGO", "NOTA.CHAVE_NFE", "CLIENTE.FANTASIA", "TABTRAN.FANTASIA",
        "NOTA.DT_EMBARQUE"];
    }
    return groupBy;
  }

  $('#btnConsultar').on('click', async function () {
    await buscaDados();
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1])
    }
  });


  async function limpaTabela() {
    $('#tabelaRelEmbarque').DataTable().destroy().draw(false);
    $('#tabelaRelEmbarque').html('<thead></thead><tbody></tbody>');
  }

  async function retornaOrderBy(ordem) {
    let resultado;
    const pesquisa = {
      tabela: "ORDEM_TELA",
      camposSelect: ["NOME_ORD_SIST"],
      where: [`NOME_TELA = 'RelEmbarque' AND ORDEM = ${ordem}`]
    };
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    resultado = json[0].NOME_ORD_SIST; //'PA_ITEN.COR, PA_ITEN.TAM, PA_ITEN.CODIGO';
    return resultado.replaceAll(';', ',')
  }

});