$(document).ready(async function () {



  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.RelMinuta == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, RelMinuta: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, RelMinuta: novasColunas }))

      $('#tabelaRelMinuta').DataTable().columns().visible(true);
      $('#tabelaRelMinuta').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  addTutorial();
  await preencheOrdenacaoTela('RelMinuta');
  await addPesquisaAutocompleta();

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnLimparFiltros').on('click', function () {
    limpaFiltros();
  });

  retornaHintRelatorio('btnImprimir', 'RelMinuta')
  retornaHintRelatorio('btnImprimirEtiqueta', 'RelMinutaEtiqueta')

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelminuta?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelMinuta&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMinuta');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelMinuta');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImprimirEtiqueta').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelminuta?`;
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelMinutaEtiqueta&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelMinutaEtiqueta');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 100000, false, 'RelMinutaEtiqueta');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#rdEtiqueta').on('change', async function () {
    if ($('#rdEtiqueta').is(':checked')) {
      $('#txtOrdem').empty()
      await preencheOrdenacaoTela('RelMinutaEtiqueta');
    }
  })

  $('#rdMinuta').on('change', async function () {
    if ($('#rdMinuta').is(':checked')) {
      $('#txtOrdem').empty()
      await preencheOrdenacaoTela('RelMinuta');
    }
  })

  $('#btnConsultar').on('click', async function () {
    $.LoadingOverlay('show');
    if ($("#txtOrdem option").toArray().length > 0) {
      retornaHintRelatorio('btnImprimir', $("#txtOrdem option").toArray().map(map => { return [map.selected, $(map).attr('nome_prt')] }).filter(filter => filter[0] == true)[0][1], true)
    }
    if ($.fn.DataTable.isDataTable('#tabelaRelMinuta')) {
      $('#tabelaRelMinuta').DataTable().destroy();
      $('#tabelaRelMinuta').empty();
    }
    try {
      let dataSetCols = [];
      const url = '/sisplan/impressao/v1/relminuta?';
      const filtros = await retornaFiltros();

      const response = await requisicao('GET', url, filtros, 130000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum registro encontrado!')
        return;
      }

      if ($('#rdEtiqueta').is(':checked')) {
        $('#btnImprimir').addClass('d-none')
        $('#btnImprimirEtiqueta').removeClass('d-none')
      } else {
        $('#btnImprimir').removeClass('d-none')
        $('#btnImprimirEtiqueta').addClass('d-none')
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach(k => {
        if (k == 'CONFERIDO')
          return;
        let obj = {};
        if (k == 'FATURA')
          obj.title = 'Fatura';
        if (k == 'CIF')
          obj.title = 'CIF';
        if (k == 'SERIE')
          obj.title = 'Série';
        if (k == 'CODCLI')
          obj.title = 'Cód. Cliente';
        if (k == 'PECAS')
          obj.title = 'Peças';
        if (k == 'PESOB')
          obj.title = 'Peso Bruto';
        if (k == 'PESOL')
          obj.title = 'Peso Líq.';
        if (k == 'VALOR')
          obj.title = 'Valor';
        if (k == 'VAL_FRETE')
          obj.title = 'Val. Frete';
        if (k == 'TRANSPORT')
          obj.title = 'Transportadora';
        if (k == 'DT_EMISSAO')
          obj.title = 'Emissão';
        if (k == 'DT_SAIDA')
          obj.title = 'Saída';
        if (k == 'VOLUMES')
          obj.title = 'Volumes';
        if (k == 'CAIXA')
          obj.title = 'Caixa';
        if (k == 'ESPECIE')
          obj.title = 'Espécie';
        if (k == 'PEDIDOS')
          obj.title = 'Pedidos';
        if (k == 'CORES')
          obj.title = 'Cores';
        if (k == 'CODTRAN')
          obj.title = 'Cód. Transportadora';
        if (k == 'NOMETRAN')
          obj.title = 'Nome Transportadora';
        if (k == 'CNPFTRAN')
          obj.title = 'CNPJ Transportadora';
        if (k == 'INSCRICAO')
          obj.title = 'Inscrição';
        if (k == 'ENDERECO')
          obj.title = 'Endereço';
        if (k == 'TELEFONE')
          obj.title = 'Telefone';
        if (k == 'CONTATO')
          obj.title = 'Contato';
        if (k == 'CEP')
          obj.title = 'CEP';
        if (k == 'FAXTRANS')
          obj.title = 'FAX Transportadora';
        if (k == 'OBSTRANS')
          obj.title = 'Obs. Transportadora';
        if (k == 'NOMCEP')
          obj.title = 'Cidade';
        if (k == 'ESTTRAN')
          obj.title = 'UF Transportadora';
        if (k == 'TIPO_ENTIDADE')
          obj.title = 'Tipo Entidade';
        if (k == 'NOMECLI')
          obj.title = 'Nome Cliente';
        if (k == 'ENTIDADE_CEP')
          obj.title = 'CEP Entidade';
        if (k == 'ESTCEP_CLI')
          obj.title = 'UF Cliente';
        if (k == 'CIDADE_CLI')
          obj.title = 'Cidade Cliente';
        if (k == 'ESTCEP')
          obj.title = 'Estado';
        if (k == 'CIDADECLI')
          obj.title = 'Cidade Cliente';
        if (k == 'CEP_ENT')
          obj.title = 'CEP Entidade';
        if (k == 'CNPJ')
          obj.title = 'CNPJ';
        if (k == 'CNPJ_ENT')
          obj.title = 'CNPJ Entidade';
        if (k == 'INSCRICAO_1')
          obj.title = 'Inscrição';
        if (k == 'ENDERECO_1')
          obj.title = 'Endereço';
        if (k == 'END_ENT')
          obj.title = 'Endereço Entidade';
        if (k == 'NUMERO')
          obj.title = 'Número';
        if (k == 'NUM_ENT')
          obj.title = 'Número Entidade';
        if (k == 'COMPLEMENTO')
          obj.title = 'Complemento';
        if (k == 'BAIRRO')
          obj.title = 'Bairro';
        if (k == 'BAIRRO_ENT')
          obj.title = 'Bairro Entidade';
        if (k == 'DDD_FONE')
          obj.title = 'DDD Telefone';
        if (k == 'TELEFONE_1')
          obj.title = 'Telefone';
        if (k == 'FONE_COMPL')
          obj.title = 'Telefone Compl.';
        if (k == 'LOJA')
          obj.title = 'Loja';
        if (k == 'OBS')
          obj.title = 'Observação';
        if (k == 'COD_REPRES')
          obj.title = 'Cód. Representante';
        if (k == 'NOME_REPRESEN')
          obj.title = 'Nome Representante';
        if (k == 'COD_REDESPACHO')
          obj.title = 'Cód. Redespacho';
        if (k == 'NOME_REDESPACHO')
          obj.title = 'Nome Redespacho';
        if (k == 'BAIRRO_REDESPACHO')
          obj.title = 'Bairro Redespacho';
        if (k == 'CEP_REDESPACHO')
          obj.title = 'CEP Redespacho';
        if (k == 'END_REDESPACHO')
          obj.title = 'Endereço Redespacho';
        if (k == 'FONE_REDESPACHO')
          obj.title = 'Telefone Redespacho';
        if (k == 'UF_REDESPACHO')
          obj.title = 'UF Redespacho';
        if (k == 'CIDADE_REDESPACHO')
          obj.title = 'Cidade Redespacho';
        if (k == 'NUM_COTACAO')
          obj.title = 'Número cotação';
        if (k == 'VAL_FRETE_PAGO')
          obj.title = 'Val. Frete Pago';
        if (k == 'CUBAGEM')
          obj.title = 'Cubagem';
        if (k == 'PED_CLI')
          obj.title = 'Pedido Cliente';
        if (k == 'CHAVE_NFE')
          obj.title = 'Chave NF-e';
        if (k == 'VOL_CAIXAS')
          obj.title = 'Volumes Caixas';
        if (k == 'FANTASIA_CLI')
          obj.title = 'Fantasia Cliente';
        if (k == 'FANTASIA_TRANSP')
          obj.title = 'Fanatasia Transportadora';
        if (k == 'DT_EMBARQUE')
          obj.title = 'Embarque';
        if (k == 'BARRA_CAIXA')
          obj.title = 'Barra Caixa';
        if (k == 'NUM_CAIXA')
          obj.title = 'Número Caixa';
        if (k == 'PLACA')
          obj.title = 'Placa';
        if (k == 'IMP_ETQ')
          obj.title = 'Imp. Etiqueta';
        if (k == 'EMP_NOTA')
          obj.title = 'Emp. Fat.';
        if (k == 'CONFERIDO')
          obj.title = 'Conferido';

        obj.data = k;
        dataSetCols.push(obj);
      });

      criaDataTablePadrao('#tabelaRelMinuta', true, true, true, true, true, true, true, jsonStr, dataSetCols, [], [10, 11], [], [5, 6, 7], '', 2, 'buttonColVis', 'buttonExcel', true, [], [12], undefined, undefined, true);


      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/relminuta?';
        const filtros = await retornaFiltros();

        await exportaCSV(url, filtros, false, null, 'Relatório de Minuta', '#tabelaRelMinuta');
      });


      $('#tabelaRelMinuta').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.RelMinuta).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })


      await buscaDadosConferencia(jsonStr);
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelMinuta').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relMinuta ?? [])
  });

  $('#btnWhatsapp').on('click', function () {
    $('#modalWhatsapp').modal('show');
  });

  async function buscaDadosConferencia(dadosConferencia) {
    $.LoadingOverlay('show');
    $('#divConferencia').removeClass('d-none');
    try {
      let dataSetCols = [];

      let keys = Object.keys(dadosConferencia[0]);

      keys.forEach(k => {
        let obj = {};

        if (k == 'FATURA') {
          obj.title = 'Fatura';
        } else if (k == 'SERIE') {
          obj.title = 'Série';
        } else if (k == 'TRANSPORT') {
          obj.title = 'Transportadora';
        } else if (k == 'CODCLI') {
          obj.title = 'Cód. Cliente';
        } else if (k == 'DT_EMISSAO') {
          obj.title = 'Emissão';
        } else if (k == 'DT_SAIDA') {
          obj.title = 'Saída';
        } else if (k == 'DT_EMBARQUE') {
          obj.title = 'Embarque';
        } else if (k == 'EMP_NOTA') {
          obj.title = 'Emp. Fat.';
        } else if (k == 'CONFERIDO') {
          obj.title = 'Conferido';
        } else if (k == 'CHAVE_NFE') {
          obj.title = 'Chave NF-e';
        } else {
          return
        };

        obj.data = k;
        dataSetCols.push(obj);
      });

      $("#tabelaConferencia").DataTable({
        search: false,
        filter: false,
        sort: false,
        destroy: true,
        pageLength: 8,
        paging: true,
        autoWidth: true,
        columnDefs: [
          {
            targets: [6],
            visible: false,
          },
          {
            type: 'date-br',
            targets: [4, 5],
            render(data) {
              if (data) {
                return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
              } else {
                return '';
              }

            },
          },
          // {
          //   targets: [1],
          //   render(data) {
          //     return parseInt(data);
          //   },
          //   className: "pr-4 text-right",
          // },
        ],
        data: dadosConferencia,
        columns: dataSetCols,
      });
    } catch {
      msgAlerta('Não foi possível buscar os dados de conferência. Verifique e tente novamente.');
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#txtConferencia').on('blur', async function () {
    const valorBusca = $(this).val().trim();
    if (!valorBusca) return;

    const tabela = $('#tabelaConferencia').DataTable();

    let encontrado = false;
    let rowIndex = -1;
    let rowDataSelecionado = null;

    tabela.rows().every(function (index) {
      const rowData = this.data();
      if (rowData.CHAVE_NFE && rowData.CHAVE_NFE.trim() === valorBusca) {
        encontrado = true;
        rowIndex = index;
        rowDataSelecionado = rowData;
        return false;
      }
    });

    if (!encontrado) {
      msgAlerta('Nenhum registro encontrado para essa chave.');
      $('#txtConferencia').val('');
      return;
    }

    const pageInfo = tabela.page.info();
    const pageSize = pageInfo.length;
    const targetPage = Math.floor(rowIndex / pageSize);

    tabela.page(targetPage).draw('page');

    setTimeout(async () => {
      const rowNode = tabela.row(rowIndex).node();
      if (rowNode) {
        $(rowNode).addClass('selected');
        $('html, body').animate({
          scrollTop: $(rowNode).offset().top - 150
        }, 500);
      }

      const fatura = rowDataSelecionado.FATURA;
      const empNota = rowDataSelecionado.EMP_NOTA;

      $('#txtConferencia').val('');

      const payload = {
        fatura: fatura,
        emp_id: empNota
      };

      const url = `/sisplan/impressao/v1/relminutaconferido?`;

      const response = await requisicao('POST', url, `FATURA_NOTA=${payload.fatura}&EMP_FATURA=${payload.emp_id}`, 130000);

      if (!response) return;

      if (response.status != 200) {
        console.error(response.mensagem || 'Erro na requisição');
        return;
      }

      const row = tabela.row(rowIndex);

      const updatedData = { ...rowDataSelecionado, CONFERIDO: 'S' };

      row.data(updatedData).invalidate().draw(false);
    }, 200);
  });


  function limpaFiltros() {
    $('#dtEmissaoDe').val('');
    $('#dtEmissaoAte').val('');
    $('#dtSaidaDe').val('');
    $('#dtSaidaAte').val('');
    $('#dtEmbarqueDe').val('');
    $('#dtEmbarqueAte').val('');
    $('#txtNotaDe').val('');
    $('#txtNotaAte').val('');
    $('#txtObs').val('');
    $('#txtChave').val('');
    $('#selectNotas').val('');
    $('#txtCliente').empty().trigger('change');
    $('#txtRepresentante').empty().trigger('change');
    $('#txtTransportadora').empty().trigger('change');
    $('#txtTipoCliente').empty().trigger('change');
    $('#txtUf').empty().trigger('change');
    $('#txtOperacaoFiscal').empty().trigger('change');
    $('#txtPlaca').empty().trigger('change');
    $('#txtTipoVenda').empty().trigger('change');
    $('#txtNota').empty().trigger('change');
    $('#cbNotasDenegadas').prop('checked', false);
    $('#cbExpedicao').prop('checked', false);
    $('#cbSemDtEmbarque').prop('checked', false);
    $('#cbTipoNatVenda').prop('checked', false);
    $('#rdMinuta').prop('checked', true);
    $('#txtMinuta').empty().trigger('change');
  }

  async function retornaFiltros() {
    const empresasFiltradas = $(".empresa_selecionada:checked").toArray().length > 0 ? $(".empresa_selecionada:checked").toArray().map((input) => input.id.substring(input.id.indexOf("-") + 1, input.id.length)) : [getCookie("emp_id")];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const todasEmpresas = $("#cbTodasAsEmpresas").is(':checked') ? true : false;

    const retorno =
      `EMISSAODE=${$('#dtEmissaoDe').val()}` +
      `&EMISSAOATE=${$('#dtEmissaoAte').val()}` +
      `&SAIDADE=${$('#dtSaidaDe').val()}` +
      `&SAIDAATE=${$('#dtSaidaAte').val()}` +
      `&EMBARQUEDE=${$('#dtEmbarqueDe').val()}` +
      `&EMBARQUEATE=${$('#dtEmbarqueAte').val()}` +
      `&NOTADE=${$('#txtNotaDe').val()}` +
      `&NOTAATE=${$('#txtNotaAte').val()}` +
      `&OBS=${$('#txtObs').val()}` +
      `&CHAVE=${$('#txtChave').val()}` +
      `&TIPONOTA=${$('#selectNotas').val()}` +
      `&TRANSPORTADORA=${await formataListas($('#txtTransportadora').val().toString())}` +
      `&TIPOCLIENTE=${await formataListas($('#txtTipoCliente').val().toString())}` +
      `&REPRESENTANTE=${await formataListas($('#txtRepresentante').val().toString())}` +
      `&CLIENTE=${await formataListas($('#txtCliente').val().toString())}` +
      `&UF=${await formataListas($('#txtUf').val().toString())}` +
      `&OPERACAOFISCAL=${await formataListas($('#txtOperacaoFiscal').val().toString())}` +
      `&PLACA=${await formataListas($('#txtPlaca').val().toString())}` +
      `&TIPOVENDA=${await formataListas($('#txtTipoVenda').val().toString())}` +
      `&NOTAS=${await formataListas($('#txtNota').val().toString())}` +
      `&MINUTAS=${await formataListas($('#txtMinuta').val().toString())}` +
      `&NOTADENEGADA=${$('#cbNotasDenegadas').is(':checked') ? true : false}` +
      `&EXPEDICAO=${$('#cbExpedicao').is(':checked') ? true : false}` +
      `&SEMDTEMBARQUE=${$('#cbSemDtEmbarque').is(':checked') ? true : false}` +
      `&TIPONATVENDA=${$('#cbTipoNatVenda').is(':checked') ? true : false}` +
      `&TIPO=${$('#rdMinuta').is(':checked') ? 'M' : 'E'}` +
      `&TODASEMPRESAS=${todasEmpresas}` +
      `&EMPRESAS=${empresasFiltradasFormatada}`
    return retorno;
  }

  function addTutorial() {
    $('#tutorial').on('click', function () {
      $(document).ready(async function () {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false
        });
        driver.defineSteps([{
          element: '#btnFiltros',
          popover: {
            title: 'Botão Filtros',
            description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
            position: 'right'
          }
        },
        {
          element: '#btnImprimir',
          popover: {
            title: 'Botão Imprimir',
            description: 'Clique aqui para imprimir um relatório.',
            position: 'right'
          }
        },
        {
          element: '#tabelaRelMinuta',
          popover: {
            title: 'Tabela Notas',
            description: 'Aqui, após clicar em consultar ficam os dados das notas filtradas.',
            position: 'bottom'
          }
        }
        ]);
        driver.start();
      });
    });
  }

  $("#btnCarregaEmpresas").on("click", function () {
    carregaEmpresasDisponiveis();
  });

  $('#txtChave').on('blur', async function () {
    if ($('#txtChave').val() != '') {
      let chave = $('#txtChave').val()
      $.LoadingOverlay('show')
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"NOTA", 
              "camposSelect":["FATURA", "CHAVE_NFE"], 
              "where": ["CHAVE_NFE = '${chave}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        await insereValorPesquisaVarios('txtNota', 'FATURA', 'CHAVE_NFE', jsonStr.RESULT[0]);
        $('#txtChave').val('')
      } finally {
        $.LoadingOverlay('hide')
      }
    }
  });

  $('#btnCancelarWhatsapp').on('click', function () {
    $('#txtMensagem').val('');
    $('#txtContato').val('');
    $('#modalWhatsapp').modal('hide');
  });

  $('#btnEnviarWhatsapp').on('click', async function () {
    $.LoadingOverlay('show');
    try {
      if (!await utilizaWhatsapp()) {
        msgAlerta('O sistema de envio de mensagens pelo WhatsApp não está configurado. Por favor, entre em contato com o suporte técnico.');
        return;
      };

      const codrep = pegaChave('#txtContato');

      if (!codrep) {
        msgAlerta('Por favor, selecione um representante para enviar a mensagem pelo WhatsApp.');
        return;
      };

      const pesquisa = {
        camposSelect: ['TELEFONE'],
        tabela: 'REPRESEN',
        where: [`CODREP = '${codrep}'`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

      const telefone = jsonStr[0].TELEFONE.trim().replace(' ', '');

      await enviarMensagem(telefone, $('#txtMensagem').val(), 'RelMinutaWeb', 'Minuta');

      criaMensagemSucesso('Mensagem enviada com sucesso pelo WhatsApp!');

      $('#txtMensagem').val('');
      $('#txtContato').val('');
    } catch (error) {
      console.error(error);
      msgAlerta('Não foi possível enviar a mensagem pelo WhatsApp. Verifique e tente novamente. Erro: ' + error.message);
    } finally {
      $.LoadingOverlay('hide');
      $('#modalWhatsapp').modal('hide');
    }
  });

  async function addPesquisaAutocompleta() {
    $('#txtCliente').pesquisa_variosServerside(3, `{ "tabela":"entidade", "camposSelect":[ "codcli", "nome"], "where": null}`, 'CODCLI', 'NOME');
    $('#txtRepresentante').pesquisa_variosServerside(1, `{ "tabela":"REPRESEN", "camposSelect":["CODREP", "NOME"], "where": null}`, 'CODREP', 'NOME');
    $('#txtTransportadora').pesquisa_variosServerside(1, `{ "tabela":"TABTRAN", "camposSelect":["CODIGO", "NOME"], "where": null}`, 'CODIGO', 'NOME');
    $('#txtTipoCliente').pesquisa_variosServerside(1, `{ "tabela":"SITCLI", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
    $('#txtUf').pesquisa_variosServerside(1, `{ "tabela":"TABUF", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`, 'CODIGO', 'DESCRICAO');
    const sWhereOperFiscal = await retornaWhereOperFiscalUsuario(getCookie('cod_usuario'));
    $('#txtOperacaoFiscal').pesquisa_variosServerside(1, `{ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ${sWhereOperFiscal}}`, 'CODIGO', 'DESCRICAO');
    $('#txtPlaca').pesquisa_variosServerside(1, `{ "tabela":"VEICULO", "camposSelect":["PLACA", "MODELO"], "where": null}`, 'PLACA', 'MODELO');
    $('#txtTipoVenda').pesquisa_variosServerside(1, `{ "tabela":"TIPO", "camposSelect":["ID", "DESCRICAO"], "where": null}`, 'ID', 'DESCRICAO');
    $('#txtNota').pesquisa_variosServerside(3, `{ "tabela":"NOTA", "camposSelect":["FATURA", "CHAVE_NFE"], "where": null}`, 'FATURA', 'CHAVE_NFE');
    $('#txtMinuta').pesquisa_variosServerside(3, `{ "tabela":"NOTA_EMBARQUE", "camposSelect":["NUMERO", "DT_CADASTRO"], "where": null}`, 'NUMERO', 'DT_CADASTRO');

    $('#btn-Cliente').pesquisa_serversideSel('#txtCliente', '{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": null}', 'Pesquisa Cliente');
    $('#btn-Representante').pesquisa_serversideSel('#txtRepresentante', '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'Pesquisa Representante');
    $('#btn-Transportadora').pesquisa_serversideSel('#txtTransportadora', '{"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora');
    $('#btn-TipoCliente').pesquisa_serversideSel('#txtTipoCliente', '{"tabela":"SITCLI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Cliente');
    $('#btn-Uf').pesquisa_serversideSel('#txtUf', '{"tabela":"TABUF", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa UF');
    $('#btn-OperacaoFiscal').pesquisa_serversideSel('#txtOperacaoFiscal', `{"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ${sWhereOperFiscal}}`, 'Pesquisa Operação Fiscal');
    $('#btn-Placa').pesquisa_serversideSel('#txtPlaca', '{"tabela":"VEICULO", "camposSelect":[ "PLACA", "MODELO" ], "where": null}', 'Pesquisa Placa');
    $('#btn-TipoVenda').pesquisa_serversideSel('#txtTipoVenda', '{"tabela":"TIPO", "camposSelect":[ "ID", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda');
    $('#btn-Nota').pesquisa_serversideSel('#txtNota', '{ "tabela":"NOTA", "camposSelect":["FATURA", "CHAVE_NFE"], "where": null}', 'Pesquisa Nota');
    $('#btn-Minuta').pesquisa_serversideSel('#txtMinuta', '{ "tabela":"NOTA_EMBARQUE", "camposSelect":["NUMERO", "DT_CADASTRO"], "where": null}', 'Pesquisa Minuta');

    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').empty().trigger('change'); });
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').empty().trigger('change') });
    $('#btn-limpa-Transportadora').on('click', function () { $('#txtTransportadora').empty().trigger('change') });
    $('#btn-limpa-TipoCliente').on('click', function () { $('#txtTipoCliente').empty().trigger('change') });
    $('#btn-limpa-Uf').on('click', function () { $('#txtUf').empty().trigger('change') });
    $('#btn-limpa-OperacaoFiscal').on('click', function () { $('#txtOperacaoFiscal').empty().trigger('change') });
    $('#btn-limpa-Placa').on('click', function () { $('#txtPlaca').empty().trigger('change') });
    $('#btn-limpa-TipoVenda').on('click', function () { $('#txtTipoVenda').empty().trigger('change') });
    $('#btn-limpa-Nota').on('click', function () { $('#txtNota').empty().trigger('change') });
    $('#btn-limpa-Minuta').on('click', function () { $('#txtMinuta').empty().trigger('change'); });

    componenteFiltro('vendedor', false, false, 'Contato');
  }

  //Faz a pesquisa se vier da tela de Impressão de NFe
  if (sessionStorage.getItem('imprimir_minuta') !== '') {
    $('#modal-filtros').modal('show');
    let fatura = sessionStorage.getItem('imprimir_minuta')
    $.LoadingOverlay('show')
    try {
      let response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"NOTA", 
            "camposSelect":["FATURA", "CHAVE_NFE"], 
            "where": ["FATURA = '${fatura}'"]}`,
        null
      );

      if (!response) {
        return;
      }
      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      await insereValorPesquisaVarios('txtNota', 'FATURA', 'CHAVE_NFE', jsonStr.RESULT[0]);
      $('#btnConsultar').trigger('click');

    } finally {
      sessionStorage.setItem('imprimir_minuta', '');
      $.LoadingOverlay('hide')
    }
  }
});


