$(document).ready(async function () {

    var ultimaColunaOrdenada = {
        nome: '',
        ordenacao: 'ASC'
    };

    $('#tutorial').on('click', function () {
        $(document).ready(async function () {
            const driver = new Driver({
                doneBtnText: 'Sair',
                closeBtnText: 'Fechar',
                nextBtnText: 'Próximo',
                prevBtnText: 'Anterior',
                allowClose: false
            });
            driver.defineSteps([{
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnImprimir',
                popover: {
                    title: 'Botão Imprimir',
                    description: 'Clique aqui para Imprimir um relatório.',
                    position: 'right'
                }
            }
            ]);
            driver.start();
        });
    });

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relPedidos == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPedidos: [] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPedidos: novasColunas }))

            $('#tabelaRelPedidos').DataTable().columns().visible(true);
            // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

            $('#tabelaRelPedidos').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })


    $('#btnSelecionarEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO CHAVE", "ENTIDADE.NOME DESCRICAO" ], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where":["PEDIDO.EMP_ID IN (${getCookie('emp_id')}) "]}`);
    $('#btnPedido').pesquisa_serverside(['#txtPedido'], ['PEDIDO.NUMERO'], ['ENTIDADE.NOME'], `{ "tabela":"PEDIDO", "camposSelect":[ "PEDIDO.NUMERO", "ENTIDADE.NOME"], "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = PEDIDO.CODCLI"}], "where":["PEDIDO.EMP_ID IN (${getCookie('emp_id')}) "]}`, 'Pesquisa de Pedido');
    componenteFiltro('cliente', true);
    componenteFiltro('representante', true, false);
    componenteFiltro('moeda', true, false);
    componenteFiltro('status', true);
    componenteFiltro('cliente', true, true, 'Responsavel');
    componenteFiltro('tipo', true, true);

    $('#btnFiltros').on('click', async function () {
        $('#modal-filtros').modal('show');
    });

    $('#btnLimpaPedido').on('click', function () {
        if ($('#txtPedido').val() == '') {
            $('#listaPedido').val('');
        }
        $('#txtPedido').val('');
        $('#txtPedido').focus();
    });

    $('#btnLimparFiltros').on('click', function () {
        $('#txtDtEmissaoDe').val('1200-01-01');
        $('#txtDtEmissaoAte').val('2500-12-31');
        $('#txtDtFaturadoDe').val('1200-01-01');
        $('#txtDtFaturadoAte').val('2500-12-31');
        $('#txtPedido').val('');
        $('#txtCliente').empty().trigger('change');
        $('#txtRepresentante').empty().trigger('change');
        $('#txtMoeda').empty().trigger('change');
        $("#txtStatus").empty().trigger('change');
        $("#txtResponsavel").empty().trigger('change');
        $("#txtTipo").empty().trigger('change');
    });

    retornaHintRelatorio('btnImprimir', 'RelPedidos')

    await preencheOrdenacaoTela('RelPedidos');

    $('#btnImprimir').on('click', async function () {
        try {
            $.LoadingOverlay('show');
            try {
                let url = `/sisplan/impressao/v1/relpedidos?`;

                const filtros = await retornaFiltros();
                const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidos');
                const ordem = `&TELA_ORDENACAO=RelPedidos&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
                let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 1000000, false, 'RelPedidos');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                    }
                    await limparRelatorios();
                }

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    });


    async function buscaDados(colunaOrdenacao = '') {

        ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
        ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

        const sTipo = $($("[name='tipo']").toArray().filter(radio => radio.checked == true)).parent().text().substring();
        const where = await montaWherePesquisa(sTipo, 'MAIS');
        const leftJoin = await montaLeftJoinPesquisa();
        const campos = await montaCamposSelect('MAIS');
        const groupBy = await montaGroupBy();
        // var ordemOrdenacao = `1`;
        let dataSetCols = [];

        const orderBy = colunaOrdenacao == '' ? '1' : colunaOrdenacao;
        //      orderby = ['QTDE']
        try {
            try {
                $.LoadingOverlay("show");

                for (let i = 0; i < campos.colunas.length; i++) {
                    dataSetCols.push({
                        'title': campos.colunas[i],
                        'data': campos.colunas[i]
                    });
                }

                // const ajaxData = {
                //     "EMPRESA": getCookie('empresa'),
                //     "JSON": `{"tabela":"PEDIDO", "camposSelect": ${campos.camposSelect}, "innerJoin": [${innerJoin}], "leftJoin": [${leftJoin}], "where": ["1=1 ${where}"], "groupby": ${groupBy}, "orderby": ${orderBy}}`,
                //     "CLIENTE": 'N',
                // };

                const pesquisa = {
                    tabela: 'PEDIDO',
                    camposSelect: campos.camposSelect,
                    leftJoin: leftJoin,
                    where: [`1=1 ${where}`],
                    groupby: groupBy,
                    orderby: [orderBy]
                }

                $('#tabelaRelPedidos').DataTable({
                    paging: true,
                    lengthChange: true,
                    filter: false,
                    info: true,
                    order: false,
                    autoWidth: true,
                    destroy: true,
                    serverSide: true,
                    processing: true,
                    colReorder: true,
                    ajax: {
                        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                        type: "POST",
                        headers: {
                            'Authorization': BASIC_AUTH
                        },
                        data: {
                            EMPRESA: getCookie('empresa'),
                            JSON: JSON.stringify(pesquisa),
                        },
                        dataSrc: function (data) {
                            const cols = campos.colunas;
                            const array = data.data;
                            return array.map(row => {
                                return row.reduce((obj, value, index) => {
                                    obj[cols[index]] = value;
                                    return obj;
                                }, {});
                            });
                        }
                    },
                    columns: dataSetCols,
                    "columnDefs": [
                        {
                            "render": function (data) {
                                return parseFloat(data.replace(',', '.')).toLocaleString('pt-br', {
                                    style: 'currency',
                                    currency: 'BRL'
                                });
                            },
                            "targets": [8, 9],
                            "className": 'pr-4 text-right'
                        },
                        {
                            "targets": [5, 6, 7],
                            "className": 'pr-4 text-right'
                        }
                    ],
                });

                const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

                $('#tabelaRelPedidos_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
                $('#tabelaRelPedidos_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

                $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
                $('#buttonExcel').prop('title', 'Exportar')

                $('#buttonColVis').on('click', async function () {
                    $.LoadingOverlay('show');
                    $('#modal-ColunasVisiveis').modal('show');
                    $.LoadingOverlay('hide');
                });

                $('#buttonExcel').on('click', async function () {
                    const url = '/Sisplan/Funcoes/v1/pesquisa?';
                    const sTipo = $($("[name='tipo']").toArray().filter(radio => radio.checked == true)).parent().text().substring();
                    const where = await montaWherePesquisa(sTipo, 'SOMA');
                    const leftJoin = await montaLeftJoinPesquisa();
                    const campos = await montaCamposSelect('SOMA');
                    const groupBy = await montaGroupBy();
                    const pesquisa = {
                        tabela: 'PEDIDO',
                        camposSelect: campos.camposSelect,
                        leftJoin: leftJoin,
                        where: [`1=1 ${where}`],
                        groupby: groupBy,
                        orderby: [orderBy]
                    }
                    await exportaCSV(url, `JSON=${encodeURIComponent(JSON.stringify(pesquisa))}`, true, null, 'Relatório de Pedidos', '#tabelaRelPedidos');
                })


                $('#tabelaRelPedidos').DataTable().columns().every(
                    function () {
                        if ((colunasInvisiveis.relPedidos).indexOf(this.dataSrc()) != -1) {
                            this.visible(false);
                        }
                    })


                $('#tabelaRelPedidos th').unbind('click');
                $('#tabelaRelPedidos th').on('click', async function () {
                    const nomeColuna = $(this).html();
                    const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
                    const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
                    await buscaDados(nomeColuna + ' ' + ordenacao);
                });
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível buscar os dados.');
            }
        } finally {
            $.LoadingOverlay("hide");
            $('#modal-filtros').modal('hide');
        }

    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaRelPedidos').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relPedidos ?? [])
    })

    async function retornaFiltros() {
        const sTipo = $($("[name='tipo']").toArray().filter(radio => radio.checked == true)).parent().text().substring();
        const sEmissaoDe = $('#txtDtEmissaoDe').val();
        const sEmissaoAte = $('#txtDtEmissaoAte').val();
        const sFaturadoDe = $('#txtDtFaturadoDe').val();
        const sFaturadoAte = $('#txtDtFaturadoAte').val();
        const sCliente = await formataListas($('#txtCliente').val().toString());
        const sPedido = pegaChave('#txtPedido');
        const sRepresentante = await formataListas($('#txtRepresentante').val().toString());
        const sMoeda = await formataListas($('#txtMoeda').val().toString());
        const sEmp = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];
        const status = await formataListas($("#txtStatus").val().toString());
        const tipo = await formataListas($("#txtTipo").val().toString());
        const filtroEmpresas = await formataListas(sEmp.toString(), true)

        const params = `EMISSAO_DE=${sEmissaoDe}` +
            `&EMISSAO_ATE=${sEmissaoAte}` +
            `&FATURADO_DE=${sFaturadoDe}` +
            `&FATURADO_ATE=${sFaturadoAte}` +
            `&CLIENTE=${sCliente}` +
            `&PEDIDO=${sPedido}` +
            `&TIPO=${sTipo}` +
            `&REPRESENTANTE=${sRepresentante}` +
            `&MOEDA=${sMoeda}` +
            `&EMPRESAS_FILTRO=${filtroEmpresas}` +
            `&TP_VENDA=${tipo}` +
            `&STATUS=${status}`;

        return params;
    }

    async function montaWherePesquisa(tipo, soma) {
        const dataFaturadoDe = $('#txtDtFaturadoDe').val() != '1200-01-01' ? ` AND NT.DT_EMISSAO >= '${$('#txtDtFaturadoDe').val()}'` : '';
        const dataFaturadoAte = $('#txtDtFaturadoAte').val() != '2500-12-31' ? ` AND NT.DT_EMISSAO <= '${$('#txtDtFaturadoAte').val()}'` : '';
        const emp = $('.empresa_selecionada:checked').toArray().length > 0
            ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        let where = '';
        where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}'` : '';
        where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}'` : '';
        where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI IN (${await formataListas($('#txtCliente').val().toString())})` : '';
        where += $('#txtPedido').val() != '' ? ` AND PEDIDO.NUMERO = '${pegaChave('#txtPedido')}'` : '';
        where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP IN (${await formataListas($('#txtRepresentante').val().toString())})` : '';
        where += $('#txtMoeda').val() != '' ? ` AND PEDIDO.MOEDA IN (${await formataListas($('#txtMoeda').val().toString())})` : '';
        where += $("#txtStatus").val() != '' ? ` AND PEDIDO.STATUS IN (${await formataListas($("#txtStatus").val().toString())})` : "";
        where += $('#txtResponsavel').val() != '' ? ` AND PEDIDO.RESPONSAVEL IN (${await formataListas($('#txtResponsavel').val().toString())})` : '';
        where += $('#txtTipo').val() != '' ? ` AND PEDIDO.ID_TIPO IN (${await formataListas($('#txtTipo').val().toString())})` : '';
        // where += `AND PED_ITEN.QTDE + PED_ITEN.QTDE_F + PED_ITEN.QTDE_CANC > 0`;
        switch (tipo) {
            case 'Todos':
                if (dataFaturadoDe != '' || dataFaturadoAte != '') {

                    where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER [JOIN NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        ) `;

                }
                break;

            case 'Pendentes':
                where += `AND PED_ITEN.QTDE > 0`;

                if (dataFaturadoDe != '' || dataFaturadoAte != '') {

                    where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER [JOIN NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        ) `;

                }
                break;

            case 'Faturados/NF':

                where += ` AND EXISTS (
                    SELECT NT.FATURA
                    FROM [NOTAITEN] NTI
                    INNER JOIN [NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                    WHERE NTI.PEDIDO = PEDIDO.NUMERO
                    ${dataFaturadoDe}
                    ${dataFaturadoAte}
                    AND ((NT.NOTA_DEV = '') OR (NT.NOTA_DEV IS NULL))
                    AND NTI.EMPENHO <> 'S'
                    ) `;

                break;

            case 'Cancelados':
                where += `AND PED_ITEN.QTDE_CANC > 0`;

                if (dataFaturadoDe != '' || dataFaturadoAte != '') {

                    where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER [JOIN NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        ) `;

                }
                break;

            case 'Faturados/Pedido(Ped)':
                where += `AND PED_ITEN.QTDE_F > 0`;

                where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER JOIN [NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        AND ((NTI.FATURA = '') OR (NTI.FATURA IS NULL))
                        ) `;


                break;

            case 'Faturado(NF)/Pendentes(Ped)':
                where += `AND (PED_ITEN.QTDE_F [${soma}] PED_ITEN.QTDE) > 0`

                where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER JOIN [NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        AND ((NTI.FATURA = '') OR (NTI.FATURA IS NULL))
                        ) `;


                break;

            case 'Pedidos Encerrados':
                where += `AND PED_ITEN.QTDE <= 0`;

                if (dataFaturadoDe != '' || dataFaturadoAte != '') {

                    where += ` AND EXISTS (
                        SELECT NT.FATURA
                        FROM [NOTAITEN] NTI
                        INNER [JOIN NOTA] NT ON (NT.FATURA = NTI.FATURA AND NTI.SERIE = NT.SERIE)
                        WHERE NTI.PEDIDO = PEDIDO.NUMERO
                        ${dataFaturadoDe}
                        ${dataFaturadoAte}
                        ) `;

                }
                break;
        }

        if (emp != '') {
            where += ` AND PEDIDO.EMP_ID IN (${emp})`;
        }

        return where;
    }

    async function montaLeftJoinPesquisa() {

        const ligacao = [{ "tabela": "PED_ITEN", "condicao": "PEDIDO.NUMERO = PED_ITEN.NUMERO" },
        { "tabela": "ENTIDADE", "condicao": "PEDIDO.CODCLI = ENTIDADE.CODCLI" },
        { "tabela": "REPRESEN", "condicao": "PEDIDO.CODREP = REPRESEN.CODREP" },
        { "tabela": "MOEDA", "condicao": "PEDIDO.MOEDA = MOEDA.CODMOE" },
        { "tabela": "SITPROD", "condicao": "PEDIDO.STATUS = SITPROD.CODIGO" },
        { "tabela": "TABTRAN", "condicao": "PEDIDO.TAB_TRANS = TABTRAN.CODIGO" }];

        return ligacao;
    }

    async function montaCamposSelect(soma) {

        const camposSelect = [
            "PEDIDO.NUMERO",
            "ENTIDADE.NOME AS CLIENTE",
            "REPRESEN.NOME AS REPRESENTANTE",
            "TABTRAN.NOME AS TRANSPORTADORA",
            "MOEDA.DESCRICAO AS MOEDA",
            "SUM(PED_ITEN.QTDE [" + soma + "] PED_ITEN.QTDE_CANC [" + soma + "] PED_ITEN.QTDE_F) AS QTDE",
            "SUM(PED_ITEN.QTDE) AS QTDE_PENDENTE",
            "SUM(PED_ITEN.QTDE_F) AS QTDE_FATURADA",
            "COALESCE(SUM(CAST(CAST(COALESCE(PED_ITEN.PRECO, 0) AS NUMERIC(18,4)) * CAST(COALESCE(PED_ITEN.QTDE_F, 0) AS NUMERIC(18,4)) AS NUMERIC(18,4))), 0.00) AS VALOR_FATURADO",
            "COALESCE(CAST(SUM(CAST(PED_ITEN.PRECO AS NUMERIC(18,4)) * CAST(COALESCE(PED_ITEN.QTDE [" + soma + "] PED_ITEN.QTDE_F, 0) AS NUMERIC(18,4))) * CAST((100.00 - COALESCE(PEDIDO.PER_DESC [" + soma + "] PEDIDO.PERC_DESC_EMPENHO, 0)) / 100.00 AS NUMERIC(18,4)) AS NUMERIC(18,4)), 0.00) AS TOTAL_LIQ",
            "PEDIDO.DT_EMISSAO",
            "PEDIDO.DT_FATURA",
            "SITPROD.DESCRICAO AS STATUS",
            "PEDIDO.PED_CLI",
            "PEDIDO.NOTA",
            "PEDIDO.PRZ_MEDIO AS PRAZO_MED"
        ];



        const colunas = ["NUMERO", "CLIENTE", "REPRESENTANTE", "TRANSPORTADORA", "MOEDA", "QTDE", "QTDE_PENDENTE", "QTDE_FATURADA", "VALOR_FATURADO", "TOTAL_LIQ", "DT_EMISSAO", "DT_FATURA", "STATUS", "PED_CLI", "NOTA", "PRAZO_MED"];

        return objeto = {
            camposSelect: camposSelect,
            colunas: colunas
        };
    }

    async function montaGroupBy() {

        const groupBy = ["PEDIDO.NUMERO", "ENTIDADE.NOME", "REPRESEN.NOME", "TABTRAN.NOME", "MOEDA.DESCRICAO", "PEDIDO.DT_EMISSAO", "PEDIDO.DT_FATURA",
            "PEDIDO.PER_DESC", "PEDIDO.PERC_DESC_EMPENHO", "SITPROD.DESCRICAO", "PEDIDO.PED_CLI", "PEDIDO.NOTA", "PEDIDO.PRZ_MEDIO"];

        return groupBy;
    }

    $('#btnConsultar').on('click', async function () {
        await buscaDados();
    });

});