$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnIncluir",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um Tipo de Contato.",
          position: "right",
        },
      },
      {
        element: "#tabelaTipo",
        popover: {
          title: "Tabela Tipos de Contato",
          description: "Aqui estão os dados dos Tipos de Contatos cadastrados.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {

  const permissaoUsuarioLogado = await permissaoAcessos("TIPOCONTATO");

  $("#txtTipoContato").autocompleta(1, `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $("#btn-TipoContato").pesquisa("#txtTipoContato", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa CST PIS", "TIPO_CONTATO");
  $("#btn-limpa-TipoContato").on("click", function () { $("#txtTipoContato").val(""); });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnIncluir").on("click", function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "tipocontato/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultar();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtTipoContato").val("");
  });

  $("#tabelaTipo").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTipo").DataTable().row($(this).parents("tr")).data();
      window.location.href = `tipocontato/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaTipo").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaTipo").DataTable().row($(this)).data();
      window.location.href = `tipocontato/${data.CODIGO}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaTipo').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaTipo").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  consultar();

  async function consultar() {
    try {
      $.LoadingOverlay("show");

      const cstpis = pegaChave("#txtTipoContato") != "" ? ` AND CODIGO = '${pegaChave("#txtTipoContato")}'` : "";
      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${cstpis}"]}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadTipoContato == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoContato: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaTipo").DataTable({
        destroy: true,
        lengthChange: true,
        paging: true,
        searching: true,
        scrollX: true,
        scrollY: '350px',
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
            title: "Código"
          },
          {
            data: "DESCRICAO",
            title: "Descrição"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaTipo_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaTipo_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaTipo").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Tipo de Contato', '', '', 999, false, false, dados);
      });

      $('#tabelaTipo').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadTipoContato).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaTipo').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadTipoContato ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODIGO"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadTipoContato: novasColunas }));

      $('#tabelaTipo').DataTable().columns().visible(true);

      $('#tabelaTipo').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/tipocontato?", `CODIGO=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }
        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }

});
