
function AbreMapa(uf, uf_conv, valMin, valMax, mapa) {
  var mapaEstadoChart = new FusionCharts({
    type: uf,
    renderAt: 'mapa_estado',
    width: '90%',
    height: '92.5%',
    dataFormat: 'json',
    dataSource: {
      colorrange: {
        "minvalue": "0",
        "startlabel": "Poucas vendas",
        "endlabel": "Muitas vendas",
        "code": "#e44a00",
        "gradient": "1",
        "color": [{
          "maxvalue": valMin,
          "displayvalue": "Araste para mostrar as maiores vendas",
          "code": "#6baa01"
        }, {
          "maxvalue": valMax,
          "code": "#f8bd19"
        }]
      },
      "chart": {
        "theme": $('html').hasClass('theme-light') ? "fint" : "candy",
        //"caption": 'Teste',
        //"subcaption": "",
        "showMarkerLabels": "0",
        "numberSuffix": "", //Changing connector hover color
        "connectorHoverColor": "#f8bd19", //Changing connector hover thickness
        "connectorHoverThickness": "3", //Enabling entity hover effect
        //Enabling marker hover effect
        "showMarkerHoverEffect": "1", //Changing marker fill color on hover
        "markerFillHoverColor": "#cccccc",
        "entityFillHoverColor": "#000",
        "entityFillHoverAlpha": "30",
        "showLabels": "0",
        "formatNumberScale": "10",
        "decimalSeparator": ",",
        "thousandSeparator": "."
      },
      "data": this['grafico' + mapa + uf_conv]
    }
  }).render();


}
function ShowMap(estado, mapa, titulo, valMin, valMax) {
  var uf = estado.toLowerCase().replace(/ /g, "");
  var converte = {};
  converte.santacatarina = "SC";
  converte.riograndedosul = "RS";
  converte.parana = "PR";
  converte.saopaulo = "SP";
  converte.riodejaneiro = "RJ";
  converte.exportacao = "EX";
  converte.sergipe = "SE";
  converte.amazonas = "AM";
  converte.distritofederal = "DF";
  converte.minasgerais = "MG";
  converte.bahia = "BA";
  converte.paraiba = "PB";
  converte.tocantins = "TO";
  converte.para = "PA";
  converte.rondonia = "RO";
  converte.matogrossodosul = "MS";
  converte.alagoas = "AL";
  converte.matogrosso = "MT";
  converte.piaui = "PI";
  converte.espiritosanto = "ES";
  converte.pernambuco = "PE";
  converte.acre = "AC";
  converte.amapa = "AP";
  converte.ceara = "CE";
  converte.goias = "GO";
  converte.maranhao = "MA";
  converte.riograndedonorte = "RN";
  converte.roraima = "RR";
  var state = converte[uf];

  $('#mapa_modal_msg').html("Municípios em azul não houve vendas.");
  $('#cidades_vendas').hide();
  // $('#mapa_estado_cidades').html('<ul id="ul_cidades"></ul>');
  // $('#btnMapaCidadesComVendas').unbind("click");
  // $("#btnMapaCidadesComVendas").bind("click", function () {
  //   $('#ul_cidades').html('<table class="table table-sm table-condensed table-striped"><thead><tr><th scope="col">CODIGO</th><th scope="col">CIDADE</th></tr></thead><tbody id="table-body"></tbody> </table>');
  //   $('#mapaModalCidadesLabel').html('Cidades Atendidas');
  //   $.each(window['grafico' + posicao + state + '_cidades'], function (index, cidade) {
  //     $('#table-body').append('<tr><td>' + cidade.id + '</td><td>' + cidade.sigla + '</td></tr>');
  //   });
  //   $('#ul_cidades').append('</tbody> </table> ');
  //   setTimeout(function () { $('#mapaModalCidades').modal() }, 500);
  // });
  // $('#btnMapaCidadesSemVendas').unbind("click");
  // $("#btnMapaCidadesSemVendas").bind("click", function () {
  //   $('#ul_cidades').html('<table class="table table-sm table-condensed table-striped"><thead><tr><th scope="col">CODIGO</th><th scope="col">CIDADE</th></tr></thead><tbody id="table-body"></tbody> </table>');
  //   $('#mapaModalCidadesLabel').html('Cidades Não Atendidas');
  //   $.each(window['grafico' + posicao + state + '_cidades_s'], function (index, cidade) {
  //     $('#table-body').append('<tr><td>' + cidade.id + '</td><td>' + cidade.sigla + '</td></tr>');
  //   });
  //   $('#ul_cidades').append('</tbody> </table> ');
  //   setTimeout(function () { $('#mapaModalCidades').modal() }, 500);
  // });

  $('#mapaModalLabel').html(titulo);
  $('#mapa_estado').html(estado);
  $('#mapaModal').modal();
  if (!this['grafico' + mapa + converte[uf]]) {
    return false;
  }
  if (this['grafico' + mapa +converte[uf]].id = "5300108") {
    this['grafico' + mapa + converte[uf]].id = "BR.DF"
  }
  AbreMapa(uf, converte[uf], valMin, valMax, mapa);


}

$(function () {
  $(".control_state").each(function (i, val) {
    var data = store.get(val.name + "_show");
    if (data != 0 || data === null) {
      $("input[name='" + val.name + "']").attr("checked", "checked");
    } else {
      $("#" + val.name).parent().hide();
    }
  });
});
$(function () {
  $(".control_state").click(function () {
    if ($(this).is(":checked")) {
      store.set(this.name + "_show", 1);
      $("#" + this.name).parent().show();
    } else {
      store.set(this.name + "_show", 0);
      $("#" + this.name).parent().hide();
    }
  });
});
